/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.Closing;
import io.earcam.unexceptional.Exceptional;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Document {
    public static final String LOCAL_FILE = "file";
    public static final String REF_URL = "url";
    public static final String RAW_TEXT = "raw";
    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String DESCRIPTION = "description";
    public static final String CONTENT_TYPE = "contentType";
    private final Map<String, String> fields = new HashMap<String, String>();
    private final List<String> tokens = new ArrayList<String>();
    private final Path file;
    private final String refUrl;

    private Document(Path file, String refUrl) {
        this.file = file;
        this.refUrl = refUrl;
    }

    public Path file() {
        return this.file;
    }

    public String raw() {
        return this.fields.getOrDefault(RAW_TEXT, "");
    }

    public boolean hasRaw() {
        return this.fields.containsKey(RAW_TEXT);
    }

    public List<String> tokens() {
        return this.tokens;
    }

    public boolean hasTokens() {
        return !this.tokens.isEmpty();
    }

    public String refUrl() {
        return this.refUrl;
    }

    public String title() {
        return this.fields.getOrDefault(TITLE, "");
    }

    public void field(String key, String value) {
        this.fields.put(key, value);
    }

    public String field(String key) {
        return this.fields.getOrDefault(key, "");
    }

    public String contentType() {
        return this.fields.getOrDefault(CONTENT_TYPE, "");
    }

    public static Document document(Path baseDir, URI baseUri, Path file) {
        String relativeUri = Document.ensureTrailingSlash(baseUri, true);
        String refUrl = Document.relativizeReferenceUri(baseDir, relativeUri, file);
        Document document = new Document(file, refUrl);
        Document.deduceContentType(file, document);
        return document;
    }

    private static void deduceContentType(Path file, Document document) {
        String contentType = null;
        Iterator<Function> detectors = Arrays.asList(Document::probeContentType, Document::guessContentTypeFromStream, Document::guessContentTypeFromName).iterator();
        try {
            while (contentType == null && detectors.hasNext()) {
                contentType = (String)detectors.next().apply(file);
            }
        }
        catch (UncheckedIOException e) {
            Exceptional.swallow((Throwable)e);
        }
        document.field(CONTENT_TYPE, contentType);
    }

    private static String probeContentType(Path file) {
        return (String)Exceptional.apply(Files::probeContentType, (Object)file);
    }

    private static String guessContentTypeFromStream(Path file) {
        BufferedInputStream input = new BufferedInputStream((InputStream)Exceptional.apply(FileInputStream::new, (Object)file.toFile()));
        return (String)Closing.closeAfterApplying((AutoCloseable)input, URLConnection::guessContentTypeFromStream);
    }

    private static String guessContentTypeFromName(Path file) {
        return URLConnection.guessContentTypeFromName(file.getFileName().toString());
    }

    public static String relativizeReferenceUri(Path baseDir, String baseUri, Path file) {
        return baseUri + baseDir.toUri().relativize(file.toUri()).toString();
    }

    private static String ensureTrailingSlash(URI uri, boolean uriPathOnly) {
        String yuri = uriPathOnly ? uri.getPath() : uri.toString();
        return yuri.length() > 0 && yuri.charAt(yuri.length() - 1) == '/' ? yuri : yuri + '/';
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.fields);
        map.put(REF_URL, this.refUrl);
        map.put(TEXT, this.tokens.stream().collect(Collectors.joining(" ")));
        return map;
    }
}

