/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.Closing;
import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.site.search.offline.Component;
import io.earcam.utilitarian.site.search.offline.Document;
import io.earcam.utilitarian.site.search.offline.Indexer;
import io.earcam.utilitarian.site.search.offline.Javascript;
import io.earcam.utilitarian.site.search.offline.Resources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.WillNotClose;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexer
implements Indexer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexer.class);
    public static final String BASEDIR_WEBJARS_RESOURCES = "META-INF/resources/webjars/";
    public static final String VERSION_LUNR_JS = "2.1.0";
    public static final String LUNR = "META-INF/resources/webjars/lunr.js/2.1.0/lunr.js";
    public static final String OUTPUT_FILE = "outputFile";
    public static final String FIELDS = "fields";
    public static final String MAP_TITLES = "mapTitles";
    public static final String GENERATE_AUTOCOMPLETE = "generateAutocomplete";
    public static final String OUTPUT_CHARSET = "outputCharset";
    private Path outputFile;
    private String[] fields;
    private String refUrl;
    private Charset outputCharset;
    private Map<String, String> titlesMap = new HashMap<String, String>();
    private SortedSet<String> autocomplete = new TreeSet<String>();
    private BiConsumer<String, String> titleMapper = this.titlesMap::put;
    private Consumer<String> autocompleter = this.autocomplete::add;
    private Invocable engine;
    private Object javascriptIndexBuilder;

    @Override
    public void configure(Map<String, String> configuration) {
        this.outputCharset = Component.getOrDefault(configuration, OUTPUT_CHARSET, StandardCharsets.UTF_8);
        this.refUrl = Component.mandatory(configuration, "url");
        this.outputFile = Paths.get(Component.mandatory(configuration, OUTPUT_FILE), new String[0]);
        this.fields = Component.mandatory(configuration, FIELDS).split(",");
        if (!Component.getOrDefault(configuration, MAP_TITLES, true)) {
            this.titleMapper = (u, t) -> {};
        }
        if (!Component.getOrDefault(configuration, GENERATE_AUTOCOMPLETE, true)) {
            this.autocompleter = d -> {};
        }
        this.initialize();
    }

    private void initialize() {
        this.engine = DefaultIndexer.createSearchEngine("META-INF/resources/js/index.lunr.js");
        Map fieldConfigurations = Arrays.stream(this.fields).collect(Collectors.toMap(Function.identity(), v -> Collections.emptyMap()));
        this.javascriptIndexBuilder = Javascript.invokeFunction(this.engine, "createIndexBuilder", this.refUrl, fieldConfigurations);
    }

    static Invocable createSearchEngine(String script) {
        InputStream lunr = Resources.getResource(LUNR);
        InputStream indexScript = Resources.getResource(script);
        Objects.requireNonNull(lunr, "Could not load lunrjs lib");
        Objects.requireNonNull(indexScript, "Could not load indexScript");
        return Javascript.createJavascriptEngine(lunr, indexScript);
    }

    @Override
    public synchronized Indexer add(Stream<Document> documents) {
        Javascript.invokeFunction(this.engine, "addDocuments", this.javascriptIndexBuilder, documents.filter(Document::hasTokens).peek(d -> this.titleMapper.accept(d.refUrl(), d.title())).peek(d -> d.tokens().forEach(this.autocompleter::accept)).map(Document::asMap).iterator());
        return this;
    }

    @Override
    public void writeJson() {
        this.outputFile.getParent().toFile().mkdirs();
        if (this.isGzip()) {
            FileOutputStream fos = (FileOutputStream)Exceptional.apply(FileOutputStream::new, (Object)this.outputFile.toFile());
            Closing.closeAfterAccepting(GZIPOutputStream::new, (Object)fos, this::writeJson);
        } else {
            Closing.closeAfterAccepting(FileOutputStream::new, (Object)this.outputFile.toFile(), this::writeJson);
        }
    }

    private boolean isGzip() {
        return this.outputFile.getFileName().toString().endsWith(".gz");
    }

    protected void writeJson(@WillNotClose OutputStream output) throws IOException {
        this.writeIndex(output);
        this.writeAutocomplete(output);
        this.writeTitleMap(output);
    }

    private void writeIndex(OutputStream output) throws IOException {
        output.write(this.bytes("{\n\n\"index\": "));
        String indexJson = this.serializeIndex();
        byte[] bytes = this.bytes(indexJson);
        output.write(bytes);
        String id = this.id();
        LOG.debug("{} wrote {} bytes for index to {}", new Object[]{id, bytes.length, this.outputFile});
    }

    public byte[] bytes(String text) {
        return text.getBytes(this.outputCharset);
    }

    public String serializeIndex() {
        return (String)Javascript.invokeFunction(this.engine, "buildSerializedIndex", this.javascriptIndexBuilder);
    }

    private void writeAutocomplete(OutputStream output) throws IOException {
        byte[] bytes = this.bytes(this.autocomplete.stream().collect(Collectors.joining("\", \"", ",\n\n\"autocomplete\": [\"", "\"]")));
        output.write(bytes);
        String id = this.id();
        LOG.debug("{} wrote {} bytes for {} words for autocomplete to {}", new Object[]{id, bytes.length, this.autocomplete.size(), this.outputFile});
    }

    private void writeTitleMap(OutputStream output) throws IOException {
        byte[] bytes = this.bytes(this.titlesMap.entrySet().stream().map(e -> new StringBuilder().append('\"').append((String)e.getKey()).append('\"').append(':').append('\"').append((String)e.getValue()).append('\"')).collect(Collectors.joining(", ", ",\n\n\"titleMap\": {", "}\n}")));
        output.write(bytes);
        String id = this.id();
        LOG.debug("{} wrote {} bytes for {} entries for title map to {}", new Object[]{id, bytes.length, this.titlesMap.size(), this.outputFile});
    }

    public static String search(String indexJson, String query) throws ScriptException, NoSuchMethodException {
        Invocable engine = DefaultIndexer.createSearchEngine("META-INF/resources/js/json.search.lunr.js");
        return engine.invokeFunction("jsonSearchIndex", indexJson, query).toString();
    }
}

