/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.EmeticStream;
import io.earcam.utilitarian.site.search.offline.Document;
import io.earcam.utilitarian.site.search.offline.Processor;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Crawler {
    private Stream<Document> documents;

    public static Crawler crawler(Map<Path, URI> directories) {
        Crawler crawler = new Crawler();
        crawler.documents = Crawler.crawl(directories);
        return crawler;
    }

    private static Stream<Document> crawl(Map<Path, URI> directories) {
        return directories.entrySet().parallelStream().flatMap(Crawler::crawl);
    }

    private static Stream<Document> crawl(Map.Entry<Path, URI> pair) {
        return Crawler.crawl(pair.getKey(), pair.getValue());
    }

    private static Stream<Document> crawl(Path baseDir, URI baseUri) {
        return EmeticStream.emesis(x$0 -> Files.walk(x$0, new FileVisitOption[0]), (Object)baseDir).mapToStream().filter((? super T x$0) -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> Document.document(baseDir, baseUri, f));
    }

    public Crawler filter(Predicate<Document> filter) {
        this.documents = this.documents.filter(filter);
        return this;
    }

    public Crawler processor(Processor processor) {
        this.documents = this.documents.map(processor);
        return this;
    }

    public Stream<Document> documents() {
        return this.documents.filter(Document::hasTokens);
    }
}

