/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.utilitarian.site.search.offline.AbstractHtmlProcessor;
import io.earcam.utilitarian.site.search.offline.Document;
import java.io.File;
import java.nio.file.Path;
import java.util.function.Predicate;

abstract class AbstractHtmlReferenceProcessor
extends AbstractHtmlProcessor {
    private final Path main;
    private final Path test;
    private final String titlePrefix;

    AbstractHtmlReferenceProcessor(Path main, Path test, String titlePrefix) {
        this.main = main;
        this.test = test;
        this.titlePrefix = titlePrefix;
    }

    @Override
    public void process(Document document) {
        Path root;
        if (this.isHtml(document) && !document.hasRaw() && (root = this.refDocsRoot(document)) != null) {
            if (this.skip(document)) {
                this.nullContent(document);
            } else {
                this.proceed(document, root);
            }
        }
    }

    private void nullContent(Document document) {
        document.field("raw", "");
    }

    private void proceed(Document document, Path root) {
        String fqn = root.relativize(document.file()).toString();
        fqn = fqn.substring(0, fqn.lastIndexOf(46)).replace(File.separatorChar, '.');
        String simpleName = document.file().getFileName().toString();
        simpleName = simpleName.substring(0, simpleName.lastIndexOf(46));
        document.field("raw", fqn + " " + simpleName);
        document.field("title", this.titlePrefix + " " + simpleName);
        document.tokens().add(fqn);
        document.tokens().add(simpleName);
    }

    protected abstract boolean skip(Document var1);

    private Path refDocsRoot(Document document) {
        return this.matchingParent(document, p -> p.endsWith(this.main) || p.endsWith(this.test));
    }

    protected final Path matchingParent(Document document, Predicate<Path> match) {
        Path path = document.file();
        do {
            if (!match.test(path)) continue;
            return path;
        } while ((path = path.getParent()) != null);
        return null;
    }

    protected final boolean hasMatchingParent(Document document, Predicate<Path> match) {
        return this.matchingParent(document, match) != null;
    }
}

