/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.Closing;
import io.earcam.utilitarian.site.search.offline.Document;
import io.earcam.utilitarian.site.search.offline.Processor;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTokenizer
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTokenizer.class);

    public List<String> tokenize(String input) {
        try {
            return Closing.closeAfterApplying(this.createAnalyzer(), input, this::tokens);
        }
        catch (UncheckedIOException e) {
            LOG.warn("Failed to tokenize '{}', due to {}", (Object)input, (Object)e.getMessage());
            LOG.debug("Failed to tokenize", e.getCause());
            return Collections.emptyList();
        }
    }

    private List<String> tokens(Analyzer analyzer, String input) {
        return Closing.closeAfterApplying(analyzer.tokenStream(null, new StringReader(input)), this::streamTokens);
    }

    private List<String> streamTokens(TokenStream stream) throws IOException {
        stream.reset();
        ArrayList<String> tokens = new ArrayList<String>();
        while (stream.incrementToken()) {
            tokens.add(stream.getAttribute(CharTermAttribute.class).toString());
        }
        return tokens;
    }

    protected Analyzer createAnalyzer() {
        return new SimpleAnalyzer();
    }

    @Override
    public void process(Document document) {
        if (document.hasRaw() && !document.hasTokens()) {
            List<String> tokenized = this.tokenize(document.raw());
            document.tokens().addAll(tokenized);
        }
    }
}

