/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.unexceptional.Closing;
import io.earcam.utilitarian.io.ReplaceAllOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;

public final class Resources {
    public static final String UI_SCRIPT_SEARCH_FILE = "ui.search.lunr.js";
    public static final String RESOURCES_ROOT = "META-INF/resources/js/";
    public static final String SCRIPT_INDEX = "META-INF/resources/js/index.lunr.js";
    public static final String UI_SCRIPT_SEARCH = "META-INF/resources/js/ui.search.lunr.js";
    static final String SCRIPT_SEARCH = "META-INF/resources/js/json.search.lunr.js";
    public static final String CONFIGURATION_ROOT = "META-INF/configuration/";
    public static final String DEFAULT_CRAWLER_JSON = "META-INF/configuration/default-crawler-maven.json";
    public static final String DEFAULT_INDEXER_JSON = "META-INF/configuration/default-indexer-maven.json";

    private Resources() {
    }

    public static InputStream getResource(String resource) {
        return Resources.class.getClassLoader().getResourceAsStream(resource);
    }

    public static String getResource(String resource, Charset charset, Map<String, String> searchReplace) {
        ByteArrayOutputStream baos;
        OutputStream output = baos = new ByteArrayOutputStream();
        for (Map.Entry<String, String> e : searchReplace.entrySet()) {
            output = new ReplaceAllOutputStream(e.getKey().getBytes(charset), e.getValue().getBytes(charset), output);
        }
        Closing.closeAfterAccepting(Resources.getResource(resource), output, Resources::drain);
        return new String(baos.toByteArray(), charset);
    }

    private static void drain(InputStream input, OutputStream output) throws IOException {
        int b;
        while ((b = input.read()) != -1) {
            output.write(b);
        }
    }
}

