/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import io.earcam.utilitarian.site.search.offline.Component;
import io.earcam.utilitarian.site.search.offline.Crawler;
import io.earcam.utilitarian.site.search.offline.Filter;
import io.earcam.utilitarian.site.search.offline.Indexer;
import io.earcam.utilitarian.site.search.offline.Processor;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ConfigurationModel {
    private String id;
    private Map<String, String> configuration;

    static <T extends Component> T create(Class<T> type, ConfigurationModel model) {
        T component = ConfigurationModel.serviceById(type, model.getId());
        component.configure(model.getConfiguration());
        return component;
    }

    private static <S extends Component> S serviceById(Class<S> service, String id) {
        return (S)ConfigurationModel.serviceStream(service).filter(s -> id.equals(s.id())).findFirst().orElseThrow(() -> new IllegalStateException("Not SPI service with id '" + id + "' found of type '" + service.getCanonicalName() + "'"));
    }

    private static <S extends Component> Stream<S> serviceStream(Class<S> service) {
        return StreamSupport.stream(ServiceLoader.load(service).spliterator(), false);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public static class Crawling {
        private List<Mapping> mappings;
        private List<Step> steps;

        public List<Mapping> getMappings() {
            return this.mappings;
        }

        public void setMappings(List<Mapping> mappings) {
            this.mappings = mappings;
        }

        public List<Step> getSteps() {
            return this.steps;
        }

        public void setSteps(List<Step> steps) {
            this.steps = steps;
        }

        public Crawler build() {
            Crawler crawler = Crawler.crawler(this.mappings.stream().collect(Collectors.toMap(Mapping::dirAsPath, Mapping::getUri)));
            Set<String> filters = Crawling.serviceIds(Filter.class);
            Set<String> processors = Crawling.serviceIds(Processor.class);
            for (Step step : this.steps) {
                if (filters.contains(step.getId())) {
                    crawler.filter(ConfigurationModel.create(Filter.class, step));
                    continue;
                }
                if (processors.contains(step.getId())) {
                    crawler.processor(ConfigurationModel.create(Processor.class, step));
                    continue;
                }
                throw new IllegalStateException("No filter or processor found via SPI with ID '" + step.getId() + "'");
            }
            return crawler;
        }

        private static <S extends Component> Set<String> serviceIds(Class<S> service) {
            return ConfigurationModel.serviceStream(service).map(Component::id).collect(Collectors.toSet());
        }
    }

    public static class Indexing
    extends ConfigurationModel {
        public Indexer build() {
            return Indexing.create(Indexer.class, this);
        }
    }

    public static class Mapping {
        private File dir;
        private URI uri;

        public File getDir() {
            return this.dir;
        }

        static Path dirAsPath(Mapping mapping) {
            return mapping.getDir().toPath();
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }
    }

    public static class Step
    extends ConfigurationModel {
    }
}

