/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.site.search.offline;

import java.nio.charset.Charset;
import java.util.Map;

public interface Component {
    default public String id() {
        return this.getClass().getSimpleName();
    }

    default public void configure(Map<String, String> configuration) {
    }

    public static String mandatory(Map<String, String> configuration, String key) {
        if (configuration.containsKey(key)) {
            return configuration.get(key);
        }
        throw new NullPointerException("Missing mandatory configuration: " + key);
    }

    public static boolean getOrDefault(Map<String, String> configuration, String key, boolean defaultValue) {
        return Boolean.parseBoolean(configuration.getOrDefault(key, Boolean.toString(defaultValue)));
    }

    public static Charset getOrDefault(Map<String, String> configuration, String key, Charset defaultValue) {
        return Charset.forName(configuration.getOrDefault(key, defaultValue.toString()));
    }
}

