/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WiretapInputStream
extends InputStream {
    private InputStream tapped;
    private ByteArrayOutputStream tap;
    private boolean tapping;
    private boolean marked;
    private int mark;

    public WiretapInputStream(InputStream tapped, boolean tapOn) {
        this.tapping = tapOn;
        this.tapped = tapped;
        this.tap = new ByteArrayOutputStream();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marked = true;
        this.mark = 0;
        this.tapped.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.marked = false;
        this.tapped.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.tapping) {
            int b;
            int i = 0;
            while ((long)i++ < n && (b = this.tapped.read()) != -1) {
                this.tap.write(b);
            }
            return i;
        }
        return super.skip(n);
    }

    @Override
    public void close() throws IOException {
        this.tapped.close();
    }

    @Override
    public int read() throws IOException {
        int read = this.tapped.read();
        if (this.marked) {
            ++this.mark;
            if (this.tapping) {
                this.tap.write(read);
            }
        } else if (this.mark > 0) {
            --this.mark;
        } else if (this.tapping) {
            this.tap.write(read);
        }
        return read;
    }

    public byte[] toByteArray() {
        return this.tap.toByteArray();
    }

    public boolean tapping() {
        return this.tapping;
    }

    public void tapping(boolean tapOn) {
        this.tapping = tapOn;
    }

    public void tapOn() {
        this.tapping(true);
    }

    public void tapOff() {
        this.tapping(false);
    }
}

