/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import io.earcam.utilitarian.io.SplittableOutputStreamBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.function.Supplier;

public class SplittableOutputStream
extends OutputStream
implements SplittableOutputStreamBuilder,
SplittableOutputStreamBuilder.SplitOutputStreamBuilder {
    private final Supplier<OutputStream> supplier;
    private final byte[] header;
    private final byte[] footer;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private volatile OutputStream out = null;
    private long maxFileSize = Long.MAX_VALUE;
    private long maxRecordCount = Long.MAX_VALUE;
    private long bytesCount;
    private long recordsCount;
    private boolean inScope;

    private SplittableOutputStream(Supplier<OutputStream> supplier, byte[] head, byte[] footer) {
        this.supplier = supplier;
        this.header = head;
        this.footer = footer;
    }

    public static SplittableOutputStreamBuilder splittable(Supplier<OutputStream> next, byte[] head, byte[] footer) throws IOException {
        SplittableOutputStream splittable = new SplittableOutputStream(next, head, footer);
        splittable.reset();
        return splittable;
    }

    private void reset() throws IOException {
        this.recordsCount = 0L;
        this.bytesCount = 0L;
        byte[] bytes = this.buffer.toByteArray();
        this.buffer.reset();
        this.buffer.write(this.header);
        this.buffer.write(bytes);
    }

    @Override
    public SplittableOutputStreamBuilder.SplitOutputStreamBuilder maxSize(long bytes) {
        this.maxFileSize = bytes;
        SplittableOutputStream.checkSanity(this.header, this.footer, this.maxFileSize);
        return this;
    }

    @Override
    public SplittableOutputStreamBuilder.SplitOutputStreamBuilder maxCount(long numberOfRecords) {
        this.requireNaturalNumber(numberOfRecords);
        this.maxRecordCount = numberOfRecords;
        return this;
    }

    private void requireNaturalNumber(long number) {
        if (number <= 0L) {
            throw new IllegalArgumentException("A positive, non-zero value is required.  Received: " + number);
        }
    }

    @Override
    public SplittableOutputStream outputStream() throws IOException {
        return this;
    }

    private static void checkSanity(byte[] head, byte[] foot, long maxFileSize) {
        if ((long)(head.length + foot.length) > maxFileSize) {
            throw new IllegalArgumentException("header.length + footer.length > maxFileSize: " + head.length + " + " + foot.length + " > " + maxFileSize);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkBeforeWrite(1);
        this.buffer.write(b);
    }

    private void checkBeforeWrite(int pendingBytes) {
        if (!this.inScope) {
            throw new IllegalStateException("Record scope not started");
        }
        if ((long)(pendingBytes + this.header.length + this.footer.length) > this.maxFileSize) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.checkBeforeWrite(bytes.length);
        this.buffer.write(bytes);
    }

    public void beginRecord() {
        if (this.inScope) {
            throw new IllegalStateException("Record scope already started");
        }
        this.inScope = true;
    }

    public void endRecord() throws IOException {
        this.endScope();
        ++this.recordsCount;
        if (this.bufferIsTooLarge() || this.maxRecordsExceeded()) {
            this.endSplit();
        }
        if (this.recorded()) {
            this.writeBuffer();
        }
    }

    private void endScope() {
        if (!this.inScope) {
            throw new IllegalStateException("Record scope not started, cannot end");
        }
        this.inScope = false;
    }

    private boolean bufferIsTooLarge() {
        return this.bytesCount + (long)this.footer.length + (long)this.buffer.size() > this.maxFileSize;
    }

    private boolean maxRecordsExceeded() {
        return this.recordsCount > this.maxRecordCount;
    }

    private void endSplit() throws IOException {
        if (this.out != null) {
            this.out.write(this.footer);
            this.out.close();
            this.out = null;
            this.reset();
        }
    }

    private boolean recorded() {
        return this.recordsCount == 1L && this.buffer.size() > this.header.length || this.recordsCount != 1L && this.buffer.size() > 0;
    }

    private void writeBuffer() throws IOException {
        this.out().write(this.buffer.toByteArray());
        this.bytesCount += (long)this.buffer.size();
        this.buffer.reset();
    }

    private OutputStream out() {
        if (this.out == null) {
            this.out = this.supplier.get();
        }
        return this.out;
    }

    @Override
    public void close() throws IOException {
        if (this.recorded()) {
            throw new BufferUnderflowException();
        }
        this.endSplit();
        if (this.buffer.size() > this.header.length) {
            this.writeBuffer();
            this.endSplit();
        }
    }
}

