/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.io.IOException;
import java.io.OutputStream;

public final class ReplaceAllOutputStream
extends OutputStream {
    private final byte[] search;
    private final byte[] replace;
    private final OutputStream wrapped;
    private volatile int position;

    public ReplaceAllOutputStream(byte[] search, byte[] replace, OutputStream output) {
        this.search = search;
        this.replace = replace;
        this.wrapped = output;
        this.position = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position == this.search.length) {
            this.wrapped.write(this.replace);
            this.position = 0;
        }
        if (this.search[this.position] == b) {
            ++this.position;
        } else {
            this.wrapped.write(this.search, 0, this.position);
            this.wrapped.write(b);
            this.position = 0;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.position > 0) {
            this.wrapped.write(this.search, 0, this.position);
        }
        this.wrapped.close();
    }
}

