/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import io.earcam.unexceptional.Exceptional;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.function.Function;

class RecursivePathIterator
implements Iterator<Path> {
    private static final Function<Path, DirectoryStream<Path>> DEFAULT_STREAMER = Exceptional.uncheckFunction(Files::newDirectoryStream);
    private final Deque<Iterator<Path>> pending = new ArrayDeque<Iterator<Path>>();
    private final Function<Path, DirectoryStream<Path>> streamer;
    private Iterator<Path> current;

    RecursivePathIterator(Path root) {
        this(root, DEFAULT_STREAMER);
    }

    RecursivePathIterator(Path root, Function<Path, DirectoryStream<Path>> directoryStreamer) {
        this(directoryStreamer.apply(root).iterator(), directoryStreamer);
    }

    RecursivePathIterator(Iterator<Path> iterator, Function<Path, DirectoryStream<Path>> directoryStreamer) {
        this.current = iterator;
        this.streamer = directoryStreamer;
    }

    @Override
    public boolean hasNext() {
        return this.current.hasNext() || this.popPending();
    }

    private boolean popPending() {
        if (this.pending.isEmpty()) {
            return false;
        }
        this.current = this.pending.pop();
        return this.hasNext();
    }

    @Override
    public Path next() {
        Path next = this.current.next();
        if (next.toFile().isDirectory()) {
            this.pending.push(this.current);
            this.current = this.streamer.apply(next).iterator();
        }
        return next;
    }
}

