/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;

@ParametersAreNonnullByDefault
public final class IoStreams {
    private static final int BUFFER_SIZE = 8192;

    private IoStreams() {
    }

    public static byte[] readAllBytes(@WillNotClose InputStream input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoStreams.transfer(input, baos);
        return baos.toByteArray();
    }

    public static long transfer(@WillNotClose InputStream in, @WillNotClose OutputStream out) {
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(out, "out");
        byte[] buffer = new byte[8192];
        long count = 0L;
        try {
            int read;
            while ((read = in.read(buffer, 0, 8192)) != -1) {
                out.write(buffer, 0, read);
                count += (long)read;
            }
            return count;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

