/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class Filterator<E>
implements Iterator<E> {
    private Iterator<E> iterator;
    private Set<E> excludes;
    private E next;
    private boolean checked;

    Filterator(Iterator<E> iterator, E exclude) {
        this(iterator, Collections.singleton(exclude));
    }

    Filterator(Iterator<E> iterator, Set<E> excludes) {
        this.iterator = iterator;
        this.excludes = excludes;
    }

    @Override
    public boolean hasNext() {
        return this.checked || this.iterator.hasNext() && this.checkNext();
    }

    private boolean checkNext() {
        this.next = this.iterator.next();
        if (this.excludes.contains(this.next)) {
            return this.hasNext();
        }
        this.checked = true;
        return true;
    }

    @Override
    public E next() {
        if (!this.checked && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checked = false;
        return this.next;
    }
}

