/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import io.earcam.unexceptional.Closing;
import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.io.Filterator;
import io.earcam.utilitarian.io.RecursivePathIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ExplodedJarInputStream
extends JarInputStream {
    private static final Path MANIFEST_PATH = Paths.get("META-INF", "MANIFEST.MF");
    private Iterator<Path> iterator;
    private Path directory;
    private ExplodedJarEntry current;

    private ExplodedJarInputStream(Path directory, Iterator<Path> iterator) throws IOException {
        super(EmptyInputStream.EMPTY_INPUTSTREAM, false);
        this.directory = directory.toRealPath(new LinkOption[0]);
        this.iterator = iterator;
    }

    public static JarInputStream jarInputStreamFrom(Path path) throws IOException {
        return ExplodedJarInputStream.jarInputStreamFrom(path.toFile());
    }

    public static JarInputStream jarInputStreamFrom(File path) throws IOException {
        return path.isDirectory() ? ExplodedJarInputStream.explodedJar(path) : new JarInputStream(new FileInputStream(path));
    }

    public static ExplodedJarInputStream explodedJar(File directory) throws IOException {
        return ExplodedJarInputStream.explodedJar(directory.toPath());
    }

    public static ExplodedJarInputStream explodedJar(Path directory) throws IOException {
        if (!directory.toFile().isDirectory()) {
            throw new IOException("'" + directory + "' is not a directory");
        }
        RecursivePathIterator rpi = new RecursivePathIterator(directory);
        return new ExplodedJarInputStream(directory, new Filterator<Path>(rpi, MANIFEST_PATH));
    }

    @Override
    public JarEntry getNextJarEntry() throws IOException {
        this.current = this.iterator.hasNext() ? new ExplodedJarEntry(this.iterator.next().toRealPath(new LinkOption[0])) : null;
        return this.current;
    }

    @Override
    public Manifest getManifest() {
        Manifest manifest = null;
        Path file = this.directory.resolve(MANIFEST_PATH);
        if (file.toFile().exists()) {
            manifest = new Manifest();
            Closing.closeAfterAccepting(FileInputStream::new, file.toFile(), manifest::read);
        }
        return manifest;
    }

    private void checkCurrent() {
        if (this.current == null) {
            throw new UnsupportedOperationException(ExplodedJarInputStream.class + " does not work as a regular InputStream");
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCurrent();
        return this.current.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.checkCurrent();
        return this.current.available();
    }

    public class ExplodedJarEntry
    extends JarEntry {
        private Path path;
        private byte[] contents;
        private int position;

        public ExplodedJarEntry(Path path) {
            super(ExplodedJarInputStream.this.directory.relativize(path).toString());
            this.position = 0;
            this.path = path;
            this.setMethod(0);
        }

        public Path path() {
            return this.path;
        }

        @Override
        public boolean isDirectory() {
            return this.path().toFile().isDirectory();
        }

        @Override
        public FileTime getCreationTime() {
            return Exceptional.apply((x$0, x$1) -> Files.readAttributes(x$0, x$1, new LinkOption[0]), this.path(), BasicFileAttributes.class).creationTime();
        }

        @Override
        public FileTime getLastModifiedTime() {
            return Exceptional.apply(x$0 -> Files.getLastModifiedTime(x$0, new LinkOption[0]), this.path());
        }

        @Override
        public long getTime() {
            return this.getLastModifiedTime().toMillis();
        }

        @Override
        public long getSize() {
            return Exceptional.apply(Files::size, this.path());
        }

        private void loadContents() {
            if (this.contents == null) {
                this.contents = Exceptional.apply(Files::readAllBytes, this.path());
            }
        }

        @Deprecated
        public int read() {
            throw new UnsupportedOperationException("Never intended for public use. Agressively deprecated.");
        }

        public int read(byte[] b, int off, int len) {
            this.loadContents();
            int remaining = this.available();
            if (remaining == 0) {
                return -1;
            }
            int length = Math.min(remaining, len);
            System.arraycopy(this.contents, this.position, b, off, length);
            this.position += length;
            return length;
        }

        int available() {
            this.loadContents();
            return this.contents.length - this.position;
        }
    }

    private static class EmptyInputStream
    extends InputStream {
        public static final InputStream EMPTY_INPUTSTREAM = new EmptyInputStream();

        private EmptyInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }
    }
}

