/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class CountedInputStream
extends InputStream {
    private final InputStream delegate;
    private long count;
    private boolean marked;
    private long mark;

    public CountedInputStream(InputStream wrapped) {
        Objects.requireNonNull(wrapped);
        this.delegate = wrapped;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public synchronized long count() {
        return this.count;
    }

    public synchronized void resetCount() {
        this.count = 0L;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marked = true;
        this.delegate.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.marked = false;
        this.delegate.reset();
    }

    @Override
    public int read() throws IOException {
        int read = this.delegate.read();
        if (read != -1) {
            if (this.marked) {
                ++this.mark;
                ++this.count;
            } else if (this.mark > 0L) {
                --this.mark;
            } else {
                ++this.count;
            }
        }
        return read;
    }
}

