/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this(buffer, true);
    }

    public ByteBufferInputStream(ByteBuffer buffer, boolean duplicate) {
        this.buffer = duplicate ? buffer.duplicate() : buffer;
    }

    @Override
    public int read() {
        if (this.available() == 0) {
            return -1;
        }
        return 0xFF & this.buffer.get();
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int remaining = this.available();
        if (remaining == 0) {
            return -1;
        }
        int length = Math.min(len, remaining);
        this.buffer.get(b, off, length);
        return length;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int skipped = Math.min((int)n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + skipped);
        return skipped;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this.buffer.mark();
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
    }
}

