/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.unexceptional;

import io.earcam.unexceptional.CheckedBiConsumer;
import io.earcam.unexceptional.CheckedBiFunction;
import io.earcam.unexceptional.CheckedBinaryOperator;
import io.earcam.unexceptional.CheckedComparator;
import io.earcam.unexceptional.CheckedConsumer;
import io.earcam.unexceptional.CheckedFunction;
import io.earcam.unexceptional.CheckedIntConsumer;
import io.earcam.unexceptional.CheckedPredicate;
import io.earcam.unexceptional.CheckedRunnable;
import io.earcam.unexceptional.CheckedSupplier;
import io.earcam.unexceptional.CheckedToDoubleFunction;
import io.earcam.unexceptional.CheckedToIntBiFunction;
import io.earcam.unexceptional.CheckedToIntFunction;
import io.earcam.unexceptional.CheckedToLongFunction;
import io.earcam.unexceptional.UncheckedException;
import io.earcam.unexceptional.UncheckedInterruptException;
import io.earcam.unexceptional.UncheckedReflectiveException;
import io.earcam.unexceptional.UncheckedSecurityException;
import io.earcam.unexceptional.UncheckedUriSyntaxException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class Exceptional
implements Serializable {
    private static final long serialVersionUID = -1350140594550206145L;
    private static final Map<Class<? extends Throwable>, Function<Throwable, RuntimeException>> UNCHECK_MAP;
    public static final Thread.UncaughtExceptionHandler RETHROWING;
    public static final Thread.UncaughtExceptionHandler SWALLOWING;

    private Exceptional() {
        throw new IllegalStateException("Why on earth would you want to instantiate this?");
    }

    public static URL url(CharSequence earl) {
        try {
            return new URL(earl.toString());
        }
        catch (MalformedURLException e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static URL url(String protocol, String host, int port, String path, URLStreamHandler handler) {
        try {
            return new URL(protocol, host, port, path, handler);
        }
        catch (MalformedURLException e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static URI uri(CharSequence \u028ari) {
        try {
            return new URI(\u028ari.toString());
        }
        catch (URISyntaxException e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static URI uri(URL earl) {
        try {
            return earl.toURI();
        }
        catch (URISyntaxException e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static void swallow(Throwable caught) {
        Exceptional.resetIfInterrupt(caught);
        if (caught instanceof Error) {
            throw (Error)caught;
        }
    }

    public static void resetIfInterrupt(Throwable thrown) {
        if (thrown instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static RuntimeException rethrow(Throwable thrown) {
        if (thrown instanceof Error) {
            throw (Error)thrown;
        }
        throw Exceptional.uncheck(thrown);
    }

    public static void run(CheckedRunnable<?> runnable) {
        try {
            runnable.run();
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static Runnable uncheckRunnable(CheckedRunnable<?> runnable) {
        return () -> Exceptional.run(runnable);
    }

    public static <T> T call(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static RuntimeException uncheck(Throwable caught) {
        return UNCHECK_MAP.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(caught)).map(e -> (RuntimeException)((Function)e.getValue()).apply(caught)).findFirst().orElseGet(() -> new UncheckedException(caught));
    }

    public static <T> Consumer<T> uncheckConsumer(CheckedConsumer<T, ?> consumer) {
        return (Consumer<Object> & Serializable)t -> Exceptional.accept(consumer, t);
    }

    public static <T> void accept(CheckedConsumer<T, ?> consumer, T value) {
        try {
            consumer.accept(value);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static IntConsumer uncheckIntConsumer(CheckedIntConsumer<?> consumer) {
        return (IntConsumer & Serializable)t -> Exceptional.accept(consumer, t);
    }

    public static void accept(CheckedIntConsumer<?> consumer, int value) {
        try {
            consumer.accept(value);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T, U> BiConsumer<T, U> uncheckBiConsumer(CheckedBiConsumer<T, U, ?> consumer) {
        return (BiConsumer<Object, Object> & Serializable)(t, u) -> Exceptional.accept(consumer, t, u);
    }

    public static <T, U> void accept(CheckedBiConsumer<T, U, ?> consumer, T t, U u) {
        try {
            consumer.accept(t, u);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T, R> Function<T, R> uncheckFunction(CheckedFunction<T, R, ?> function) {
        return (Function<Object, Object> & Serializable)t -> Exceptional.apply(function, t);
    }

    public static <T, R> R apply(CheckedFunction<T, R, ?> function, T argument) {
        try {
            return function.apply(argument);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T, U, R> BiFunction<T, U, R> uncheckBiFunction(CheckedBiFunction<T, U, R, ?> function) {
        return (BiFunction<Object, Object, Object> & Serializable)(t, u) -> Exceptional.apply(function, t, u);
    }

    public static <T, U, R> R apply(CheckedBiFunction<T, U, R, ?> function, T t, U u) {
        try {
            return function.apply(t, u);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T> BinaryOperator<T> uncheckBinaryOperator(CheckedBinaryOperator<T, ?> operator) {
        return (BinaryOperator & Serializable)(a, b) -> Exceptional.apply(operator, a, b);
    }

    public static <T> ToDoubleFunction<T> uncheckToDoubleFunction(CheckedToDoubleFunction<T, ?> function) {
        return (ToDoubleFunction<Object> & Serializable)t -> Exceptional.applyAsDouble(function, t);
    }

    public static <T> double applyAsDouble(CheckedToDoubleFunction<T, ?> function, T t) {
        try {
            return function.applyAsDouble(t);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T> ToIntFunction<T> uncheckToIntFunction(CheckedToIntFunction<T, ?> function) {
        return (ToIntFunction<Object> & Serializable)t -> Exceptional.applyAsInt(function, t);
    }

    public static <T> int applyAsInt(CheckedToIntFunction<T, ?> function, T t) {
        try {
            return function.applyAsInt(t);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T> ToLongFunction<T> uncheckToLongFunction(CheckedToLongFunction<T, ?> function) {
        return (ToLongFunction<Object> & Serializable)t -> Exceptional.applyAsLong(function, t);
    }

    public static <T> long applyAsLong(CheckedToLongFunction<T, ?> function, T t) {
        try {
            return function.applyAsLong(t);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T> Supplier<T> uncheckSupplier(CheckedSupplier<T, ?> supplier) {
        return (Supplier<Object> & Serializable)() -> Exceptional.get(supplier);
    }

    public static <T> T get(CheckedSupplier<T, ?> supplier) {
        try {
            return supplier.get();
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T> Predicate<T> uncheckPredicate(CheckedPredicate<T, ?> predicate) {
        return (Predicate<Object> & Serializable)t -> Exceptional.test(predicate, t);
    }

    public static <T> boolean test(CheckedPredicate<T, ?> predicate, T value) {
        try {
            return predicate.test(value);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static <T> Comparator<T> uncheckComparator(CheckedComparator<T, ?> comparator) {
        return (Comparator & Serializable)(a, b) -> Exceptional.applyAsInt(comparator, a, b);
    }

    public static <T, U> ToIntBiFunction<T, U> uncheckToIntBiFunction(CheckedToIntBiFunction<T, U, ?> function) {
        return (ToIntBiFunction<Object, Object> & Serializable)(a, b) -> Exceptional.applyAsInt(function, a, b);
    }

    public static <T, U> int applyAsInt(CheckedToIntBiFunction<T, U, ?> function, T t, U u) {
        try {
            return function.applyAsInt(t, u);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable thrown) {
            throw Exceptional.uncheck(thrown);
        }
    }

    public static RuntimeException throwAsUnchecked(Throwable throwable) {
        Exceptional.resetIfInterrupt(throwable);
        return Exceptional.eraseAndThrow(throwable);
    }

    private static <T extends Throwable> RuntimeException eraseAndThrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static Throwable unwrap(Throwable throwable) {
        Throwable unwrapped = Exceptional.unwrapping(throwable);
        if (unwrapped != throwable) {
            unwrapped.addSuppressed(throwable);
        }
        return unwrapped;
    }

    private static Throwable unwrapping(Throwable throwable) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (Exceptional.isUnwrappable(throwable) && !seen.contains(throwable)) {
            seen.add(throwable);
            throwable = throwable.getCause();
        }
        return throwable;
    }

    private static boolean isUnwrappable(Throwable throwable) {
        return throwable.getCause() != null && (throwable instanceof InvocationTargetException || throwable instanceof UndeclaredThrowableException || throwable instanceof UncheckedIOException || throwable instanceof UncheckedException);
    }

    public static Throwable unwrap(UndeclaredThrowableException throwable) {
        return Exceptional.unwrap((Throwable)throwable);
    }

    public static Throwable unwrap(InvocationTargetException throwable) {
        return Exceptional.unwrap((Throwable)throwable);
    }

    public static <T> void forEach(Iterable<T> iterable, CheckedConsumer<T, ?> consumer) {
        iterable.forEach(Exceptional.uncheckConsumer(consumer));
    }

    public static <K, V> void forEach(Map<K, V> map, CheckedBiConsumer<K, V, ?> consumer) {
        map.forEach(Exceptional.uncheckBiConsumer(consumer));
    }

    static {
        HashMap<Class, Function<Throwable, RuntimeException>> map = new HashMap<Class, Function<Throwable, RuntimeException>>();
        map.put(ReflectiveOperationException.class, e -> new UncheckedReflectiveException((ReflectiveOperationException)e));
        map.put(GeneralSecurityException.class, e -> new UncheckedSecurityException((GeneralSecurityException)e));
        map.put(InterruptedException.class, e -> new UncheckedInterruptException((InterruptedException)e));
        map.put(URISyntaxException.class, e -> new UncheckedUriSyntaxException((URISyntaxException)e));
        map.put(RuntimeException.class, RuntimeException.class::cast);
        map.put(IOException.class, e -> new UncheckedIOException((IOException)e));
        UNCHECK_MAP = Collections.unmodifiableMap(map);
        RETHROWING = (t, e) -> Exceptional.rethrow(e);
        SWALLOWING = (t, e) -> Exceptional.swallow(e);
    }
}

