/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.unexceptional;

import io.earcam.unexceptional.CheckedBiConsumer;
import io.earcam.unexceptional.CheckedBiFunction;
import io.earcam.unexceptional.CheckedConsumer;
import io.earcam.unexceptional.CheckedFunction;
import io.earcam.unexceptional.Exceptional;
import java.util.function.Supplier;

public final class Closing {
    private Closing() {
        throw new IllegalStateException("Why on earth would you want to instantiate this?");
    }

    public static <C extends AutoCloseable, T, R> R closeAfterApplying(CheckedFunction<T, C, ?> create, T t, CheckedFunction<C, R, ?> convert) {
        AutoCloseable closeable = (AutoCloseable)Exceptional.apply(create, t);
        return Closing.closeAfterApplying(closeable, convert);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <C extends AutoCloseable, R> R closeAfterApplying(C closeable, CheckedFunction<C, R, ?> convert) {
        try (C autoClose = closeable;){
            R r = Exceptional.apply(convert, autoClose);
            return r;
        }
        catch (Exception e) {
            throw Exceptional.uncheck(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <C extends AutoCloseable, U, R, E extends Throwable> R closeAfterApplying(C closeable, U instance, CheckedBiFunction<C, U, R, E> convert) {
        try (C autoClose = closeable;){
            R r = Exceptional.apply(convert, autoClose, instance);
            return r;
        }
        catch (Exception e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static <C extends AutoCloseable, T> void closeAfterAccepting(CheckedFunction<T, C, ?> create, T t, CheckedConsumer<C, ?> consume) {
        AutoCloseable closeable = (AutoCloseable)Exceptional.apply(create, t);
        Closing.closeAfterAccepting(closeable, consume);
    }

    public static <C extends AutoCloseable> void closeAfterAccepting(C closeable, CheckedConsumer<C, ?> consume) {
        try (C autoClose = closeable;){
            Exceptional.accept(consume, autoClose);
        }
        catch (Exception e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static <C extends AutoCloseable, T, U> void closeAfterAccepting(CheckedFunction<T, C, ?> create, T t, U instance, CheckedBiConsumer<C, U, ?> consume) {
        AutoCloseable closeable = (AutoCloseable)Exceptional.apply(create, t);
        Closing.closeAfterAccepting(closeable, instance, consume);
    }

    public static <C extends AutoCloseable, U> void closeAfterAccepting(C closeable, U instance, CheckedBiConsumer<C, U, ?> consume) {
        try (C autoClose = closeable;){
            Exceptional.accept(consume, autoClose, instance);
        }
        catch (Exception e) {
            throw Exceptional.uncheck(e);
        }
    }

    public static <T, E extends Exception> AutoClosed<T, E> autoClosing(T instance, CheckedConsumer<T, E> closeMethod) {
        return new AutoClosed<T, E>(instance, closeMethod);
    }

    public static class AutoClosed<T, E extends Exception>
    implements AutoCloseable,
    Supplier<T> {
        private final T instance;
        private final CheckedConsumer<T, E> closeMethod;

        AutoClosed(T instance, CheckedConsumer<T, E> closeMethod) {
            this.instance = instance;
            this.closeMethod = closeMethod;
        }

        @Override
        public T get() {
            return this.instance;
        }

        @Override
        public void close() throws E {
            this.closeMethod.accept(this.instance);
        }
    }
}

