/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.unexceptional;

import io.earcam.unexceptional.CheckedFunction;
import io.earcam.unexceptional.CheckedToDoubleFunction;
import io.earcam.unexceptional.CheckedToIntBiFunction;
import io.earcam.unexceptional.CheckedToIntFunction;
import io.earcam.unexceptional.CheckedToLongFunction;
import io.earcam.unexceptional.Exceptional;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;

@FunctionalInterface
public interface CheckedComparator<T, E extends Throwable>
extends CheckedToIntBiFunction<T, T, E> {
    @Override
    default public int applyAsInt(T t, T u) throws E {
        return this.compare(t, u);
    }

    public int compare(T var1, T var2) throws E;

    default public Comparator<T> reversed() {
        return Collections.reverseOrder(Exceptional.uncheckComparator(this));
    }

    default public CheckedComparator<T, E> thenComparing(CheckedComparator<? super T, ? extends E> other) {
        Objects.requireNonNull(other);
        return (CheckedComparator<Object, E> & Serializable)(c1, c2) -> {
            int res = this.compare(c1, c2);
            return res == 0 ? other.compare(c1, c2) : res;
        };
    }

    default public <U> CheckedComparator<T, E> thenComparing(CheckedFunction<? super T, ? extends U, E> keyExtractor, CheckedComparator<? super U, E> keyComparator) {
        return this.thenComparing(CheckedComparator.comparing(keyExtractor, keyComparator));
    }

    default public <U extends Comparable<? super U>> CheckedComparator<T, E> thenComparing(CheckedFunction<? super T, ? extends U, E> keyExtractor) {
        return this.thenComparing(CheckedComparator.comparing(keyExtractor));
    }

    default public CheckedComparator<T, E> thenComparingInt(CheckedToIntFunction<? super T, ? extends E> keyExtractor) {
        return this.thenComparing(CheckedComparator.comparingInt(keyExtractor));
    }

    default public CheckedComparator<T, E> thenComparingLong(CheckedToLongFunction<? super T, ? extends E> keyExtractor) {
        return this.thenComparing(CheckedComparator.comparingLong(keyExtractor));
    }

    default public CheckedComparator<T, E> thenComparingDouble(CheckedToDoubleFunction<? super T, ? extends E> keyExtractor) {
        return this.thenComparing(CheckedComparator.comparingDouble(keyExtractor));
    }

    public static <T, U, E extends Throwable> CheckedComparator<T, E> comparing(CheckedFunction<? super T, ? extends U, ? extends E> keyExtractor, CheckedComparator<? super U, ? extends E> keyComparator) {
        Objects.requireNonNull(keyExtractor);
        Objects.requireNonNull(keyComparator);
        return (CheckedComparator<Object, E> & Serializable)(c1, c2) -> keyComparator.compare((Object)Exceptional.apply(keyExtractor, c1), (Object)Exceptional.apply(keyExtractor, c2));
    }

    public static <T, U extends Comparable<? super U>, E extends Throwable> CheckedComparator<T, E> comparing(CheckedFunction<? super T, ? extends U, ? extends E> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (CheckedComparator<Object, E> & Serializable)(c1, c2) -> Exceptional.get(() -> ((Comparable)keyExtractor.apply(c1)).compareTo(keyExtractor.apply(c2)));
    }

    public static <T, E extends Throwable> CheckedComparator<T, E> comparingInt(CheckedToIntFunction<? super T, ? extends E> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (CheckedComparator<Object, E> & Serializable)(c1, c2) -> Exceptional.get(() -> Integer.compare(keyExtractor.applyAsInt(c1), keyExtractor.applyAsInt(c2)));
    }

    public static <T, E extends Throwable> CheckedComparator<T, E> comparingLong(CheckedToLongFunction<? super T, ? extends E> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (CheckedComparator<Object, E> & Serializable)(c1, c2) -> Exceptional.get(() -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2)));
    }

    public static <T, E extends Throwable> CheckedComparator<T, E> comparingDouble(CheckedToDoubleFunction<? super T, ? extends E> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (CheckedComparator<Object, E> & Serializable)(c1, c2) -> Exceptional.get(() -> Double.compare(keyExtractor.applyAsDouble(c1), keyExtractor.applyAsDouble(c2)));
    }
}

