/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.security;

import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.security.KeyPairCredential;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class KeyStores {
    private KeyStores() {
    }

    public static KeyPair keyPair(KeyStore store, String alias, char[] password) {
        PrivateKey key = (PrivateKey)PrivateKey.class.cast(Exceptional.apply(store::getKey, (Object)alias, (Object)password));
        Certificate certificate = (Certificate)Exceptional.apply(store::getCertificate, (Object)alias);
        return new KeyPair(certificate.getPublicKey(), key);
    }

    public static KeyStore keyStore(KeyPairCredential credential, Certificate ... certificates) {
        return KeyStores.keyStore(credential.name(), credential.password(), credential.pair(), certificates);
    }

    public static KeyStore keyStore(String alias, char[] aliasPassword, KeyPair pair, Certificate ... certificates) {
        return KeyStores.keyStore("JKS", alias, aliasPassword, pair, certificates);
    }

    public static KeyStore keyStore(String type, String alias, char[] aliasPassword, KeyPair pair, Certificate ... certificates) {
        KeyStore keyStore = (KeyStore)Exceptional.apply(KeyStore::getInstance, (Object)type);
        Exceptional.accept(keyStore::load, (Object)null);
        Exceptional.run(() -> keyStore.setKeyEntry(alias, pair.getPrivate(), aliasPassword, certificates));
        return keyStore;
    }

    public static byte[] encode(KeyStore keyStore, char[] password) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Exceptional.accept(keyStore::store, (Object)output, (Object)password);
        return output.toByteArray();
    }

    public static KeyStore decode(byte[] dehydrated, char[] password) {
        return KeyStores.decode("JKS", dehydrated, password);
    }

    public static KeyStore decode(String type, byte[] dehydrated, char[] password) {
        KeyStore rehydrated = (KeyStore)Exceptional.apply(KeyStore::getInstance, (Object)type);
        Exceptional.accept(rehydrated::load, (Object)new ByteArrayInputStream(dehydrated), (Object)password);
        return rehydrated;
    }
}

