/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.security;

import io.earcam.unexceptional.Closing;
import io.earcam.unexceptional.Exceptional;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

@ParametersAreNonnullByDefault
public class Certificates {
    private static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();
    static final String DN_LOCALHOST = "DN=localhost, L=London, C=GB";

    private Certificates() {
    }

    public static CertificateBuilder certificate(KeyPair pair, String subjectName) {
        return Certificates.certificate(pair).subject(subjectName);
    }

    public static CertificateBuilder certificate(KeyPair pair) {
        return Certificates.certificate().key(pair);
    }

    public static CertificateBuilder certificate() {
        return new CertificateBuilder();
    }

    public static X509Certificate localhostCertificate(KeyPair keys) {
        return Certificates.hostCertificate(keys, DN_LOCALHOST);
    }

    @Deprecated
    public static X509Certificate hostCertificate(KeyPair keys) {
        throw new UnsupportedOperationException();
    }

    public static X509Certificate hostCertificate(KeyPair keys, String hostname) {
        return Certificates.certificate(keys).subject(hostname).toX509();
    }

    public static class CertificateBuilder {
        private static final String EXTENSION_KEY_USAGE = "2.5.29.15";
        static final String EXTENSION_MAY_ACT_AS_CA = "2.5.29.19";
        private String issuerName = "acme";
        private String subjectName;
        private BigInteger serial = BigInteger.ONE;
        private boolean canSignOtherCertificates = false;
        private LocalDate validFrom = LocalDate.now(ZoneId.systemDefault());
        private long duration = 365L;
        private TimeUnit unit = TimeUnit.DAYS;
        private String signatureAlgorithm = "SHA256withRSA";
        private KeyPair keyPair;

        CertificateBuilder() {
        }

        public CertificateBuilder issuer(String name) {
            this.issuerName = name;
            return this;
        }

        public CertificateBuilder subject(String name) {
            this.subjectName = name;
            return this;
        }

        public CertificateBuilder serial(int number) {
            return this.serial(BigInteger.valueOf(number));
        }

        public CertificateBuilder serial(BigInteger number) {
            this.serial = number;
            return this;
        }

        public CertificateBuilder canSignOtherCertificates() {
            this.canSignOtherCertificates = true;
            return this;
        }

        public CertificateBuilder key(KeyPair pair) {
            this.keyPair = pair;
            return this;
        }

        public CertificateBuilder signedBy(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public CertificateBuilder validFrom(LocalDate from) {
            this.validFrom = from;
            return this;
        }

        public CertificateBuilder validFor(long duration, TimeUnit unit) {
            this.duration = duration;
            this.unit = unit;
            return this;
        }

        public X509Certificate toX509() {
            Objects.requireNonNull(this.keyPair, "keyPair");
            Objects.requireNonNull(this.issuerName, "issuerName");
            Objects.requireNonNull(this.subjectName, "subjectName");
            X500Name issuer = new X500Name(this.addCnIfMissing(this.issuerName));
            X500Name subject = new X500Name(this.addCnIfMissing(this.subjectName));
            java.util.Date from = CertificateBuilder.javaDate(this.validFrom);
            java.util.Date to = new java.util.Date(from.getTime() + this.unit.toMillis(this.duration));
            JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(issuer, this.serial, from, to, subject, this.keyPair.getPublic());
            Exceptional.accept(this::addExtensions, (Object)certificateBuilder);
            X509CertificateHolder signed = CertificateBuilder.sign(this.keyPair, this.signatureAlgorithm, (X509v3CertificateBuilder)certificateBuilder);
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider((Provider)PROVIDER);
            return (X509Certificate)Exceptional.apply(arg_0 -> ((JcaX509CertificateConverter)converter).getCertificate(arg_0), (Object)signed);
        }

        static java.util.Date javaDate(LocalDate date) {
            return Date.valueOf(date);
        }

        static LocalDate localDate(java.util.Date date) {
            return new Date(date.getTime()).toLocalDate();
        }

        private void addExtensions(X509v3CertificateBuilder certificateBuilder) throws CertIOException {
            certificateBuilder.addExtension(new ASN1ObjectIdentifier(EXTENSION_MAY_ACT_AS_CA), false, (ASN1Encodable)new BasicConstraints(this.canSignOtherCertificates)).addExtension(new ASN1ObjectIdentifier(EXTENSION_KEY_USAGE), true, (ASN1Encodable)new X509KeyUsage(240));
        }

        private String addCnIfMissing(String name) {
            return name.indexOf(61) == -1 ? "CN=" + name : name;
        }

        private static X509CertificateHolder sign(KeyPair keyPair, String signatureAlgorithm, X509v3CertificateBuilder certificateBuilder) {
            JcaContentSignerBuilder jcaContentSignerBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
            ContentSigner sigGen = (ContentSigner)Exceptional.apply(arg_0 -> ((JcaContentSignerBuilder)jcaContentSignerBuilder).build(arg_0), (Object)keyPair.getPrivate());
            return certificateBuilder.build(sigGen);
        }

        public String toPem() {
            StringWriter writer = new StringWriter();
            this.toPem(writer);
            return writer.toString();
        }

        public void toPem(Writer writer) {
            Closing.closeAfterAccepting(JcaPEMWriter::new, (Object)writer, (Object)this.toX509(), JcaPEMWriter::writeObject);
        }
    }
}

