/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.security;

import io.earcam.unexceptional.Exceptional;
import io.earcam.unexceptional.UncheckedSecurityException;
import io.earcam.utilitarian.security.OpenedKeyStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

public final class Signatures {
    private static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();

    private Signatures() {
    }

    public static byte[] sign(byte[] contents, OpenedKeyStore keyStore, String signatureAlgorithm) {
        try {
            CMSSignedDataGenerator gen = Signatures.createSignedDataGenerator(keyStore, signatureAlgorithm);
            CMSProcessableByteArray cmsData = new CMSProcessableByteArray(contents);
            CMSSignedData signedData = gen.generate((CMSTypedData)cmsData);
            return signedData.getEncoded();
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException | CMSException | OperatorException e) {
            throw new UncheckedSecurityException(new GeneralSecurityException(e));
        }
    }

    private static CMSSignedDataGenerator createSignedDataGenerator(OpenedKeyStore openedKeyStore, String signatureAlgorithm) throws GeneralSecurityException, OperatorException, CMSException {
        List<Certificate> certChain = Arrays.asList(openedKeyStore.getCertificateChain());
        JcaCertStore certStore = new JcaCertStore(certChain);
        Certificate cert = openedKeyStore.getCertificate();
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider((Provider)PROVIDER).build(openedKeyStore.privateKey());
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider((Provider)PROVIDER).build();
        SignerInfoGenerator sig = new JcaSignerInfoGeneratorBuilder(dcp).build(signer, (X509Certificate)cert);
        generator.addSignerInfoGenerator(sig);
        generator.addCertificates((Store)certStore);
        return generator;
    }

    public static List<X509Certificate> certificatesFromSignature(byte[] encapSigData) {
        try {
            CMSSignedDataParser parser = new CMSSignedDataParser(new JcaDigestCalculatorProviderBuilder().setProvider((Provider)PROVIDER).build(), encapSigData);
            Store certStore = parser.getCertificates();
            SignerInformationStore signers = parser.getSignerInfos();
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            JcaX509CertificateConverter converter = new JcaX509CertificateConverter().setProvider((Provider)PROVIDER);
            for (SignerInformation signer : signers.getSigners()) {
                Collection holders = certStore.getMatches((Selector)signer.getSID());
                for (X509CertificateHolder holder : holders) {
                    X509Certificate certificate = (X509Certificate)Exceptional.apply(arg_0 -> ((JcaX509CertificateConverter)converter).getCertificate(arg_0), (Object)holder);
                    certificates.add(certificate);
                }
            }
            return certificates;
        }
        catch (CMSException | OperatorCreationException e) {
            throw new UncheckedSecurityException(new GeneralSecurityException(e));
        }
    }
}

