/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.security;

import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.security.KeyPairCredential;
import io.earcam.utilitarian.security.KeyStores;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.security.auth.Destroyable;

public class OpenedKeyStore
implements Destroyable,
AutoCloseable {
    private KeyStore store;
    private KeyPairCredential credential;

    public OpenedKeyStore(KeyStore store, KeyPairCredential credential) {
        Objects.requireNonNull(store, "store");
        this.store = store;
        this.credential = credential;
    }

    public OpenedKeyStore(KeyStore store, String alias, char[] password) {
        this(store, new KeyPairCredential(KeyStores.keyPair(store, alias, password), alias, password));
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public void destroy() {
        this.store = null;
        this.credential.destroy();
    }

    @Override
    public boolean isDestroyed() {
        return this.store == null;
    }

    public KeyStore store() {
        return this.store;
    }

    public PublicKey publicKey() {
        return this.credential.publicKey();
    }

    public PrivateKey privateKey() {
        return this.credential.privateKey();
    }

    public Certificate[] getCertificateChain() {
        return (Certificate[])Exceptional.apply(this.store::getCertificateChain, (Object)this.credential.name());
    }

    public Certificate getCertificate() {
        return (Certificate)Exceptional.apply(this.store::getCertificate, (Object)this.credential.name());
    }
}

