/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.log.slf4j;

import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.log.slf4j.LogCapturable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

final class LoggingCapture {
    private LoggingCapture() {
    }

    public static String capture(LogCapturable runnable) {
        ByteArrayOutputStream capture = new ByteArrayOutputStream();
        LoggingCapture.capture(runnable, capture);
        return new String(capture.toByteArray(), LoggingCapture.charset());
    }

    private static void capture(LogCapturable runnable, ByteArrayOutputStream capture) {
        PrintStream original = LoggingCapture.getPrintStream();
        try {
            LoggingCapture.setPrintStream((PrintStream)Exceptional.apply(LoggingCapture::newPrintStream, (Object)capture));
            LoggingCapture.execute(runnable);
        }
        finally {
            if (original != null) {
                LoggingCapture.setPrintStream(original);
            }
        }
    }

    private static PrintStream newPrintStream(OutputStream capture) throws UnsupportedEncodingException {
        return new PrintStream(capture, true, LoggingCapture.charset().toString());
    }

    private static void execute(LogCapturable runnable) {
        Exceptional.run(runnable::run);
    }

    private static PrintStream getPrintStream() {
        return LoggingCapture.useStdOut() ? System.out : System.err;
    }

    static boolean useStdOut() {
        return "System.out".equals(System.getProperty("org.slf4j.simpleLogger.logFile", "System.err"));
    }

    private static void setPrintStream(PrintStream printStream) {
        if (LoggingCapture.useStdOut()) {
            System.setOut(printStream);
        } else {
            System.setErr(printStream);
        }
    }

    private static Charset charset() {
        return Charset.forName(System.getProperty("file.encoding", StandardCharsets.UTF_8.name()));
    }
}

