/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.log.slf4j;

import io.earcam.unexceptional.Exceptional;
import io.earcam.utilitarian.log.slf4j.Level;
import io.earcam.utilitarian.log.slf4j.Levels;
import io.earcam.utilitarian.log.slf4j.LogCapturable;
import io.earcam.utilitarian.log.slf4j.LoggerName;
import io.earcam.utilitarian.log.slf4j.LoggingBuilder;
import io.earcam.utilitarian.log.slf4j.LoggingCapture;

public final class Logging
implements LoggingBuilder,
LoggerName {
    private static final String LOGGER_PROPERTY_CXF = "org.apache.cxf.Logger";
    private static final String LOGGER_IMP_CXF = "org.apache.cxf.common.logging.Slf4jLogger";
    private static final String LOGGER_PROPERTY_JETTY = "org.eclipse.jetty.util.log.class";
    private static final String LOGGER_IMP_JETTY = "org.eclipse.jetty.util.log.Slf4jLog";
    private static final String LOGGER_PROPERTY_ECLIPSELINK = "eclipselink.logging.logger";
    private static final String LOGGER_IMP_ECLIPSELINK = "org.eclipse.persistence.logging.slf4j.SLF4JLogger";
    private static final String SLF_4_YAY = "slf4j";
    private static final String LOGGER_PROPERTY_HAZELCAST = "hazelcast.logging.type";
    private static final String LOGGER_PROPERTY_JBOSS = "org.jboss.logging.provider";

    private Logging() {
    }

    public static LoggingBuilder logging() {
        return new Logging();
    }

    @Override
    public LoggerName.LogAtLevel log(String loggerName) {
        return Levels.create().log(loggerName);
    }

    @Override
    public LoggingBuilder defaultLevel(Level defaultLevel) {
        Levels.createWithDefault(defaultLevel);
        return this;
    }

    @Override
    public LoggingBuilder configureFrameworks() {
        System.setProperty("org.slf4j.simpleLogger.cacheOutputStream", Boolean.toString(false));
        System.setProperty(LOGGER_PROPERTY_JBOSS, SLF_4_YAY);
        System.setProperty(LOGGER_PROPERTY_HAZELCAST, SLF_4_YAY);
        Logging.setPropertyIfClassPresent(LOGGER_PROPERTY_JETTY, LOGGER_IMP_JETTY);
        Logging.setPropertyIfClassPresent(LOGGER_PROPERTY_ECLIPSELINK, LOGGER_IMP_ECLIPSELINK);
        Logging.setPropertyIfClassPresent(LOGGER_PROPERTY_CXF, LOGGER_IMP_CXF);
        return this;
    }

    private static void setPropertyIfClassPresent(String property, String implementation) {
        try {
            Logging.class.getClassLoader().loadClass(implementation);
            System.setProperty(property, implementation);
        }
        catch (ClassNotFoundException e) {
            Exceptional.swallow((Throwable)e);
        }
    }

    public static String capture(LogCapturable runnable) {
        return LoggingCapture.capture(runnable);
    }
}

