/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.log.slf4j;

import io.earcam.utilitarian.log.slf4j.Level;
import io.earcam.utilitarian.log.slf4j.LoggerName;

final class Levels
implements LoggerName.LogAtLevel,
LoggerName {
    private String lastLoggerName;

    private Levels() {
    }

    static final LoggerName createWithDefault(Level level) {
        if (Levels.isNullOrEmpty(System.getProperty("org.slf4j.simpleLogger.defaultLogLevel"))) {
            Levels.set("org.slf4j.simpleLogger.defaultLogLevel", level);
        }
        return Levels.create();
    }

    static final LoggerName create() {
        return new Levels();
    }

    private static boolean isNullOrEmpty(String property) {
        return property == null || property.isEmpty();
    }

    private static void set(String loggerCategory, Level level) {
        System.setProperty(loggerCategory, level.toString());
    }

    @Override
    public LoggerName.LogAtLevel log(String loggerName) {
        this.lastLoggerName = loggerName;
        return this;
    }

    @Override
    public LoggerName at(Level level) {
        Levels.set("org.slf4j.simpleLogger.log." + this.lastLoggerName, level);
        return this;
    }
}

