/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class MarkSupportedInputStream
extends InputStream {
    private volatile int[] buffer = new int[0];
    private volatile int readPosition = 0;
    private volatile int writePosition = 0;
    private volatile int readLimit = 0;
    private final InputStream delegate;

    public MarkSupportedInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public static InputStream ensureMarkSupported(InputStream input) {
        return input.markSupported() ? input : new MarkSupportedInputStream(input);
    }

    @Override
    public int read() throws IOException {
        int read;
        if (this.writePosition == this.readLimit) {
            this.readLimit = 0;
            this.writePosition = 0;
            this.readPosition = 0;
            return this.delegate.read();
        }
        if (this.readPosition < this.writePosition) {
            return this.buffer[this.readPosition++];
        }
        this.buffer[this.writePosition] = read = this.delegate.read();
        ++this.writePosition;
        ++this.readPosition;
        return read;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.readLimit = readLimit + 1;
        if (this.buffer.length < this.readLimit || this.readPosition > 0) {
            this.buffer = Arrays.copyOfRange(this.buffer, this.readPosition, this.readPosition + this.readLimit);
            this.writePosition -= this.readPosition;
        }
        this.readPosition = 0;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.readLimit == 0) {
            throw new IOException("Not marked, or current position > marked position + readLimit");
        }
        this.readPosition = 0;
    }
}

