/*
 * Decompiled with CFR 0.152.
 */
package io.earcam.utilitarian.io.file;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.EnumSet;

public final class RecursiveFiles {
    private RecursiveFiles() {
    }

    public static void delete(Path path, LinkOption ... options) throws IOException {
        RecursiveFiles.recurse(path, new DeleteVisitor(path, options));
    }

    public static void move(Path source, Path sink, CopyOption ... options) throws IOException {
        RecursiveFiles.recurse(source, new MoveVisitor(source, sink, options));
    }

    private static void recurse(Path source, AbstractVisitor visitor) throws IOException {
        boolean noFollow = Arrays.asList(visitor.options).contains(LinkOption.NOFOLLOW_LINKS);
        EnumSet<FileVisitOption> options = noFollow ? EnumSet.noneOf(FileVisitOption.class) : EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(source, options, Integer.MAX_VALUE, visitor);
    }

    public static void copy(Path source, Path sink, CopyOption ... options) throws IOException {
        RecursiveFiles.recurse(source, new CopyVisitor(source, sink, options));
    }

    private static final class CopyVisitor
    extends AbstractVisitor {
        public CopyVisitor(Path source, Path sink, CopyOption ... options) {
            super(source, sink, options);
        }

        @Override
        protected FileVisitResult postVisitDirectory(Path directory) {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.copy(file, this.sinkSub.resolve(file.getFileName()), this.options);
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class MoveVisitor
    extends AbstractVisitor {
        public MoveVisitor(Path source, Path sink, CopyOption ... options) {
            super(source, sink, options);
        }

        @Override
        protected FileVisitResult postVisitDirectory(Path directory) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.move(file, this.sinkSub.resolve(file.getFileName()), this.options);
            return FileVisitResult.CONTINUE;
        }
    }

    private static final class DeleteVisitor
    extends AbstractVisitor {
        public DeleteVisitor(Path source, CopyOption ... options) {
            super(source, source, options);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory) throws IOException {
            Files.delete(directory);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }
    }

    private static abstract class AbstractVisitor
    extends SimpleFileVisitor<Path> {
        final Path sink;
        final Path source;
        final CopyOption[] options;
        Path sinkSub;

        public AbstractVisitor(Path source, Path sink, CopyOption ... options) {
            this.source = source;
            this.sink = sink;
            this.options = options;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            this.sinkSub = this.sink.resolve(this.source.relativize(dir));
            this.sinkSub.toFile().mkdirs();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException thrown) throws IOException {
            super.postVisitDirectory(directory, thrown);
            return this.postVisitDirectory(directory);
        }

        protected abstract FileVisitResult postVisitDirectory(Path var1) throws IOException;

        @Override
        public abstract FileVisitResult visitFile(Path var1, BasicFileAttributes var2) throws IOException;
    }
}

