/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.healtcheck;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.core.setup.Environment;
import io.dyuti.dropwizard.alert.AlertPublisher;
import io.dyuti.dropwizard.config.HealthCheckMode;
import io.dyuti.dropwizard.config.MetricHealthCheckConfig;
import io.dyuti.dropwizard.config.MetricType;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class MetricHealthCheck
extends HealthCheck {
    private final Environment environment;
    private final MetricHealthCheckConfig config;
    private final AlertPublisher alertPublisher;

    protected HealthCheck.Result check() {
        return switch (this.config.getType()) {
            default -> throw new MatchException(null, null);
            case MetricType.METER -> this.checkMeter();
            case MetricType.TIMER -> this.checkTimer();
            case MetricType.HISTOGRAM -> this.checkHistogram();
            case MetricType.COUNTER -> this.checkCounter();
            case MetricType.GAUGE -> this.checkGauge();
        };
    }

    private HealthCheck.Result checkMeter() {
        if (this.environment.metrics().getMeters().containsKey(this.config.getMetric())) {
            double value;
            Meter meter = (Meter)this.environment.metrics().getMeters().get(this.config.getMetric());
            switch (this.config.getDimension()) {
                case "m5_rate": {
                    double d = meter.getFiveMinuteRate();
                    break;
                }
                case "m15_rate": {
                    double d = meter.getFifteenMinuteRate();
                    break;
                }
                case "mean_rate": {
                    double d = meter.getMeanRate();
                    break;
                }
                case "count": {
                    double d = meter.getCount();
                    break;
                }
                default: {
                    double d = value = meter.getOneMinuteRate();
                }
            }
            if (value > (double)this.config.getThreshold()) {
                HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Meter " + this.config.getMetric() + "[" + this.config.getDimension() + "]  exceeded threshold: " + value));
                this.alertPublisher.publish(this.config.getName(), result);
                if (this.config.getMode() == HealthCheckMode.ALERT) {
                    return HealthCheck.Result.healthy();
                }
                return result;
            }
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkTimer() {
        if (this.environment.metrics().getTimers().containsKey(this.config.getMetric())) {
            double value;
            Timer timer = (Timer)this.environment.metrics().getTimers().get(this.config.getMetric());
            switch (this.config.getDimension()) {
                case "max": {
                    double d = timer.getSnapshot().getMax();
                    break;
                }
                case "min": {
                    double d = timer.getSnapshot().getMin();
                    break;
                }
                case "mean": {
                    double d = timer.getSnapshot().getMean();
                    break;
                }
                case "stddev": {
                    double d = timer.getSnapshot().getStdDev();
                    break;
                }
                case "p75": {
                    double d = timer.getSnapshot().get75thPercentile();
                    break;
                }
                case "p95": {
                    double d = timer.getSnapshot().get95thPercentile();
                    break;
                }
                case "p98": {
                    double d = timer.getSnapshot().get98thPercentile();
                    break;
                }
                case "p99": {
                    double d = timer.getSnapshot().get99thPercentile();
                    break;
                }
                case "p999": {
                    double d = timer.getSnapshot().get999thPercentile();
                    break;
                }
                case "median": {
                    double d = timer.getSnapshot().getMedian();
                    break;
                }
                default: {
                    double d = value = -1.0;
                }
            }
            if (value > 0.0 && value > (double)this.config.getThreshold()) {
                HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Timer " + this.config.getMetric() + "[" + this.config.getDimension() + "]  exceeded threshold: " + value));
                this.alertPublisher.publish(this.config.getName(), result);
                if (this.config.getMode() == HealthCheckMode.ALERT) {
                    return HealthCheck.Result.healthy();
                }
                return result;
            }
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkHistogram() {
        if (this.environment.metrics().getHistograms().containsKey(this.config.getMetric())) {
            double value;
            Histogram histogram = (Histogram)this.environment.metrics().getHistograms().get(this.config.getMetric());
            switch (this.config.getDimension()) {
                case "max": {
                    double d = histogram.getSnapshot().getMax();
                    break;
                }
                case "min": {
                    double d = histogram.getSnapshot().getMin();
                    break;
                }
                case "mean": {
                    double d = histogram.getSnapshot().getMean();
                    break;
                }
                case "stddev": {
                    double d = histogram.getSnapshot().getStdDev();
                    break;
                }
                case "p75": {
                    double d = histogram.getSnapshot().get75thPercentile();
                    break;
                }
                case "p95": {
                    double d = histogram.getSnapshot().get95thPercentile();
                    break;
                }
                case "p98": {
                    double d = histogram.getSnapshot().get98thPercentile();
                    break;
                }
                case "p99": {
                    double d = histogram.getSnapshot().get99thPercentile();
                    break;
                }
                case "p999": {
                    double d = histogram.getSnapshot().get999thPercentile();
                    break;
                }
                case "median": {
                    double d = histogram.getSnapshot().getMedian();
                    break;
                }
                default: {
                    double d = value = -1.0;
                }
            }
            if (value > 0.0 && value > (double)this.config.getThreshold()) {
                HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Histogram " + this.config.getMetric() + "[" + this.config.getDimension() + "]  exceeded threshold: " + value));
                this.alertPublisher.publish(this.config.getName(), result);
                if (this.config.getMode() == HealthCheckMode.ALERT) {
                    return HealthCheck.Result.healthy();
                }
                return result;
            }
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkCounter() {
        Counter counter;
        if (this.environment.metrics().getCounters().containsKey(this.config.getMetric()) && (counter = (Counter)this.environment.metrics().getCounters().get(this.config.getMetric())).getCount() > this.config.getThreshold()) {
            HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Counter " + this.config.getMetric() + "[" + this.config.getDimension() + "]  exceeded threshold: " + counter.getCount()));
            this.alertPublisher.publish(this.config.getName(), result);
            if (this.config.getMode() == HealthCheckMode.ALERT) {
                return HealthCheck.Result.healthy();
            }
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkGauge() {
        Number number;
        long value;
        Gauge gauge;
        Object object;
        if (this.environment.metrics().getGauges().containsKey(this.config.getMetric()) && (object = (gauge = (Gauge)this.environment.metrics().getGauges().get(this.config.getMetric())).getValue()) instanceof Number && (value = (number = (Number)object).longValue()) > this.config.getThreshold()) {
            HealthCheck.Result result = HealthCheck.Result.unhealthy((String)("Gauge " + this.config.getMetric() + "[" + this.config.getDimension() + "]  exceeded threshold: " + value));
            this.alertPublisher.publish(this.config.getName(), result);
            if (this.config.getMode() == HealthCheckMode.ALERT) {
                return HealthCheck.Result.healthy();
            }
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    @ConstructorProperties(value={"environment", "config", "alertPublisher"})
    @Generated
    public MetricHealthCheck(Environment environment, MetricHealthCheckConfig config, AlertPublisher alertPublisher) {
        this.environment = environment;
        this.config = config;
        this.alertPublisher = alertPublisher;
    }
}

