/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.healtcheck;

import com.codahale.metrics.health.HealthCheck;
import io.dyuti.dropwizard.alert.AlertPublisher;
import io.dyuti.dropwizard.config.HealthCheckMode;
import io.dyuti.dropwizard.config.HttpHealthCheckConfig;
import java.beans.ConstructorProperties;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsConnectivityHealthCheck
extends HealthCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpsConnectivityHealthCheck.class);
    private final HttpHealthCheckConfig config;
    private final AlertPublisher alertPublisher;
    private final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(this){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
            log.info("Client trusted: {}", (Object)authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            log.info("Server trusted: {}", (Object)authType);
        }
    }};
    private URL url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() {
        HttpURLConnection connection = null;
        try {
            Certificate[] certs;
            if (Objects.isNull(this.url)) {
                this.url = new URI(this.config.getUrl()).toURL();
            }
            connection = (HttpsURLConnection)this.url.openConnection();
            connection.setConnectTimeout(this.config.getConnectTimeout());
            connection.setReadTimeout(this.config.getReadTimeout());
            if (Objects.nonNull(this.config.getTlsVersion())) {
                SSLContext sslContext = SSLContext.getInstance(this.config.getTlsVersion());
                sslContext.init(null, this.trustAllCerts, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            connection.setRequestMethod("GET");
            connection.connect();
            if (this.config.isVerify()) {
                for (Certificate cert : certs = ((HttpsURLConnection)connection).getServerCertificates()) {
                    ((X509Certificate)cert).checkValidity();
                }
                HealthCheck.Result.healthy();
            }
            certs = HealthCheck.Result.healthy();
            return certs;
        }
        catch (Exception e) {
            log.error("Error executing HTTPS connectivity healthcheck for {}", (Object)this.config.getUrl(), (Object)e);
            this.alertPublisher.publish(this.config.getName(), HealthCheck.Result.unhealthy((Throwable)e));
            if (this.config.getMode() == HealthCheckMode.ALERT) {
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
            HealthCheck.Result result = HealthCheck.Result.unhealthy((Throwable)e);
            return result;
        }
        finally {
            if (Objects.nonNull(connection)) {
                connection.disconnect();
            }
        }
    }

    @ConstructorProperties(value={"config", "alertPublisher"})
    @Generated
    public HttpsConnectivityHealthCheck(HttpHealthCheckConfig config, AlertPublisher alertPublisher) {
        this.config = config;
        this.alertPublisher = alertPublisher;
    }
}

