/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.healtcheck;

import com.codahale.metrics.health.HealthCheck;
import io.dyuti.dropwizard.alert.AlertPublisher;
import io.dyuti.dropwizard.config.HealthCheckMode;
import io.dyuti.dropwizard.config.HttpHealthCheckConfig;
import java.beans.ConstructorProperties;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectivityHealthCheck
extends HealthCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConnectivityHealthCheck.class);
    private final HttpHealthCheckConfig config;
    private final AlertPublisher alertPublisher;
    private URL url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() {
        HttpURLConnection connection = null;
        try {
            if (Objects.isNull(this.url)) {
                this.url = new URI(this.config.getUrl()).toURL();
            }
            connection = (HttpURLConnection)this.url.openConnection();
            connection.setConnectTimeout(this.config.getConnectTimeout());
            connection.setReadTimeout(this.config.getReadTimeout());
            connection.setRequestMethod("GET");
            connection.connect();
            HealthCheck.Result result = HealthCheck.Result.healthy();
            return result;
        }
        catch (Exception e) {
            log.error("Error executing HTTP connectivity healthcheck for {}", (Object)this.config.getUrl(), (Object)e);
            this.alertPublisher.publish(this.config.getName(), HealthCheck.Result.unhealthy((Throwable)e));
            if (this.config.getMode() == HealthCheckMode.ALERT) {
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
            HealthCheck.Result result = HealthCheck.Result.unhealthy((Throwable)e);
            return result;
        }
        finally {
            if (Objects.nonNull(connection)) {
                connection.disconnect();
            }
        }
    }

    @ConstructorProperties(value={"config", "alertPublisher"})
    @Generated
    public HttpConnectivityHealthCheck(HttpHealthCheckConfig config, AlertPublisher alertPublisher) {
        this.config = config;
        this.alertPublisher = alertPublisher;
    }
}

