/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.healtcheck;

import com.codahale.metrics.health.HealthCheck;
import io.dyuti.dropwizard.alert.AlertPublisher;
import io.dyuti.dropwizard.config.DiskSpaceHealthCheckConfig;
import io.dyuti.dropwizard.config.HealthCheckMode;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskSpaceHealthCheck
extends HealthCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiskSpaceHealthCheck.class);
    private final DiskSpaceHealthCheckConfig config;
    private final AlertPublisher alertPublisher;

    protected HealthCheck.Result check() {
        try {
            File diskPartition = new File(this.config.getPath());
            long freeSpace = diskPartition.getFreeSpace() / 1024L;
            if (freeSpace < this.config.getThreshold()) {
                this.alert(freeSpace);
                if (this.config.getMode() == HealthCheckMode.ALERT) {
                    return HealthCheck.Result.healthy();
                }
                return HealthCheck.Result.unhealthy((String)("Disk Space is below threshold. Free Space: " + freeSpace));
            }
        }
        catch (Exception e) {
            log.error("Error executing disk space availability healthcheck for {}", (Object)this.config.getPath(), (Object)e);
            this.alert(0L);
            if (this.config.getMode() == HealthCheckMode.ALERT) {
                return HealthCheck.Result.healthy();
            }
            return HealthCheck.Result.unhealthy((Throwable)e);
        }
        return HealthCheck.Result.healthy();
    }

    private void alert(long freeSpace) {
        this.alertPublisher.publish(this.config.getName(), HealthCheck.Result.unhealthy((String)("Disk Space is below threshold. Free Space: " + freeSpace)));
    }

    @ConstructorProperties(value={"config", "alertPublisher"})
    @Generated
    public DiskSpaceHealthCheck(DiskSpaceHealthCheckConfig config, AlertPublisher alertPublisher) {
        this.config = config;
        this.alertPublisher = alertPublisher;
    }
}

