/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.healtcheck;

import com.codahale.metrics.health.HealthCheck;
import io.dyuti.dropwizard.alert.AlertPublisher;
import io.dyuti.dropwizard.config.ClusterReachabilityHealthCheckConfig;
import io.dyuti.dropwizard.config.HealthCheckMode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterReachabilityHealthCheck
extends HealthCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterReachabilityHealthCheck.class);
    private final ClusterReachabilityHealthCheckConfig config;
    private final AlertPublisher alertPublisher;
    private final Supplier<List<InetSocketAddress>> hostSource;
    private long lastUpdatedTime;
    private HealthCheck.Result lastUpdatedResult;
    private final Pattern hostPattern = Pattern.compile("(\\[a-zA-z\\-\\]+)\\[(\\d+)-(\\d+)\\]\\.(\\[a-zA-z\\-\\]+)\\.(\\[a-zA-z\\-\\]+)");

    public ClusterReachabilityHealthCheck(ClusterReachabilityHealthCheckConfig config, AlertPublisher alertPublisher) {
        this(config, alertPublisher, null);
    }

    protected HealthCheck.Result check() {
        if (this.lastUpdatedTime == 0L) {
            this.lastUpdatedTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.lastUpdatedTime > (long)this.config.getCheckInterval() || Objects.isNull(this.lastUpdatedResult)) {
            this.lastUpdatedTime = System.currentTimeMillis();
            this.lastUpdatedResult = this.checkClusterReachability();
        }
        return this.lastUpdatedResult;
    }

    private HealthCheck.Result checkClusterReachability() {
        String[] portRange = this.config.getPortRange().split("-");
        int startPort = Integer.parseInt(portRange[0]);
        int endPort = Integer.parseInt(portRange[1]);
        if (this.config.getHostListSource() == ClusterReachabilityHealthCheckConfig.HostListSource.DYNAMIC) {
            if (this.config.getHostNameMode() == ClusterReachabilityHealthCheckConfig.HostNameMode.LIST && this.config.getSelectionMode() == ClusterReachabilityHealthCheckConfig.SelectionMode.RANDOM) {
                return this.checkHostListRandom(this.hostSource.get());
            }
            if (this.config.getHostNameMode() == ClusterReachabilityHealthCheckConfig.HostNameMode.LIST && this.config.getSelectionMode() == ClusterReachabilityHealthCheckConfig.SelectionMode.SEQUENTIAL) {
                return this.checkHostListSequential(this.hostSource.get());
            }
        } else {
            if (this.config.getHostNameMode() == ClusterReachabilityHealthCheckConfig.HostNameMode.LIST && this.config.getSelectionMode() == ClusterReachabilityHealthCheckConfig.SelectionMode.RANDOM) {
                return this.checkHostListRandom(startPort, endPort);
            }
            if (this.config.getHostNameMode() == ClusterReachabilityHealthCheckConfig.HostNameMode.LIST && this.config.getSelectionMode() == ClusterReachabilityHealthCheckConfig.SelectionMode.SEQUENTIAL) {
                return this.checkHostListSequential(startPort, endPort);
            }
            if (this.config.getHostNameMode() == ClusterReachabilityHealthCheckConfig.HostNameMode.PATTERN) {
                Matcher hostMatcher = this.hostPattern.matcher(this.config.getHostNamePattern());
                int startHost = Integer.parseInt(hostMatcher.group(2));
                int endHost = Integer.parseInt(hostMatcher.group(3));
                if (this.config.getSelectionMode() == ClusterReachabilityHealthCheckConfig.SelectionMode.RANDOM) {
                    return this.checkHostPatternRandom(hostMatcher, startHost, endHost, startPort, endPort);
                }
                if (this.config.getSelectionMode() == ClusterReachabilityHealthCheckConfig.SelectionMode.SEQUENTIAL) {
                    return this.checkHostPatternSequential(hostMatcher, startHost, endHost, startPort, endPort);
                }
            }
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkHostListSequential(int startPort, int endPort) {
        for (String host : this.config.getHosts()) {
            int selectedPort;
            HealthCheck.Result result = this.executeHealthCheck(host, selectedPort = ThreadLocalRandom.current().nextInt(startPort, endPort));
            if (result.isHealthy()) continue;
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkHostListSequential(List<InetSocketAddress> hosts) {
        for (InetSocketAddress host : hosts) {
            HealthCheck.Result result = this.executeHealthCheck(host.getAddress().getHostAddress(), host.getPort());
            if (result.isHealthy()) continue;
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkHostListRandom(int startPort, int endPort) {
        int selectedPort;
        String host = this.config.getHosts().get(ThreadLocalRandom.current().nextInt(this.config.getHosts().size()));
        HealthCheck.Result result = this.executeHealthCheck(host, selectedPort = ThreadLocalRandom.current().nextInt(startPort, endPort));
        if (!result.isHealthy()) {
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkHostListRandom(List<InetSocketAddress> sourceHostList) {
        InetSocketAddress host = sourceHostList.get(ThreadLocalRandom.current().nextInt(sourceHostList.size()));
        HealthCheck.Result result = this.executeHealthCheck(host.getAddress().getHostAddress(), host.getPort());
        if (!result.isHealthy()) {
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    private HealthCheck.Result checkHostPatternRandom(Matcher hostMatcher, int startHost, int endHost, int startPort, int endPort) {
        int selectedPort = ThreadLocalRandom.current().nextInt(startPort, endPort);
        String selectedHost = StringUtils.leftPad((String)String.valueOf(ThreadLocalRandom.current().nextInt(startHost, endHost)), (int)(hostMatcher.group(2).length() - String.valueOf(startHost).length()), (char)'0');
        String host = hostMatcher.group(1) + selectedHost + "." + hostMatcher.group(4) + "." + hostMatcher.group(5);
        return this.executeHealthCheck(host, selectedPort);
    }

    private HealthCheck.Result checkHostPatternSequential(Matcher hostMatcher, int startHost, int endHost, int startPort, int endPort) {
        for (int i = startHost; i <= endHost; ++i) {
            int selectedPort = ThreadLocalRandom.current().nextInt(startPort, endPort);
            String selectedHost = StringUtils.leftPad((String)String.valueOf(i), (int)(hostMatcher.group(2).length() - String.valueOf(startHost).length()), (char)'0');
            String host = hostMatcher.group(1) + selectedHost + "." + hostMatcher.group(4) + "." + hostMatcher.group(5);
            HealthCheck.Result result = this.executeHealthCheck(host, selectedPort);
            if (result.isHealthy()) continue;
            return result;
        }
        return HealthCheck.Result.healthy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HealthCheck.Result executeHealthCheck(String host, int selectedPort) {
        log.info("Cluster healthcheck {}:{}", (Object)host, (Object)selectedPort);
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, selectedPort), this.config.getConnectTimeout());
            if (socket.isConnected()) {
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
            this.alert(host, selectedPort);
            if (this.config.getMode() == HealthCheckMode.ALERT) {
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
            HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"Cluster host %s is not reachable on port range: %s".formatted(host, selectedPort));
            return result;
        }
        catch (IOException e) {
            log.error("Error executing cluster reachability healthcheck for {}:{}", new Object[]{host, selectedPort, e});
            this.alert(host, selectedPort);
            if (this.config.getMode() != HealthCheckMode.ALERT) return HealthCheck.Result.unhealthy((Throwable)e);
            return HealthCheck.Result.healthy();
        }
    }

    private void alert(String host, int port) {
        this.alertPublisher.publish(this.config.getName(), HealthCheck.Result.unhealthy((String)"Cluster host %s is not reachable on port range: %s".formatted(host, port)));
    }

    @ConstructorProperties(value={"config", "alertPublisher", "hostSource"})
    @Generated
    public ClusterReachabilityHealthCheck(ClusterReachabilityHealthCheckConfig config, AlertPublisher alertPublisher, Supplier<List<InetSocketAddress>> hostSource) {
        this.config = config;
        this.alertPublisher = alertPublisher;
        this.hostSource = hostSource;
    }
}

