/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.config;

import io.dyuti.dropwizard.config.HealthCheckMode;
import io.dyuti.dropwizard.config.MetricType;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class MetricHealthCheckConfig {
    @NotBlank
    private String name;
    @NotBlank
    private String metric;
    @NotNull
    private MetricType type;
    @NotBlank
    private String dimension = "m1_rate";
    @Min(value=0L)
    private @Min(value=0L) long threshold;
    private HealthCheckMode mode = HealthCheckMode.NORMAL;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMetric() {
        return this.metric;
    }

    @Generated
    public MetricType getType() {
        return this.type;
    }

    @Generated
    public String getDimension() {
        return this.dimension;
    }

    @Generated
    public long getThreshold() {
        return this.threshold;
    }

    @Generated
    public HealthCheckMode getMode() {
        return this.mode;
    }

    @Generated
    public MetricHealthCheckConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public MetricHealthCheckConfig setMetric(String metric) {
        this.metric = metric;
        return this;
    }

    @Generated
    public MetricHealthCheckConfig setType(MetricType type) {
        this.type = type;
        return this;
    }

    @Generated
    public MetricHealthCheckConfig setDimension(String dimension) {
        this.dimension = dimension;
        return this;
    }

    @Generated
    public MetricHealthCheckConfig setThreshold(long threshold) {
        this.threshold = threshold;
        return this;
    }

    @Generated
    public MetricHealthCheckConfig setMode(HealthCheckMode mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricHealthCheckConfig)) {
            return false;
        }
        MetricHealthCheckConfig other = (MetricHealthCheckConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreshold() != other.getThreshold()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$metric = this.getMetric();
        String other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !this$metric.equals(other$metric)) {
            return false;
        }
        MetricType this$type = this.getType();
        MetricType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$dimension = this.getDimension();
        String other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        HealthCheckMode this$mode = this.getMode();
        HealthCheckMode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricHealthCheckConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threshold = this.getThreshold();
        result = result * 59 + (int)($threshold >>> 32 ^ $threshold);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : $metric.hashCode());
        MetricType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        HealthCheckMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricHealthCheckConfig(name=" + this.getName() + ", metric=" + this.getMetric() + ", type=" + String.valueOf((Object)this.getType()) + ", dimension=" + this.getDimension() + ", threshold=" + this.getThreshold() + ", mode=" + String.valueOf((Object)this.getMode()) + ")";
    }

    @ConstructorProperties(value={"name", "metric", "type", "dimension", "threshold", "mode"})
    @Generated
    public MetricHealthCheckConfig(String name, String metric, MetricType type, String dimension, long threshold, HealthCheckMode mode) {
        this.name = name;
        this.metric = metric;
        this.type = type;
        this.dimension = dimension;
        this.threshold = threshold;
        this.mode = mode;
    }

    @Generated
    public MetricHealthCheckConfig() {
    }
}

