/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.config;

import io.dyuti.dropwizard.config.HealthCheckMode;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class HttpHealthCheckConfig {
    @NotBlank
    private String name;
    @NotBlank
    private String url;
    @Min(value=1000L)
    private @Min(value=1000L) int connectTimeout = 10000;
    @Min(value=1000L)
    private @Min(value=1000L) int readTimeout = 10000;
    private boolean verify;
    private String tlsVersion = "TLSv1.2";
    private HealthCheckMode mode = HealthCheckMode.NORMAL;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean isVerify() {
        return this.verify;
    }

    @Generated
    public String getTlsVersion() {
        return this.tlsVersion;
    }

    @Generated
    public HealthCheckMode getMode() {
        return this.mode;
    }

    @Generated
    public HttpHealthCheckConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public HttpHealthCheckConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    @Generated
    public HttpHealthCheckConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Generated
    public HttpHealthCheckConfig setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Generated
    public HttpHealthCheckConfig setVerify(boolean verify) {
        this.verify = verify;
        return this;
    }

    @Generated
    public HttpHealthCheckConfig setTlsVersion(String tlsVersion) {
        this.tlsVersion = tlsVersion;
        return this;
    }

    @Generated
    public HttpHealthCheckConfig setMode(HealthCheckMode mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpHealthCheckConfig)) {
            return false;
        }
        HttpHealthCheckConfig other = (HttpHealthCheckConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.isVerify() != other.isVerify()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$tlsVersion = this.getTlsVersion();
        String other$tlsVersion = other.getTlsVersion();
        if (this$tlsVersion == null ? other$tlsVersion != null : !this$tlsVersion.equals(other$tlsVersion)) {
            return false;
        }
        HealthCheckMode this$mode = this.getMode();
        HealthCheckMode other$mode = other.getMode();
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpHealthCheckConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + (this.isVerify() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $tlsVersion = this.getTlsVersion();
        result = result * 59 + ($tlsVersion == null ? 43 : $tlsVersion.hashCode());
        HealthCheckMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpHealthCheckConfig(name=" + this.getName() + ", url=" + this.getUrl() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", verify=" + this.isVerify() + ", tlsVersion=" + this.getTlsVersion() + ", mode=" + String.valueOf((Object)this.getMode()) + ")";
    }

    @ConstructorProperties(value={"name", "url", "connectTimeout", "readTimeout", "verify", "tlsVersion", "mode"})
    @Generated
    public HttpHealthCheckConfig(String name, String url, int connectTimeout, int readTimeout, boolean verify, String tlsVersion, HealthCheckMode mode) {
        this.name = name;
        this.url = url;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.verify = verify;
        this.tlsVersion = tlsVersion;
        this.mode = mode;
    }

    @Generated
    public HttpHealthCheckConfig() {
    }
}

