/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.config;

import io.dyuti.dropwizard.config.HealthCheckMode;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class ClusterReachabilityHealthCheckConfig {
    @NotBlank
    private String name;
    private String hostNamePattern;
    private List<String> hosts = Collections.emptyList();
    @NotBlank
    private String portRange;
    @Min(value=1000L)
    private @Min(value=1000L) int connectTimeout = 1000;
    @Min(value=60000L)
    private @Min(value=60000L) int checkInterval = 43200000;
    @NotNull
    private HostNameMode hostNameMode = HostNameMode.PATTERN;
    @NotNull
    private HealthCheckMode mode = HealthCheckMode.NORMAL;
    @NotNull
    private SelectionMode selectionMode = SelectionMode.RANDOM;
    @NotNull
    private HostListSource hostListSource = HostListSource.CONFIG;

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHostNamePattern() {
        return this.hostNamePattern;
    }

    @Generated
    public List<String> getHosts() {
        return this.hosts;
    }

    @Generated
    public String getPortRange() {
        return this.portRange;
    }

    @Generated
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public int getCheckInterval() {
        return this.checkInterval;
    }

    @Generated
    public HostNameMode getHostNameMode() {
        return this.hostNameMode;
    }

    @Generated
    public HealthCheckMode getMode() {
        return this.mode;
    }

    @Generated
    public SelectionMode getSelectionMode() {
        return this.selectionMode;
    }

    @Generated
    public HostListSource getHostListSource() {
        return this.hostListSource;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setHostNamePattern(String hostNamePattern) {
        this.hostNamePattern = hostNamePattern;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setHosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setPortRange(String portRange) {
        this.portRange = portRange;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setHostNameMode(HostNameMode hostNameMode) {
        this.hostNameMode = hostNameMode;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setMode(HealthCheckMode mode) {
        this.mode = mode;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setSelectionMode(SelectionMode selectionMode) {
        this.selectionMode = selectionMode;
        return this;
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig setHostListSource(HostListSource hostListSource) {
        this.hostListSource = hostListSource;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterReachabilityHealthCheckConfig)) {
            return false;
        }
        ClusterReachabilityHealthCheckConfig other = (ClusterReachabilityHealthCheckConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getCheckInterval() != other.getCheckInterval()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$hostNamePattern = this.getHostNamePattern();
        String other$hostNamePattern = other.getHostNamePattern();
        if (this$hostNamePattern == null ? other$hostNamePattern != null : !this$hostNamePattern.equals(other$hostNamePattern)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        String this$portRange = this.getPortRange();
        String other$portRange = other.getPortRange();
        if (this$portRange == null ? other$portRange != null : !this$portRange.equals(other$portRange)) {
            return false;
        }
        HostNameMode this$hostNameMode = this.getHostNameMode();
        HostNameMode other$hostNameMode = other.getHostNameMode();
        if (this$hostNameMode == null ? other$hostNameMode != null : !((Object)((Object)this$hostNameMode)).equals((Object)other$hostNameMode)) {
            return false;
        }
        HealthCheckMode this$mode = this.getMode();
        HealthCheckMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        SelectionMode this$selectionMode = this.getSelectionMode();
        SelectionMode other$selectionMode = other.getSelectionMode();
        if (this$selectionMode == null ? other$selectionMode != null : !((Object)((Object)this$selectionMode)).equals((Object)other$selectionMode)) {
            return false;
        }
        HostListSource this$hostListSource = this.getHostListSource();
        HostListSource other$hostListSource = other.getHostListSource();
        return !(this$hostListSource == null ? other$hostListSource != null : !((Object)((Object)this$hostListSource)).equals((Object)other$hostListSource));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClusterReachabilityHealthCheckConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getCheckInterval();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $hostNamePattern = this.getHostNamePattern();
        result = result * 59 + ($hostNamePattern == null ? 43 : $hostNamePattern.hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        String $portRange = this.getPortRange();
        result = result * 59 + ($portRange == null ? 43 : $portRange.hashCode());
        HostNameMode $hostNameMode = this.getHostNameMode();
        result = result * 59 + ($hostNameMode == null ? 43 : ((Object)((Object)$hostNameMode)).hashCode());
        HealthCheckMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        SelectionMode $selectionMode = this.getSelectionMode();
        result = result * 59 + ($selectionMode == null ? 43 : ((Object)((Object)$selectionMode)).hashCode());
        HostListSource $hostListSource = this.getHostListSource();
        result = result * 59 + ($hostListSource == null ? 43 : ((Object)((Object)$hostListSource)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClusterReachabilityHealthCheckConfig(name=" + this.getName() + ", hostNamePattern=" + this.getHostNamePattern() + ", hosts=" + String.valueOf(this.getHosts()) + ", portRange=" + this.getPortRange() + ", connectTimeout=" + this.getConnectTimeout() + ", checkInterval=" + this.getCheckInterval() + ", hostNameMode=" + String.valueOf((Object)this.getHostNameMode()) + ", mode=" + String.valueOf((Object)this.getMode()) + ", selectionMode=" + String.valueOf((Object)this.getSelectionMode()) + ", hostListSource=" + String.valueOf((Object)this.getHostListSource()) + ")";
    }

    @Generated
    public ClusterReachabilityHealthCheckConfig() {
    }

    @ConstructorProperties(value={"name", "hostNamePattern", "hosts", "portRange", "connectTimeout", "checkInterval", "hostNameMode", "mode", "selectionMode", "hostListSource"})
    @Generated
    public ClusterReachabilityHealthCheckConfig(String name, String hostNamePattern, List<String> hosts, String portRange, int connectTimeout, int checkInterval, HostNameMode hostNameMode, HealthCheckMode mode, SelectionMode selectionMode, HostListSource hostListSource) {
        this.name = name;
        this.hostNamePattern = hostNamePattern;
        this.hosts = hosts;
        this.portRange = portRange;
        this.connectTimeout = connectTimeout;
        this.checkInterval = checkInterval;
        this.hostNameMode = hostNameMode;
        this.mode = mode;
        this.selectionMode = selectionMode;
        this.hostListSource = hostListSource;
    }

    public static enum HostNameMode {
        PATTERN,
        LIST;

    }

    public static enum SelectionMode {
        RANDOM,
        SEQUENTIAL;

    }

    public static enum HostListSource {
        CONFIG,
        DYNAMIC;

    }
}

