/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard.alert;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import io.dyuti.dropwizard.alert.AlertPublisher;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetricsAlertPublisher
implements AlertPublisher {
    private final MetricRegistry metricRegistry;
    private final Map<String, Counter> alertCounters;

    public MetricsAlertPublisher(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.alertCounters = new ConcurrentHashMap<String, Counter>();
    }

    @Override
    public void publish(String name, HealthCheck.Result result) {
        this.alertCounters.computeIfAbsent(name, k -> this.metricRegistry.counter(k + ".healthcheck.alerts")).inc();
    }
}

