/*
 * Decompiled with CFR 0.152.
 */
package io.dyuti.dropwizard;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.core.setup.Environment;
import io.dyuti.dropwizard.alert.AlertPublisher;
import io.dyuti.dropwizard.alert.LogAlertPublisher;
import io.dyuti.dropwizard.config.ClusterReachabilityHealthCheckConfig;
import io.dyuti.dropwizard.config.DiskSpaceHealthCheckConfig;
import io.dyuti.dropwizard.config.HealthcheckExtrasConfig;
import io.dyuti.dropwizard.config.HttpHealthCheckConfig;
import io.dyuti.dropwizard.config.MetricHealthCheckConfig;
import io.dyuti.dropwizard.config.TcpHealthCheckConfig;
import io.dyuti.dropwizard.healtcheck.ClusterReachabilityHealthCheck;
import io.dyuti.dropwizard.healtcheck.DiskSpaceHealthCheck;
import io.dyuti.dropwizard.healtcheck.FastTcpHealthCheck;
import io.dyuti.dropwizard.healtcheck.HttpConnectivityHealthCheck;
import io.dyuti.dropwizard.healtcheck.HttpsConnectivityHealthCheck;
import io.dyuti.dropwizard.healtcheck.MetricHealthCheck;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HealthCheckExtrasBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCheckExtrasBundle.class);
    private AlertPublisher alertPublisher;

    public void initialize(Bootstrap<?> bootstrap) {
        this.alertPublisher = new LogAlertPublisher();
    }

    public abstract HealthcheckExtrasConfig getConfig(T var1);

    public AlertPublisher getAlertPublisher() {
        return this.alertPublisher;
    }

    public Map<String, Supplier<List<InetSocketAddress>>> getHostSource() {
        return Collections.emptyMap();
    }

    public void run(T configuration, Environment environment) {
        HealthcheckExtrasConfig config = this.getConfig(configuration);
        if (Objects.nonNull(config.getTcp()) && !config.getTcp().isEmpty()) {
            log.info("Registering TCP Health Checks");
            config.getTcp().forEach(tcpHealthCheckConfig -> {
                log.info("Registering TCP Health Check for: {}", tcpHealthCheckConfig);
                environment.healthChecks().register(tcpHealthCheckConfig.getName(), (HealthCheck)new FastTcpHealthCheck((TcpHealthCheckConfig)tcpHealthCheckConfig, this.getAlertPublisher()));
            });
        }
        if (Objects.nonNull(config.getHttp()) && !config.getHttp().isEmpty()) {
            log.info("Registering HTTP Health Checks");
            config.getHttp().stream().filter(c -> !c.getUrl().startsWith("https")).forEach(httpConfig -> {
                log.info("Registering Http Health Check for: {}", httpConfig);
                environment.healthChecks().register(httpConfig.getName(), (HealthCheck)new HttpConnectivityHealthCheck((HttpHealthCheckConfig)httpConfig, this.getAlertPublisher()));
            });
            config.getHttp().stream().filter(c -> c.getUrl().startsWith("https")).forEach(httpConfig -> {
                log.info("Registering Https Health Check for: {}", httpConfig);
                environment.healthChecks().register(httpConfig.getName(), (HealthCheck)new HttpsConnectivityHealthCheck((HttpHealthCheckConfig)httpConfig, this.getAlertPublisher()));
            });
        }
        if (Objects.nonNull(config.getDisk()) && !config.getDisk().isEmpty()) {
            log.info("Registering Disk Space Health Checks");
            config.getDisk().forEach(diskConfig -> {
                log.info("Registering Disk Space Health Check for: {}", diskConfig);
                environment.healthChecks().register(diskConfig.getName(), (HealthCheck)new DiskSpaceHealthCheck((DiskSpaceHealthCheckConfig)diskConfig, this.getAlertPublisher()));
            });
        }
        if (Objects.nonNull(config.getMetric()) && !config.getMetric().isEmpty()) {
            log.info("Registering Metric Health Checks");
            config.getMetric().forEach(metricHealthCheckConfig -> {
                log.info("Registering Metric Health Check for: {}", metricHealthCheckConfig);
                environment.healthChecks().register(metricHealthCheckConfig.getName(), (HealthCheck)new MetricHealthCheck(environment, (MetricHealthCheckConfig)metricHealthCheckConfig, this.getAlertPublisher()));
            });
        }
        if (Objects.nonNull(config.getCluster()) && !config.getCluster().isEmpty()) {
            log.info("Registering Cluster Reachability Health Checks");
            config.getCluster().forEach(clusterConfig -> {
                log.info("Registering Cluster Reachability Health Check for: {}", clusterConfig);
                if (clusterConfig.getHostListSource() == ClusterReachabilityHealthCheckConfig.HostListSource.CONFIG) {
                    environment.healthChecks().register(clusterConfig.getName(), (HealthCheck)new ClusterReachabilityHealthCheck((ClusterReachabilityHealthCheckConfig)clusterConfig, this.getAlertPublisher()));
                } else {
                    Supplier<List<InetSocketAddress>> source = this.getHostSource().get(clusterConfig.getName());
                    if (Objects.nonNull(source)) {
                        environment.healthChecks().register(clusterConfig.getName(), (HealthCheck)new ClusterReachabilityHealthCheck((ClusterReachabilityHealthCheckConfig)clusterConfig, this.getAlertPublisher(), source));
                    } else {
                        log.error("No host source found for: {}", (Object)clusterConfig.getHostListSource());
                    }
                }
            });
        }
    }
}

