package io.dyte.webrtc

import DyteWebRTC.DyteRTCDefaultVideoDecoderFactory
import DyteWebRTC.DyteRTCDefaultVideoEncoderFactory
import DyteWebRTC.DyteRTCPeerConnectionFactory
import DyteWebRTC.DyteRTCPeerConnectionFactoryOptions
import DyteWebRTC.RTCCleanupSSL
import DyteWebRTC.RTCInitFieldTrialDictionary
import DyteWebRTC.RTCInitializeSSL
import DyteWebRTC.RTCShutdownInternalTracer

actual object WebRtc {

  private var _peerConnectionFactory: DyteRTCPeerConnectionFactory? = null
  val peerConnectionFactory: DyteRTCPeerConnectionFactory
    get() =
      checkNotNull(_peerConnectionFactory) {
        "Ensure WebRtc.initialize() is called before accessing this field!"
      }

  actual fun initialize(forceSoftwareEncoder: Boolean, forceSoftwareDecoder: Boolean) {
    initializePeerConnectionFactory()
    _peerConnectionFactory = buildPeerConnectionFactory(null)
  }

  private fun initializePeerConnectionFactory() {
    RTCInitFieldTrialDictionary(emptyMap<Any?, Any?>())
    RTCInitializeSSL()
  }

  private fun buildPeerConnectionFactory(
    options: DyteRTCPeerConnectionFactoryOptions?
  ): DyteRTCPeerConnectionFactory {
    val factory =
      DyteRTCPeerConnectionFactory(
        DyteRTCDefaultVideoEncoderFactory(),
        DyteRTCDefaultVideoDecoderFactory(),
      )
    options?.also { factory.setOptions(options) }
    return factory
  }

  actual fun dispose() {
    RTCShutdownInternalTracer()
    RTCCleanupSSL()
  }
}
