package io.dyte.webrtc

import DyteWebRTC.DyteRTCStatistics
import DyteWebRTC.DyteRTCStatisticsReport

actual class RtcStatsReport(val native: DyteRTCStatisticsReport) {
  actual val timestampUs: Long = (native.timestamp_us * 1_000_000).toLong()
  actual val stats: Map<String, RtcStats> =
    (native.statistics as Map<String, DyteRTCStatistics>).mapValues { (_, v) -> RtcStats(v) }

  actual override fun toString(): String = native.toString()
}
