package io.dyte.webrtc

expect class RtpParameters {
    var codecs: MutableList<RtpCodecParameters>
    var encodings: List<RtpEncodingParameters>
    var headerExtension: MutableList<HeaderExtension>
    val rtcp: RtcpParameters
    var transactionId: String
}

expect class RtpCodecParameters {
    /**
     * Payload type used to identify this codec in RTP packets.
     */
    var payloadType: Int

    /**
     * The codec's MIME media type and subtype specified as a [String] of the form "type/subtype".
     */
    val mimeType: String?

    /**
     * Clock rate in Hertz.
     */
    val clockRate: Int?

    /**
     * The number of audio channels used. Set to null for video codecs.
     */
    var numChannels: Int?

    /**
     * The "format specific parameters" field from the "a=fmtp" line in the SDP
     */
    val parameters: MutableMap<String, String>

    fun setRtpCodecParameters(
        payloadType: Int = this.payloadType,
        mimeType: String? = this.mimeType,
        clockRate: Int? = this.clockRate,
        numChannels: Int? = this.numChannels,
        parameters: MutableMap<String, String> = this.parameters
    )
}

expect class RtpEncodingParameters {
    /**
     * If non-null, this represents the RID that identifies this encoding layer.
     * RIDs are used to identify layers in simulcast.
     */
    var rid: String?

    /**
     * Set to true to cause this encoding to be sent, and false for it not to
     * be sent.
     */
    var active: Boolean

    /**
     * The relative bitrate priority of this encoding. Currently this is
     * implemented for the entire RTP sender by using the value of the first
     * encoding parameter. See: https://w3c.github.io/webrtc-priority/#enumdef-rtcprioritytype
     * "very-low" = 0.5
     * "low" = 1.0
     * "medium" = 2.0
     * "high" = 4.0
     */
    var bitratePriority: Double

    /**
     * The relative DiffServ Code Point priority for this encoding, allowing
     * packets to be marked relatively higher or lower without affecting bandwidth allocations.
     */
    var networkPriority: Int

    /**
     * If non-null, this represents the Transport Independent Application Specific maximum
     * bandwidth defined in RFC3890. If null, there is no maximum bitrate.
     */
    var maxBitrateBps: Int?

    /**
     * The minimum bitrate in bps for video.
     */
    var minBitrateBps: Int?

    /**
     * The max framerate in fps for video.
     */
    var maxFramerate: Int?

    /**
     * The number of temporal layers for video.
     */
    val numTemporalLayers: Int?

    /**
     * If non-null, scale the width and height down by this factor for video. If null,
     * implementation default scaling factor will be used.
     */
    var scaleResolutionDownBy: Double?

    /**
     * SSRC to be used by this encoding.
     * Can't be changed between getParameters/setParameters.
     */
    val ssrc: Long?

    fun setRtpEncodingParameters(
        rid: String? = this.rid,
        active: Boolean = this.active,
        bitratePriority: Double = this.bitratePriority,
        networkPriority: Int = this.networkPriority,
        maxBitrateBps: Int? = this.maxBitrateBps,
        minBitrateBps: Int? = this.minBitrateBps,
        maxFramerate: Int? = this.maxFramerate,
        numTemporalLayers: Int? = this.numTemporalLayers,
        scaleResolutionDownBy: Double? = this.scaleResolutionDownBy,
        ssrc: Long? = this.ssrc
    )
}

class CommonRtpEncodingParameters {
    /**
     * If non-null, this represents the RID that identifies this encoding layer.
     * RIDs are used to identify layers in simulcast.
     */
    var rid: String? = null;

    /**
     * Set to true to cause this encoding to be sent, and false for it not to
     * be sent.
     */
    var active: Boolean = false;

    /**
     * The relative bitrate priority of this encoding. Currently this is
     * implemented for the entire RTP sender by using the value of the first
     * encoding parameter. See: https://w3c.github.io/webrtc-priority/#enumdef-rtcprioritytype
     * "very-low" = 0.5
     * "low" = 1.0
     * "medium" = 2.0
     * "high" = 4.0
     */
    var bitratePriority: Double = 2.0;

    /**
     * The relative DiffServ Code Point priority for this encoding, allowing
     * packets to be marked relatively higher or lower without affecting bandwidth allocations.
     */
    var networkPriority: Int = -1;

    /**
     * If non-null, this represents the Transport Independent Application Specific maximum
     * bandwidth defined in RFC3890. If null, there is no maximum bitrate.
     */
    var maxBitrateBps: Int? = null;

    /**
     * The minimum bitrate in bps for video.
     */
    var minBitrateBps: Int? = null;

    /**
     * The max framerate in fps for video.
     */
    var maxFramerate: Int? = null;

    /**
     * The number of temporal layers for video.
     */
    var numTemporalLayers: Int? = null;

    /**
     * If non-null, scale the width and height down by this factor for video. If null,
     * implementation default scaling factor will be used.
     */
    var scaleResolutionDownBy: Double? = null;

    /**
     * SSRC to be used by this encoding.
     * Can't be changed between getParameters/setParameters.
     */
    var ssrc: Long? = null;
}

expect class HeaderExtension {
    /**
     * The URI of the RTP header extension, as defined in RFC5285.
     **/
    val uri: String

    /**
     * The value put in the RTP packet to identify the header extension.
     **/
    val id: Int

    /**
     * Whether the header extension is encrypted or not.
     **/
    var encrypted: Boolean
}

expect class RtcpParameters {
    /**
     * The Canonical Name used by RTCP
     **/
    var cname: String

    /**
     * Whether reduced size RTCP is configured or compound RTCP
     **/
    var reducedSize: Boolean?
}
