@file:JvmName("WebRtcKmpJVM")

package io.dyte.webrtc

import dev.onvoid.webrtc.PeerConnectionFactory
import dev.onvoid.webrtc.logging.Logging
import dev.onvoid.webrtc.media.MediaDevices
import dev.onvoid.webrtc.media.audio.AudioDeviceModule
import dev.onvoid.webrtc.media.audio.AudioProcessing

actual object WebRtc {

  private var _peerConnectionFactory: PeerConnectionFactory? = null
  internal val peerConnectionFactory: PeerConnectionFactory
    get() =
      checkNotNull(_peerConnectionFactory) {
        "Ensure WebRtc.initialize() is called before accessing this field!"
      }

  private var _audioDeviceModule: AudioDeviceModule? = null
  internal val audioDeviceModule: AudioDeviceModule
    get() {
      return checkNotNull(_audioDeviceModule) {
        "Ensure WebRtc.initialize() is called before accessing this field!"
      }
    }

  fun addDeviceChangeListener(listener: MediaDeviceListener) {
    MediaDevicesImpl.addDeviceChangeListener(listener)
  }

  fun removeDeviceChangeListener(listener: MediaDeviceListener) {
    MediaDevicesImpl.removeDeviceChangeListener(listener)
  }

  fun setAudioOutputDevice(device: MediaDeviceInfo) {
    MediaDevices.getAudioRenderDevices()
      .firstOrNull { it.descriptor == device.deviceId }
      ?.let {
        audioDeviceModule.setPlayoutDevice(it)
        audioDeviceModule.initPlayout()
      }
  }

  fun getDefaultAudioOutput(): MediaDeviceInfo? {
    return MediaDevices.getDefaultAudioRenderDevice()?.let {
      MediaDeviceInfo(deviceId = it.descriptor, label = it.name, kind = MediaDeviceKind.AudioOutput)
    }
  }

  fun disposePeerConnectionFactory() {
    peerConnectionFactory.dispose()
  }

  actual fun initialize(forceSoftwareEncoder: Boolean, forceSoftwareDecoder: Boolean) {
    val audioModule =
      AudioDeviceModule().apply {
        MediaDevices.getDefaultAudioRenderDevice()?.let {
          setPlayoutDevice(it)
          initPlayout()
        }
      }
    _audioDeviceModule = audioModule
    _peerConnectionFactory = PeerConnectionFactory(audioModule)
  }

  actual fun dispose() {}
}

class WebRtcBuilder(
  var loggingSeverity: Logging.Severity? = null,
  val audioModule: AudioDeviceModule? = null,
  val audioProcessing: AudioProcessing? = null,
)
