package io.dyte.webrtc

import dev.onvoid.webrtc.media.video.VideoDesktopSource
import dev.onvoid.webrtc.media.video.VideoDeviceSource
import dev.onvoid.webrtc.media.video.VideoTrack
import dev.onvoid.webrtc.media.video.VideoTrackSink

actual class VideoStreamTrack
constructor(
  private val jvm: VideoTrack,
  private val cameraSource: VideoDeviceSource? = null,
  private val desktopSource: VideoDesktopSource? = null,
) : MediaStreamTrack(jvm) {

  init {
    cameraSource?.start()
    desktopSource?.start()
  }

  actual suspend fun switchCamera(deviceId: String?) {
    // TODO
  }

  fun addSink(sink: VideoTrackSink) {
    jvm.addSink(sink)
  }

  fun removeSink(sink: VideoTrackSink) {
    jvm.removeSink(sink)
  }

  override fun onSetEnabled(enabled: Boolean) {
    jvm.isEnabled = enabled
  }

  override fun onStop() {
    cameraSource?.stop()
    cameraSource?.dispose()
    desktopSource?.stop()
    desktopSource?.dispose()
  }
}
