/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import dev.onvoid.webrtc.RTCCertificatePEM;
import dev.onvoid.webrtc.logging.Logging;
import io.dyte.webrtc.KeyType;
import io.dyte.webrtc.RtcCertificatePemKt;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/dyte/webrtc/RtcCertificatePem;", "", "native", "Ldev/onvoid/webrtc/RTCCertificatePEM;", "(Ldev/onvoid/webrtc/RTCCertificatePEM;)V", "certificate", "", "getCertificate", "()Ljava/lang/String;", "getNative", "()Ldev/onvoid/webrtc/RTCCertificatePEM;", "privateKey", "getPrivateKey", "Companion", "webrtc-kmp"})
public final class RtcCertificatePem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RTCCertificatePEM native;

    public RtcCertificatePem(@NotNull RTCCertificatePEM rTCCertificatePEM) {
        Intrinsics.checkNotNullParameter((Object)rTCCertificatePEM, (String)"native");
        this.native = rTCCertificatePEM;
    }

    @NotNull
    public final RTCCertificatePEM getNative() {
        return this.native;
    }

    @NotNull
    public final String getPrivateKey() {
        String string = this.native.getPrivateKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrivateKey(...)");
        return string;
    }

    @NotNull
    public final String getCertificate() {
        String string = this.native.getCertificate();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCertificate(...)");
        return string;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lio/dyte/webrtc/RtcCertificatePem$Companion;", "", "()V", "generateCertificate", "Lio/dyte/webrtc/RtcCertificatePem;", "keyType", "Lio/dyte/webrtc/KeyType;", "expires", "", "(Lio/dyte/webrtc/KeyType;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "generateSelfSignedCertificate", "Lorg/bouncycastle/cert/X509CertificateHolder;", "keyPair", "Ljava/security/KeyPair;", "algorithm", "", "webrtc-kmp"})
    @SourceDebugExtension(value={"SMAP\nRtcCertificatePem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcCertificatePem.kt\nio/dyte/webrtc/RtcCertificatePem$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object generateCertificate(@NotNull KeyType keyType, long expires, @NotNull Continuation<? super RtcCertificatePem> $completion) {
            String string;
            KeyPairGenerator keyPairGenerator;
            switch (WhenMappings.$EnumSwitchMapping$0[keyType.ordinal()]) {
                case 1: {
                    KeyPairGenerator keyPairGenerator2;
                    KeyPairGenerator $this$generateCertificate_u24lambda_u240 = keyPairGenerator2 = KeyPairGenerator.getInstance("RSA", "BC");
                    boolean bl = false;
                    $this$generateCertificate_u24lambda_u240.initialize(1024);
                    keyPairGenerator = keyPairGenerator2;
                    break;
                }
                case 2: {
                    KeyPairGenerator keyPairGenerator2;
                    KeyPairGenerator $this$generateCertificate_u24lambda_u241 = keyPairGenerator2 = KeyPairGenerator.getInstance("ECDSA", "BC");
                    boolean bl = false;
                    ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
                    $this$generateCertificate_u24lambda_u241.initialize((AlgorithmParameterSpec)ecSpec);
                    keyPairGenerator = keyPairGenerator2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KeyPairGenerator generator = keyPairGenerator;
            KeyPair pair = generator.generateKeyPair();
            Intrinsics.checkNotNull((Object)pair);
            switch (WhenMappings.$EnumSwitchMapping$0[keyType.ordinal()]) {
                case 2: {
                    string = "SHA256withECDSA";
                    break;
                }
                case 1: {
                    string = "SHA256withRSA";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            X509CertificateHolder cert = this.generateSelfSignedCertificate(pair, expires, string);
            return new RtcCertificatePem(new RTCCertificatePEM(RtcCertificatePemKt.access$getPrivateKeyPkcs1Pem(pair), RtcCertificatePemKt.access$getCertificatePem(cert), cert.getNotAfter().getTime()));
        }

        public static /* synthetic */ Object generateCertificate$default(Companion companion, KeyType keyType, long l, Continuation continuation, int n, Object object) {
            if ((n & 1) != 0) {
                keyType = KeyType.ECDSA;
            }
            if ((n & 2) != 0) {
                l = 2592000L;
            }
            return companion.generateCertificate(keyType, l, (Continuation<? super RtcCertificatePem>)continuation);
        }

        private final X509CertificateHolder generateSelfSignedCertificate(KeyPair keyPair, long expires, String algorithm) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            X500Principal subject = new X500Principal("CN=WebRTC");
            long notAfter = expires + 31536000000L;
            ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{new GeneralName(2, "WebRTC")};
            ASN1Encodable[] encodableAltNames = aSN1EncodableArray;
            KeyPurposeId[] keyPurposeIdArray = new KeyPurposeId[2];
            Intrinsics.checkNotNullExpressionValue((Object)KeyPurposeId.id_kp_serverAuth, (String)"id_kp_serverAuth");
            Intrinsics.checkNotNullExpressionValue((Object)KeyPurposeId.id_kp_clientAuth, (String)"id_kp_clientAuth");
            KeyPurposeId[] purposes = keyPurposeIdArray;
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(subject, BigInteger.ONE, new Date(expires), new Date(notAfter), subject, keyPair.getPublic());
            try {
                certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
                certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
                certBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(purposes));
                certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence(encodableAltNames));
                ContentSigner contentSigner = new JcaContentSignerBuilder(algorithm).build(keyPair.getPrivate());
                Intrinsics.checkNotNullExpressionValue((Object)contentSigner, (String)"build(...)");
                ContentSigner signer = contentSigner;
                X509CertificateHolder x509CertificateHolder = certBuilder.build(signer);
                Intrinsics.checkNotNullExpressionValue((Object)x509CertificateHolder, (String)"build(...)");
                return x509CertificateHolder;
            }
            catch (Exception e) {
                Logging.error((String)e.getMessage());
                throw new AssertionError((Object)e.getMessage());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KeyType.values().length];
                try {
                    nArray[KeyType.RSA.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KeyType.ECDSA.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

