package io.dyte.webrtc

import dev.onvoid.webrtc.RTCRtcpParameters
import dev.onvoid.webrtc.RTCRtpCodecParameters
import dev.onvoid.webrtc.RTCRtpEncodingParameters
import dev.onvoid.webrtc.RTCRtpHeaderExtensionParameters
import dev.onvoid.webrtc.RTCRtpParameters

actual class RtpParameters(val native: RTCRtpParameters) {
  actual var codecs: MutableList<RtpCodecParameters> = arrayListOf()
    get() = native.codecs.map { RtpCodecParameters(it) }.toMutableList()

  actual var encodings: List<RtpEncodingParameters> = emptyList()

  actual var headerExtension: MutableList<HeaderExtension> = arrayListOf()
    get() = native.headerExtensions.map { HeaderExtension(it) }.toMutableList()

  actual val rtcp: RtcpParameters
    get() = RtcpParameters(native.rtcp)

  actual var transactionId: String = "TODO"
}

actual class RtpCodecParameters(val native: RTCRtpCodecParameters) {
  actual var payloadType: Int = 0
    get() = native.payloadType

  actual val mimeType: String?
    get() =
      try {
        val kindField = native::class.java.getField("kind")
        kindField.isAccessible = true
        val kind = kindField.get(native) as? String
        if (kind != null && native.codecName != null) "$kind/${native.codecName}" else null
      } catch (e: Throwable) {
        // Log.e("RtpCodecParameters", "Getting 'kind' field failed", e)
        null
      }

  actual val clockRate: Int?
    get() = native.clockRate

  actual var numChannels: Int? = null
    get() = native.channels

  actual val parameters: MutableMap<String, String>
    get() = native.parameters

  actual fun setRtpCodecParameters(
    payloadType: Int,
    mimeType: String?,
    clockRate: Int?,
    numChannels: Int?,
    parameters: MutableMap<String, String>,
  ) {
    // TODO
  }
}

actual class RtpEncodingParameters(val native: RTCRtpEncodingParameters) {
  actual var rid: String? = null
    get() = null

  actual var active: Boolean = false
    get() = native.active

  actual var bitratePriority: Double = 0.0
    get() = 0.0

  actual var networkPriority: Int = -1
    get() = 0

  actual var maxBitrateBps: Int? = null
    get() = native.maxBitrate

  actual var minBitrateBps: Int? = null
    get() = native.minBitrate

  actual var maxFramerate: Int? = null
    get() = native.maxFramerate.toInt()

  actual val numTemporalLayers: Int?
    get() = null

  actual var scaleResolutionDownBy: Double? = null
    get() = native.scaleResolutionDownBy

  actual val ssrc: Long?
    get() = native.ssrc

  actual fun setRtpEncodingParameters(
    rid: String?,
    active: Boolean,
    bitratePriority: Double,
    networkPriority: Int,
    maxBitrateBps: Int?,
    minBitrateBps: Int?,
    maxFramerate: Int?,
    numTemporalLayers: Int?,
    scaleResolutionDownBy: Double?,
    ssrc: Long?,
  ) {}
}

actual class HeaderExtension(val native: RTCRtpHeaderExtensionParameters) {
  actual val uri: String
    get() = native.uri

  actual val id: Int
    get() = native.id

  actual var encrypted: Boolean = false
    get() = native.encrypted
}

actual class RtcpParameters(val native: RTCRtcpParameters) {
  actual var cname: String = ""
    get() = native.cName

  /** Whether reduced size RTCP is configured or compound RTCP */
  actual var reducedSize: Boolean? = null
    get() = native.reducedSize
}
