/*
 * Decompiled with CFR 0.152.
 */
package io.dyte.webrtc;

import io.dyte.webrtc.MediaStreamTrackKind;
import io.dyte.webrtc.MediaStreamTrackState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u0014J\b\u0010\"\u001a\u00020!H\u0014J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\tH\u0014J\u0006\u0010%\u001a\u00020!R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lio/dyte/webrtc/MediaStreamTrack;", "", "native", "Ldev/onvoid/webrtc/media/MediaStreamTrack;", "(Ldev/onvoid/webrtc/media/MediaStreamTrack;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/dyte/webrtc/MediaStreamTrackState;", "value", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "id", "", "getId", "()Ljava/lang/String;", "kind", "Lio/dyte/webrtc/MediaStreamTrackKind;", "getKind", "()Lio/dyte/webrtc/MediaStreamTrackKind;", "label", "getLabel", "getNative", "()Ldev/onvoid/webrtc/media/MediaStreamTrack;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "getInitialState", "onSetEnabled", "", "onStop", "setMuted", "muted", "stop", "webrtc-kmp"})
@SourceDebugExtension(value={"SMAP\nMediaStreamTrack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaStreamTrack.kt\nio/dyte/webrtc/MediaStreamTrack\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,72:1\n230#2,5:73\n230#2,5:78\n230#2,5:83\n*S KotlinDebug\n*F\n+ 1 MediaStreamTrack.kt\nio/dyte/webrtc/MediaStreamTrack\n*L\n47#1:73,5\n53#1:78,5\n55#1:83,5\n*E\n"})
public abstract class MediaStreamTrack {
    @NotNull
    private final dev.onvoid.webrtc.media.MediaStreamTrack native;
    @NotNull
    private final MutableStateFlow<MediaStreamTrackState> _state;
    @NotNull
    private final StateFlow<MediaStreamTrackState> state;

    public MediaStreamTrack(@NotNull dev.onvoid.webrtc.media.MediaStreamTrack mediaStreamTrack) {
        Intrinsics.checkNotNullParameter((Object)mediaStreamTrack, (String)"native");
        this.native = mediaStreamTrack;
        this._state = StateFlowKt.MutableStateFlow((Object)this.getInitialState());
        this.state = FlowKt.asStateFlow(this._state);
    }

    @NotNull
    public final dev.onvoid.webrtc.media.MediaStreamTrack getNative() {
        return this.native;
    }

    @NotNull
    public final String getId() {
        String string = this.native.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @NotNull
    public final MediaStreamTrackKind getKind() {
        MediaStreamTrackKind mediaStreamTrackKind;
        String string = this.native.getKind();
        if (Intrinsics.areEqual((Object)string, (Object)"audio")) {
            mediaStreamTrackKind = MediaStreamTrackKind.Audio;
        } else if (Intrinsics.areEqual((Object)string, (Object)"video")) {
            mediaStreamTrackKind = MediaStreamTrackKind.Video;
        } else {
            throw new IllegalStateException(("Unknown track kind: " + this.native.getKind()).toString());
        }
        return mediaStreamTrackKind;
    }

    @NotNull
    public final String getLabel() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getKind().ordinal()]) {
            case 1: {
                string = "microphone";
                break;
            }
            case 2: {
                string = "camera";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public final boolean getEnabled() {
        return this.native.isEnabled();
    }

    public final void setEnabled(boolean value) {
        if (value == this.native.isEnabled()) {
            return;
        }
        this.native.setEnabled(value);
        this.onSetEnabled(value);
    }

    @NotNull
    public final StateFlow<MediaStreamTrackState> getState() {
        return this.state;
    }

    public final void stop() {
        MediaStreamTrackState it;
        MediaStreamTrackState nextValue$iv;
        Object prevValue$iv;
        if (this._state.getValue() instanceof MediaStreamTrackState.Ended) {
            return;
        }
        MutableStateFlow<MediaStreamTrackState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (MediaStreamTrackState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (MediaStreamTrackState)new MediaStreamTrackState.Ended(it.getMuted()))));
        this.onStop();
    }

    protected void setMuted(boolean muted) {
        if (muted) {
            MediaStreamTrackState it;
            MediaStreamTrackState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<MediaStreamTrackState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (MediaStreamTrackState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.mute())));
        } else {
            MediaStreamTrackState it;
            MediaStreamTrackState nextValue$iv;
            Object prevValue$iv;
            MutableStateFlow<MediaStreamTrackState> $this$update$iv = this._state;
            boolean $i$f$update = false;
            do {
                prevValue$iv = $this$update$iv.getValue();
                it = (MediaStreamTrackState)prevValue$iv;
                boolean bl = false;
            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.unmute())));
        }
    }

    protected void onSetEnabled(boolean enabled) {
    }

    protected void onStop() {
    }

    private final MediaStreamTrackState getInitialState() {
        MediaStreamTrackState mediaStreamTrackState;
        dev.onvoid.webrtc.media.MediaStreamTrackState mediaStreamTrackState2 = this.native.getState();
        if (mediaStreamTrackState2 == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$1[mediaStreamTrackState2.ordinal()]) {
            case 1: {
                mediaStreamTrackState = new MediaStreamTrackState.Live(false);
                break;
            }
            case 2: {
                mediaStreamTrackState = new MediaStreamTrackState.Ended(false);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mediaStreamTrackState;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MediaStreamTrackKind.values().length];
            try {
                nArray[MediaStreamTrackKind.Audio.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaStreamTrackKind.Video.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[dev.onvoid.webrtc.media.MediaStreamTrackState.values().length];
            try {
                nArray[dev.onvoid.webrtc.media.MediaStreamTrackState.LIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[dev.onvoid.webrtc.media.MediaStreamTrackState.ENDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

