package io.dyte.webrtc

actual class RtpParameters(val js: RTCRtpParameters) {
  actual var codecs: MutableList<RtpCodecParameters> = arrayListOf()
    get() = js.codes.map { RtpCodecParameters(it) }.toMutableList()

  actual var encodings: List<RtpEncodingParameters> = emptyList()
    get() = emptyList() // TODO

  actual var headerExtension: MutableList<HeaderExtension> = arrayListOf()
    get() = mutableListOf() // TODO

  actual val rtcp: RtcpParameters
    get() = RtcpParameters(js.rtcp)

  actual var transactionId: String = ""
    get() = "" // TODO
}

actual class RtpCodecParameters(val js: RTCRtpCodecParameters) {
  actual var payloadType: Int = 0
    get() = js.payloadType ?: 0

  actual val mimeType: String?
    get() = js.mimeType

  actual val clockRate: Int?
    get() = js.clockRate

  actual var numChannels: Int? = null
    get() = js.channels

  actual val parameters: MutableMap<String, String>
    get() = mapOf("sdpFmtpLine" to "${js.sdpFmtpLine}").toMutableMap() // TODO

  actual fun setRtpCodecParameters(
    payloadType: Int,
    mimeType: String?,
    clockRate: Int?,
    numChannels: Int?,
    parameters: MutableMap<String, String>,
  ) {
    //        native.payloadType = payloadType
    //        //native.mimeType = mimeType
    //        native.clockRate = clockRate
    //        native.numChannels = numChannels
    //        native.parameters = parameters
  }
}

actual class RtcpParameters(val js: RTCRtcpParameters) {
  actual var cname: String = ""
    get() = js.cname

  actual var reducedSize: Boolean? = null
    get() = js.reducedSize
}

actual class RtpEncodingParameters {
  actual var rid: String? = null
  actual var active: Boolean = false
  actual var bitratePriority: Double = 0.0
  actual var networkPriority: Int = -1
  actual var maxBitrateBps: Int? = null
  actual var minBitrateBps: Int? = null
  actual var maxFramerate: Int? = null
  actual val numTemporalLayers: Int? = null
  actual var scaleResolutionDownBy: Double? = null
  actual val ssrc: Long? = null

  actual fun setRtpEncodingParameters(
    rid: String?,
    active: Boolean,
    bitratePriority: Double,
    networkPriority: Int,
    maxBitrateBps: Int?,
    minBitrateBps: Int?,
    maxFramerate: Int?,
    numTemporalLayers: Int?,
    scaleResolutionDownBy: Double?,
    ssrc: Long?,
  ) {
    //        native.rid = rid
    //        native.active = active
    //        native.bitratePriority = bitratePriority
    //        native.networkPriority = networkPriority
    //        native.maxBitrateBps = maxBitrateBps
    //        native.minBitrateBps = minBitrateBps
    //        native.maxFramerate = maxFramerate
    //        native.numTemporalLayers = numTemporalLayers
    //        native.scaleResolutionDownBy = scaleResolutionDownBy
    //        native.ssrc = ssrc
  }
}

actual class HeaderExtension {
  actual val uri: String = ""
  actual val id: Int = -1
  actual var encrypted: Boolean = false
}
