(function (_, Kotlin, $module$kotlinx_coroutines_core, $module$webrtc_adapter) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Exception_init = Kotlin.kotlin.Exception_init_pdl1vj$;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Exception = Kotlin.kotlin.Exception;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var Unit = Kotlin.kotlin.Unit;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var FlowCollector = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.FlowCollector;
  var Flow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.Flow;
  var filterNotNull = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.filterNotNull_4gngrh$;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  var MutableSharedFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.MutableSharedFlow_ympafm$;
  var asSharedFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.asSharedFlow_6h5w7a$;
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  var await_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.await_t11jrl$;
  var equals = Kotlin.equals;
  var add = Kotlin.kotlin.js.add_g26eq9$;
  var Pair = Kotlin.kotlin.Pair;
  var IllegalStateException_init = Kotlin.kotlin.IllegalStateException_init_pdl1vj$;
  var ArrayList_init_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var MutableStateFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.MutableStateFlow_mh5how$;
  var asStateFlow = $module$kotlinx_coroutines_core.kotlinx.coroutines.flow.asStateFlow_96vxi6$;
  var WebRtcAdapter = $module$webrtc_adapter.default;
  var L2592000 = Kotlin.Long.fromInt(2592000);
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  var L_1 = Kotlin.Long.NEG_ONE;
  var emptyMap = Kotlin.kotlin.collections.emptyMap_q3lmfv$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var toString = Kotlin.toString;
  var mapOf = Kotlin.kotlin.collections.mapOf_x2b85n$;
  var toMutableMap = Kotlin.kotlin.collections.toMutableMap_abgq59$;
  var unboxChar = Kotlin.unboxChar;
  var isLowerCase = Kotlin.kotlin.text.isLowerCase_myv2d0$;
  var titlecase = Kotlin.kotlin.text.titlecase_myv2d0$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  CameraVideoCapturerException.prototype = Object.create(Exception.prototype);
  CameraVideoCapturerException.prototype.constructor = CameraVideoCapturerException;
  DataChannelState.prototype = Object.create(Enum.prototype);
  DataChannelState.prototype.constructor = DataChannelState;
  MediaDeviceKind.prototype = Object.create(Enum.prototype);
  MediaDeviceKind.prototype.constructor = MediaDeviceKind;
  FacingMode.prototype = Object.create(Enum.prototype);
  FacingMode.prototype.constructor = FacingMode;
  ResizeMode.prototype = Object.create(Enum.prototype);
  ResizeMode.prototype.constructor = ResizeMode;
  MediaStreamTrackKind.prototype = Object.create(Enum.prototype);
  MediaStreamTrackKind.prototype.constructor = MediaStreamTrackKind;
  TlsCertPolicy.prototype = Object.create(Enum.prototype);
  TlsCertPolicy.prototype.constructor = TlsCertPolicy;
  KeyType.prototype = Object.create(Enum.prototype);
  KeyType.prototype.constructor = KeyType;
  RtcpMuxPolicy.prototype = Object.create(Enum.prototype);
  RtcpMuxPolicy.prototype.constructor = RtcpMuxPolicy;
  BundlePolicy.prototype = Object.create(Enum.prototype);
  BundlePolicy.prototype.constructor = BundlePolicy;
  IceTransportPolicy.prototype = Object.create(Enum.prototype);
  IceTransportPolicy.prototype.constructor = IceTransportPolicy;
  SignalingState.prototype = Object.create(Enum.prototype);
  SignalingState.prototype.constructor = SignalingState;
  IceConnectionState.prototype = Object.create(Enum.prototype);
  IceConnectionState.prototype.constructor = IceConnectionState;
  PeerConnectionState.prototype = Object.create(Enum.prototype);
  PeerConnectionState.prototype.constructor = PeerConnectionState;
  IceGatheringState.prototype = Object.create(Enum.prototype);
  IceGatheringState.prototype.constructor = IceGatheringState;
  RtpTransceiverDirection.prototype = Object.create(Enum.prototype);
  RtpTransceiverDirection.prototype.constructor = RtpTransceiverDirection;
  SessionDescriptionType.prototype = Object.create(Enum.prototype);
  SessionDescriptionType.prototype.constructor = SessionDescriptionType;
  AudioStreamTrack.prototype = Object.create(MediaStreamTrack.prototype);
  AudioStreamTrack.prototype.constructor = AudioStreamTrack;
  VideoStreamTrack.prototype = Object.create(MediaStreamTrack.prototype);
  VideoStreamTrack.prototype.constructor = VideoStreamTrack;
  function CameraVideoCapturerException(message) {
    CameraVideoCapturerException$Companion_getInstance();
    Exception_init(message, this);
    this.name = 'CameraVideoCapturerException';
  }
  function CameraVideoCapturerException$Companion() {
    CameraVideoCapturerException$Companion_instance = this;
  }
  CameraVideoCapturerException$Companion.prototype.notFound_ettlkw$ = function (constraints) {
    return new CameraVideoCapturerException('Camera not found. ' + constraints);
  };
  CameraVideoCapturerException$Companion.prototype.notFound_m8c8it$ = function (constraints) {
    return new CameraVideoCapturerException('Camera not found. ' + constraints);
  };
  CameraVideoCapturerException$Companion.prototype.notFound_r54exu$ = function (facingMode) {
    return new CameraVideoCapturerException('Camera not found: ' + facingMode);
  };
  CameraVideoCapturerException$Companion.prototype.notFound_61zpoe$ = function (cameraId) {
    return new CameraVideoCapturerException('Camera ID: ' + cameraId + ' not found');
  };
  CameraVideoCapturerException$Companion.prototype.capturerStopped = function () {
    return new CameraVideoCapturerException('Camera video capturer stopped');
  };
  CameraVideoCapturerException$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CameraVideoCapturerException$Companion_instance = null;
  function CameraVideoCapturerException$Companion_getInstance() {
    if (CameraVideoCapturerException$Companion_instance === null) {
      new CameraVideoCapturerException$Companion();
    }
    return CameraVideoCapturerException$Companion_instance;
  }
  CameraVideoCapturerException.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CameraVideoCapturerException',
    interfaces: [Exception]
  };
  var FLOW_BUFFER_CAPACITY;
  function DataChannelState(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function DataChannelState_initFields() {
    DataChannelState_initFields = function () {
    };
    DataChannelState$Connecting_instance = new DataChannelState('Connecting', 0);
    DataChannelState$Open_instance = new DataChannelState('Open', 1);
    DataChannelState$Closing_instance = new DataChannelState('Closing', 2);
    DataChannelState$Closed_instance = new DataChannelState('Closed', 3);
  }
  var DataChannelState$Connecting_instance;
  function DataChannelState$Connecting_getInstance() {
    DataChannelState_initFields();
    return DataChannelState$Connecting_instance;
  }
  var DataChannelState$Open_instance;
  function DataChannelState$Open_getInstance() {
    DataChannelState_initFields();
    return DataChannelState$Open_instance;
  }
  var DataChannelState$Closing_instance;
  function DataChannelState$Closing_getInstance() {
    DataChannelState_initFields();
    return DataChannelState$Closing_instance;
  }
  var DataChannelState$Closed_instance;
  function DataChannelState$Closed_getInstance() {
    DataChannelState_initFields();
    return DataChannelState$Closed_instance;
  }
  DataChannelState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DataChannelState',
    interfaces: [Enum]
  };
  function DataChannelState$values() {
    return [DataChannelState$Connecting_getInstance(), DataChannelState$Open_getInstance(), DataChannelState$Closing_getInstance(), DataChannelState$Closed_getInstance()];
  }
  DataChannelState.values = DataChannelState$values;
  function DataChannelState$valueOf(name) {
    switch (name) {
      case 'Connecting':
        return DataChannelState$Connecting_getInstance();
      case 'Open':
        return DataChannelState$Open_getInstance();
      case 'Closing':
        return DataChannelState$Closing_getInstance();
      case 'Closed':
        return DataChannelState$Closed_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.DataChannelState.' + name);
    }
  }
  DataChannelState.valueOf_61zpoe$ = DataChannelState$valueOf;
  function MediaDeviceInfo(deviceId, label, kind) {
    this.deviceId = deviceId;
    this.label = label;
    this.kind = kind;
  }
  MediaDeviceInfo.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaDeviceInfo',
    interfaces: []
  };
  MediaDeviceInfo.prototype.component1 = function () {
    return this.deviceId;
  };
  MediaDeviceInfo.prototype.component2 = function () {
    return this.label;
  };
  MediaDeviceInfo.prototype.component3 = function () {
    return this.kind;
  };
  MediaDeviceInfo.prototype.copy_q3sssp$ = function (deviceId, label, kind) {
    return new MediaDeviceInfo(deviceId === void 0 ? this.deviceId : deviceId, label === void 0 ? this.label : label, kind === void 0 ? this.kind : kind);
  };
  MediaDeviceInfo.prototype.toString = function () {
    return 'MediaDeviceInfo(deviceId=' + Kotlin.toString(this.deviceId) + (', label=' + Kotlin.toString(this.label)) + (', kind=' + Kotlin.toString(this.kind)) + ')';
  };
  MediaDeviceInfo.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.deviceId) | 0;
    result = result * 31 + Kotlin.hashCode(this.label) | 0;
    result = result * 31 + Kotlin.hashCode(this.kind) | 0;
    return result;
  };
  MediaDeviceInfo.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.deviceId, other.deviceId) && Kotlin.equals(this.label, other.label) && Kotlin.equals(this.kind, other.kind)))));
  };
  function MediaDeviceKind(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function MediaDeviceKind_initFields() {
    MediaDeviceKind_initFields = function () {
    };
    MediaDeviceKind$VideoInput_instance = new MediaDeviceKind('VideoInput', 0);
    MediaDeviceKind$AudioInput_instance = new MediaDeviceKind('AudioInput', 1);
  }
  var MediaDeviceKind$VideoInput_instance;
  function MediaDeviceKind$VideoInput_getInstance() {
    MediaDeviceKind_initFields();
    return MediaDeviceKind$VideoInput_instance;
  }
  var MediaDeviceKind$AudioInput_instance;
  function MediaDeviceKind$AudioInput_getInstance() {
    MediaDeviceKind_initFields();
    return MediaDeviceKind$AudioInput_instance;
  }
  MediaDeviceKind.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaDeviceKind',
    interfaces: [Enum]
  };
  function MediaDeviceKind$values() {
    return [MediaDeviceKind$VideoInput_getInstance(), MediaDeviceKind$AudioInput_getInstance()];
  }
  MediaDeviceKind.values = MediaDeviceKind$values;
  function MediaDeviceKind$valueOf(name) {
    switch (name) {
      case 'VideoInput':
        return MediaDeviceKind$VideoInput_getInstance();
      case 'AudioInput':
        return MediaDeviceKind$AudioInput_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.MediaDeviceKind.' + name);
    }
  }
  MediaDeviceKind.valueOf_61zpoe$ = MediaDeviceKind$valueOf;
  var DEFAULT_VIDEO_WIDTH;
  var DEFAULT_VIDEO_HEIGHT;
  var DEFAULT_FRAME_RATE;
  function MediaDevices() {
    MediaDevices$Companion_getInstance();
  }
  function MediaDevices$getUserMedia$lambda($receiver) {
    return Unit;
  }
  MediaDevices.prototype.getUserMedia_jgsmsx$ = function (streamConstraints, continuation, callback$default) {
    if (streamConstraints === void 0)
      streamConstraints = MediaDevices$getUserMedia$lambda;
    return callback$default ? callback$default(streamConstraints, continuation) : this.getUserMedia_jgsmsx$$default(streamConstraints, continuation);
  };
  function MediaDevices$getUserMedia$lambda_0(closure$audio, closure$video) {
    return function ($receiver) {
      if (closure$audio)
        $receiver.audio_6taknv$();
      if (closure$video)
        $receiver.video_6taknv$();
      return Unit;
    };
  }
  MediaDevices.prototype.getUserMedia_dqye30$$default = function (audio, video, continuation) {
    return this.getUserMedia_jgsmsx$(MediaDevices$getUserMedia$lambda_0(audio, video), continuation);
  };
  MediaDevices.prototype.getUserMedia_dqye30$ = function (audio, video, continuation, callback$default) {
    if (audio === void 0)
      audio = false;
    if (video === void 0)
      video = false;
    return callback$default ? callback$default(audio, video, continuation) : this.getUserMedia_dqye30$$default(audio, video, continuation);
  };
  function MediaDevices$Companion() {
    MediaDevices$Companion_instance = this;
    this.$delegate_x89wbc$_0 = mediaDevices;
  }
  MediaDevices$Companion.prototype.enumerateDevices = function (continuation) {
    return this.$delegate_x89wbc$_0.enumerateDevices(continuation);
  };
  MediaDevices$Companion.prototype.getDisplayMedia = function (continuation) {
    return this.$delegate_x89wbc$_0.getDisplayMedia(continuation);
  };
  MediaDevices$Companion.prototype.getUserMedia_jgsmsx$$default = function (streamConstraints, continuation) {
    return this.$delegate_x89wbc$_0.getUserMedia_jgsmsx$$default(streamConstraints, continuation);
  };
  MediaDevices$Companion.prototype.getUserMedia_dqye30$$default = function (audio, video, continuation) {
    return this.$delegate_x89wbc$_0.getUserMedia_dqye30$$default(audio, video, continuation);
  };
  MediaDevices$Companion.prototype.supportsDisplayMedia = function (continuation) {
    return this.$delegate_x89wbc$_0.supportsDisplayMedia(continuation);
  };
  MediaDevices$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: [MediaDevices]
  };
  var MediaDevices$Companion_instance = null;
  function MediaDevices$Companion_getInstance() {
    if (MediaDevices$Companion_instance === null) {
      new MediaDevices$Companion();
    }
    return MediaDevices$Companion_instance;
  }
  MediaDevices.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MediaDevices',
    interfaces: []
  };
  function toMandatoryMap($receiver) {
    var $receiver_0 = LinkedHashMap_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    if ((tmp$_0 = (tmp$ = $receiver.echoCancellation) != null ? tmp$.exact : null) != null) {
      var pair = to('googEchoCancellation', tmp$_0.toString());
      $receiver_0.put_xwzc9p$(pair.first, pair.second);
    }
    if ((tmp$_2 = (tmp$_1 = $receiver.autoGainControl) != null ? tmp$_1.exact : null) != null) {
      var pair_0 = to('googAutoGainControl', tmp$_2.toString());
      $receiver_0.put_xwzc9p$(pair_0.first, pair_0.second);
    }
    if ((tmp$_4 = (tmp$_3 = $receiver.noiseSuppression) != null ? tmp$_3.exact : null) != null) {
      var pair_1 = to('googNoiseSuppression', tmp$_4.toString());
      $receiver_0.put_xwzc9p$(pair_1.first, pair_1.second);
    }
    return $receiver_0;
  }
  function toOptionalMap($receiver) {
    var $receiver_0 = LinkedHashMap_init();
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    if ((tmp$_0 = (tmp$ = $receiver.echoCancellation) != null ? tmp$.ideal : null) != null) {
      var pair = to('googEchoCancellation', tmp$_0.toString());
      $receiver_0.put_xwzc9p$(pair.first, pair.second);
    }
    if ((tmp$_2 = (tmp$_1 = $receiver.autoGainControl) != null ? tmp$_1.ideal : null) != null) {
      var pair_0 = to('googAutoGainControl', tmp$_2.toString());
      $receiver_0.put_xwzc9p$(pair_0.first, pair_0.second);
    }
    if ((tmp$_4 = (tmp$_3 = $receiver.noiseSuppression) != null ? tmp$_3.ideal : null) != null) {
      var pair_1 = to('googNoiseSuppression', tmp$_4.toString());
      $receiver_0.put_xwzc9p$(pair_1.first, pair_1.second);
    }
    return $receiver_0;
  }
  function get_audioTracks($receiver) {
    var $receiver_0 = $receiver.tracks;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver_0.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      var tmp$_1;
      if ((tmp$_0 = Kotlin.isType(tmp$_1 = element, AudioStreamTrack) ? tmp$_1 : null) != null) {
        destination.add_11rb$(tmp$_0);
      }
    }
    return destination;
  }
  function get_videoTracks($receiver) {
    var $receiver_0 = $receiver.tracks;
    var destination = ArrayList_init();
    var tmp$;
    tmp$ = $receiver_0.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0;
      var tmp$_1;
      if ((tmp$_0 = Kotlin.isType(tmp$_1 = element, VideoStreamTrack) ? tmp$_1 : null) != null) {
        destination.add_11rb$(tmp$_0);
      }
    }
    return destination;
  }
  function MediaStreamConstraints(audio, video) {
    if (audio === void 0)
      audio = null;
    if (video === void 0)
      video = null;
    this.audio = audio;
    this.video = video;
  }
  MediaStreamConstraints.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaStreamConstraints',
    interfaces: []
  };
  MediaStreamConstraints.prototype.component1 = function () {
    return this.audio;
  };
  MediaStreamConstraints.prototype.component2 = function () {
    return this.video;
  };
  MediaStreamConstraints.prototype.copy_hma6x9$ = function (audio, video) {
    return new MediaStreamConstraints(audio === void 0 ? this.audio : audio, video === void 0 ? this.video : video);
  };
  MediaStreamConstraints.prototype.toString = function () {
    return 'MediaStreamConstraints(audio=' + Kotlin.toString(this.audio) + (', video=' + Kotlin.toString(this.video)) + ')';
  };
  MediaStreamConstraints.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.audio) | 0;
    result = result * 31 + Kotlin.hashCode(this.video) | 0;
    return result;
  };
  MediaStreamConstraints.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.audio, other.audio) && Kotlin.equals(this.video, other.video)))));
  };
  function AudioTrackConstraints(deviceId, groupId, autoGainControl, channelCount, echoCancellation, latency, noiseSuppression, sampleRate, volume) {
    if (deviceId === void 0)
      deviceId = null;
    if (groupId === void 0)
      groupId = null;
    if (autoGainControl === void 0)
      autoGainControl = null;
    if (channelCount === void 0)
      channelCount = null;
    if (echoCancellation === void 0)
      echoCancellation = null;
    if (latency === void 0)
      latency = null;
    if (noiseSuppression === void 0)
      noiseSuppression = null;
    if (sampleRate === void 0)
      sampleRate = null;
    if (volume === void 0)
      volume = null;
    this.deviceId = deviceId;
    this.groupId = groupId;
    this.autoGainControl = autoGainControl;
    this.channelCount = channelCount;
    this.echoCancellation = echoCancellation;
    this.latency = latency;
    this.noiseSuppression = noiseSuppression;
    this.sampleRate = sampleRate;
    this.volume = volume;
  }
  AudioTrackConstraints.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AudioTrackConstraints',
    interfaces: []
  };
  AudioTrackConstraints.prototype.component1 = function () {
    return this.deviceId;
  };
  AudioTrackConstraints.prototype.component2 = function () {
    return this.groupId;
  };
  AudioTrackConstraints.prototype.component3 = function () {
    return this.autoGainControl;
  };
  AudioTrackConstraints.prototype.component4 = function () {
    return this.channelCount;
  };
  AudioTrackConstraints.prototype.component5 = function () {
    return this.echoCancellation;
  };
  AudioTrackConstraints.prototype.component6 = function () {
    return this.latency;
  };
  AudioTrackConstraints.prototype.component7 = function () {
    return this.noiseSuppression;
  };
  AudioTrackConstraints.prototype.component8 = function () {
    return this.sampleRate;
  };
  AudioTrackConstraints.prototype.component9 = function () {
    return this.volume;
  };
  AudioTrackConstraints.prototype.copy_9v4u02$ = function (deviceId, groupId, autoGainControl, channelCount, echoCancellation, latency, noiseSuppression, sampleRate, volume) {
    return new AudioTrackConstraints(deviceId === void 0 ? this.deviceId : deviceId, groupId === void 0 ? this.groupId : groupId, autoGainControl === void 0 ? this.autoGainControl : autoGainControl, channelCount === void 0 ? this.channelCount : channelCount, echoCancellation === void 0 ? this.echoCancellation : echoCancellation, latency === void 0 ? this.latency : latency, noiseSuppression === void 0 ? this.noiseSuppression : noiseSuppression, sampleRate === void 0 ? this.sampleRate : sampleRate, volume === void 0 ? this.volume : volume);
  };
  AudioTrackConstraints.prototype.toString = function () {
    return 'AudioTrackConstraints(deviceId=' + Kotlin.toString(this.deviceId) + (', groupId=' + Kotlin.toString(this.groupId)) + (', autoGainControl=' + Kotlin.toString(this.autoGainControl)) + (', channelCount=' + Kotlin.toString(this.channelCount)) + (', echoCancellation=' + Kotlin.toString(this.echoCancellation)) + (', latency=' + Kotlin.toString(this.latency)) + (', noiseSuppression=' + Kotlin.toString(this.noiseSuppression)) + (', sampleRate=' + Kotlin.toString(this.sampleRate)) + (', volume=' + Kotlin.toString(this.volume)) + ')';
  };
  AudioTrackConstraints.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.deviceId) | 0;
    result = result * 31 + Kotlin.hashCode(this.groupId) | 0;
    result = result * 31 + Kotlin.hashCode(this.autoGainControl) | 0;
    result = result * 31 + Kotlin.hashCode(this.channelCount) | 0;
    result = result * 31 + Kotlin.hashCode(this.echoCancellation) | 0;
    result = result * 31 + Kotlin.hashCode(this.latency) | 0;
    result = result * 31 + Kotlin.hashCode(this.noiseSuppression) | 0;
    result = result * 31 + Kotlin.hashCode(this.sampleRate) | 0;
    result = result * 31 + Kotlin.hashCode(this.volume) | 0;
    return result;
  };
  AudioTrackConstraints.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.deviceId, other.deviceId) && Kotlin.equals(this.groupId, other.groupId) && Kotlin.equals(this.autoGainControl, other.autoGainControl) && Kotlin.equals(this.channelCount, other.channelCount) && Kotlin.equals(this.echoCancellation, other.echoCancellation) && Kotlin.equals(this.latency, other.latency) && Kotlin.equals(this.noiseSuppression, other.noiseSuppression) && Kotlin.equals(this.sampleRate, other.sampleRate) && Kotlin.equals(this.volume, other.volume)))));
  };
  function VideoTrackConstraints(deviceId, groupId, aspectRatio, facingMode, frameRate, height, width, resizeMode) {
    if (deviceId === void 0)
      deviceId = null;
    if (groupId === void 0)
      groupId = null;
    if (aspectRatio === void 0)
      aspectRatio = null;
    if (facingMode === void 0)
      facingMode = null;
    if (frameRate === void 0)
      frameRate = null;
    if (height === void 0)
      height = null;
    if (width === void 0)
      width = null;
    if (resizeMode === void 0)
      resizeMode = null;
    this.deviceId = deviceId;
    this.groupId = groupId;
    this.aspectRatio = aspectRatio;
    this.facingMode = facingMode;
    this.frameRate = frameRate;
    this.height = height;
    this.width = width;
    this.resizeMode = resizeMode;
  }
  VideoTrackConstraints.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'VideoTrackConstraints',
    interfaces: []
  };
  VideoTrackConstraints.prototype.component1 = function () {
    return this.deviceId;
  };
  VideoTrackConstraints.prototype.component2 = function () {
    return this.groupId;
  };
  VideoTrackConstraints.prototype.component3 = function () {
    return this.aspectRatio;
  };
  VideoTrackConstraints.prototype.component4 = function () {
    return this.facingMode;
  };
  VideoTrackConstraints.prototype.component5 = function () {
    return this.frameRate;
  };
  VideoTrackConstraints.prototype.component6 = function () {
    return this.height;
  };
  VideoTrackConstraints.prototype.component7 = function () {
    return this.width;
  };
  VideoTrackConstraints.prototype.component8 = function () {
    return this.resizeMode;
  };
  VideoTrackConstraints.prototype.copy_as3ftg$ = function (deviceId, groupId, aspectRatio, facingMode, frameRate, height, width, resizeMode) {
    return new VideoTrackConstraints(deviceId === void 0 ? this.deviceId : deviceId, groupId === void 0 ? this.groupId : groupId, aspectRatio === void 0 ? this.aspectRatio : aspectRatio, facingMode === void 0 ? this.facingMode : facingMode, frameRate === void 0 ? this.frameRate : frameRate, height === void 0 ? this.height : height, width === void 0 ? this.width : width, resizeMode === void 0 ? this.resizeMode : resizeMode);
  };
  VideoTrackConstraints.prototype.toString = function () {
    return 'VideoTrackConstraints(deviceId=' + Kotlin.toString(this.deviceId) + (', groupId=' + Kotlin.toString(this.groupId)) + (', aspectRatio=' + Kotlin.toString(this.aspectRatio)) + (', facingMode=' + Kotlin.toString(this.facingMode)) + (', frameRate=' + Kotlin.toString(this.frameRate)) + (', height=' + Kotlin.toString(this.height)) + (', width=' + Kotlin.toString(this.width)) + (', resizeMode=' + Kotlin.toString(this.resizeMode)) + ')';
  };
  VideoTrackConstraints.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.deviceId) | 0;
    result = result * 31 + Kotlin.hashCode(this.groupId) | 0;
    result = result * 31 + Kotlin.hashCode(this.aspectRatio) | 0;
    result = result * 31 + Kotlin.hashCode(this.facingMode) | 0;
    result = result * 31 + Kotlin.hashCode(this.frameRate) | 0;
    result = result * 31 + Kotlin.hashCode(this.height) | 0;
    result = result * 31 + Kotlin.hashCode(this.width) | 0;
    result = result * 31 + Kotlin.hashCode(this.resizeMode) | 0;
    return result;
  };
  VideoTrackConstraints.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.deviceId, other.deviceId) && Kotlin.equals(this.groupId, other.groupId) && Kotlin.equals(this.aspectRatio, other.aspectRatio) && Kotlin.equals(this.facingMode, other.facingMode) && Kotlin.equals(this.frameRate, other.frameRate) && Kotlin.equals(this.height, other.height) && Kotlin.equals(this.width, other.width) && Kotlin.equals(this.resizeMode, other.resizeMode)))));
  };
  function Size(width, height) {
    this.width = width;
    this.height = height;
  }
  Size.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Size',
    interfaces: []
  };
  Size.prototype.component1 = function () {
    return this.width;
  };
  Size.prototype.component2 = function () {
    return this.height;
  };
  Size.prototype.copy_vux9f0$ = function (width, height) {
    return new Size(width === void 0 ? this.width : width, height === void 0 ? this.height : height);
  };
  Size.prototype.toString = function () {
    return 'Size(width=' + Kotlin.toString(this.width) + (', height=' + Kotlin.toString(this.height)) + ')';
  };
  Size.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.width) | 0;
    result = result * 31 + Kotlin.hashCode(this.height) | 0;
    return result;
  };
  Size.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.width, other.width) && Kotlin.equals(this.height, other.height)))));
  };
  function FacingMode(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function FacingMode_initFields() {
    FacingMode_initFields = function () {
    };
    FacingMode$User_instance = new FacingMode('User', 0);
    FacingMode$Environment_instance = new FacingMode('Environment', 1);
  }
  var FacingMode$User_instance;
  function FacingMode$User_getInstance() {
    FacingMode_initFields();
    return FacingMode$User_instance;
  }
  var FacingMode$Environment_instance;
  function FacingMode$Environment_getInstance() {
    FacingMode_initFields();
    return FacingMode$Environment_instance;
  }
  FacingMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FacingMode',
    interfaces: [Enum]
  };
  function FacingMode$values() {
    return [FacingMode$User_getInstance(), FacingMode$Environment_getInstance()];
  }
  FacingMode.values = FacingMode$values;
  function FacingMode$valueOf(name) {
    switch (name) {
      case 'User':
        return FacingMode$User_getInstance();
      case 'Environment':
        return FacingMode$Environment_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.FacingMode.' + name);
    }
  }
  FacingMode.valueOf_61zpoe$ = FacingMode$valueOf;
  function ResizeMode(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ResizeMode_initFields() {
    ResizeMode_initFields = function () {
    };
    ResizeMode$None_instance = new ResizeMode('None', 0);
    ResizeMode$CropAndScale_instance = new ResizeMode('CropAndScale', 1);
  }
  var ResizeMode$None_instance;
  function ResizeMode$None_getInstance() {
    ResizeMode_initFields();
    return ResizeMode$None_instance;
  }
  var ResizeMode$CropAndScale_instance;
  function ResizeMode$CropAndScale_getInstance() {
    ResizeMode_initFields();
    return ResizeMode$CropAndScale_instance;
  }
  ResizeMode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ResizeMode',
    interfaces: [Enum]
  };
  function ResizeMode$values() {
    return [ResizeMode$None_getInstance(), ResizeMode$CropAndScale_getInstance()];
  }
  ResizeMode.values = ResizeMode$values;
  function ResizeMode$valueOf(name) {
    switch (name) {
      case 'None':
        return ResizeMode$None_getInstance();
      case 'CropAndScale':
        return ResizeMode$CropAndScale_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.ResizeMode.' + name);
    }
  }
  ResizeMode.valueOf_61zpoe$ = ResizeMode$valueOf;
  function Constrain(exact, ideal) {
    if (exact === void 0)
      exact = null;
    if (ideal === void 0)
      ideal = null;
    this.exact = exact;
    this.ideal = ideal;
  }
  Constrain.prototype.exact_11rb$ = function (value) {
    this.exact = value;
  };
  Constrain.prototype.ideal_11rb$ = function (value) {
    this.ideal = value;
  };
  Constrain.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Constrain',
    interfaces: []
  };
  Constrain.prototype.component1 = function () {
    return this.exact;
  };
  Constrain.prototype.component2 = function () {
    return this.ideal;
  };
  Constrain.prototype.copy_xwzc9q$ = function (exact, ideal) {
    return new Constrain(exact === void 0 ? this.exact : exact, ideal === void 0 ? this.ideal : ideal);
  };
  Constrain.prototype.toString = function () {
    return 'Constrain(exact=' + Kotlin.toString(this.exact) + (', ideal=' + Kotlin.toString(this.ideal)) + ')';
  };
  Constrain.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.exact) | 0;
    result = result * 31 + Kotlin.hashCode(this.ideal) | 0;
    return result;
  };
  Constrain.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.exact, other.exact) && Kotlin.equals(this.ideal, other.ideal)))));
  };
  function MediaStreamConstraintsBuilder() {
    this.constraints_8be2vx$ = new MediaStreamConstraints();
  }
  function MediaStreamConstraintsBuilder$audio$lambda($receiver) {
    return Unit;
  }
  MediaStreamConstraintsBuilder.prototype.audio_6taknv$ = function (enabled) {
    if (enabled === void 0)
      enabled = true;
    if (enabled) {
      this.audio_qpxc52$(MediaStreamConstraintsBuilder$audio$lambda);
    }
  };
  MediaStreamConstraintsBuilder.prototype.audio_qpxc52$ = function (build) {
    var tmp$;
    var trackConstraintsBuilder = new AudioTrackConstraintsBuilder((tmp$ = this.constraints_8be2vx$.audio) != null ? tmp$ : new AudioTrackConstraints());
    build(trackConstraintsBuilder);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_hma6x9$(trackConstraintsBuilder.constraints_8be2vx$);
  };
  function MediaStreamConstraintsBuilder$video$lambda($receiver) {
    return Unit;
  }
  MediaStreamConstraintsBuilder.prototype.video_6taknv$ = function (enabled) {
    if (enabled === void 0)
      enabled = true;
    if (enabled) {
      this.video_zdcbet$(MediaStreamConstraintsBuilder$video$lambda);
    }
  };
  MediaStreamConstraintsBuilder.prototype.video_zdcbet$ = function (build) {
    var tmp$;
    var trackConstraintsBuilder = new VideoTrackConstraintsBuilder((tmp$ = this.constraints_8be2vx$.video) != null ? tmp$ : new VideoTrackConstraints());
    build(trackConstraintsBuilder);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_hma6x9$(void 0, trackConstraintsBuilder.constraints_8be2vx$);
  };
  MediaStreamConstraintsBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaStreamConstraintsBuilder',
    interfaces: []
  };
  function AudioTrackConstraintsBuilder(constraints) {
    this.constraints_8be2vx$ = constraints;
  }
  AudioTrackConstraintsBuilder.prototype.deviceId_61zpoe$ = function (id) {
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(id);
  };
  AudioTrackConstraintsBuilder.prototype.groupId_61zpoe$ = function (id) {
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, id);
  };
  function AudioTrackConstraintsBuilder$autoGainControl$lambda(closure$enable) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$enable);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.autoGainControl_6taknv$ = function (enable) {
    if (enable === void 0)
      enable = true;
    this.autoGainControl_x0fnwm$(AudioTrackConstraintsBuilder$autoGainControl$lambda(enable));
  };
  AudioTrackConstraintsBuilder.prototype.autoGainControl_x0fnwm$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, constrain);
  };
  function AudioTrackConstraintsBuilder$channelCount$lambda(closure$count) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$count);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.channelCount_za3lpa$ = function (count) {
    this.channelCount_w4ztup$(AudioTrackConstraintsBuilder$channelCount$lambda(count));
  };
  AudioTrackConstraintsBuilder.prototype.channelCount_w4ztup$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, void 0, constrain);
  };
  function AudioTrackConstraintsBuilder$echoCancellation$lambda(closure$enable) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$enable);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.echoCancellation_6taknv$ = function (enable) {
    if (enable === void 0)
      enable = true;
    this.echoCancellation_x0fnwm$(AudioTrackConstraintsBuilder$echoCancellation$lambda(enable));
  };
  AudioTrackConstraintsBuilder.prototype.echoCancellation_x0fnwm$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, void 0, void 0, constrain);
  };
  function AudioTrackConstraintsBuilder$latency$lambda(closure$latency) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$latency);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.latency_14dthe$ = function (latency) {
    this.latency_1d19fv$(AudioTrackConstraintsBuilder$latency$lambda(latency));
  };
  AudioTrackConstraintsBuilder.prototype.latency_1d19fv$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, void 0, void 0, void 0, constrain);
  };
  function AudioTrackConstraintsBuilder$noiseSuppression$lambda(closure$enable) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$enable);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.noiseSuppression_6taknv$ = function (enable) {
    if (enable === void 0)
      enable = true;
    this.noiseSuppression_x0fnwm$(AudioTrackConstraintsBuilder$noiseSuppression$lambda(enable));
  };
  AudioTrackConstraintsBuilder.prototype.noiseSuppression_x0fnwm$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, void 0, void 0, void 0, void 0, constrain);
  };
  function AudioTrackConstraintsBuilder$sampleRate$lambda(closure$count) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$count);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.sampleRate_za3lpa$ = function (count) {
    this.sampleRate_w4ztup$(AudioTrackConstraintsBuilder$sampleRate$lambda(count));
  };
  AudioTrackConstraintsBuilder.prototype.sampleRate_w4ztup$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, void 0, void 0, void 0, void 0, void 0, constrain);
  };
  function AudioTrackConstraintsBuilder$volume$lambda(closure$volume) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$volume);
      return Unit;
    };
  }
  AudioTrackConstraintsBuilder.prototype.volume_14dthe$ = function (volume) {
    this.volume_1d19fv$(AudioTrackConstraintsBuilder$volume$lambda(volume));
  };
  AudioTrackConstraintsBuilder.prototype.volume_1d19fv$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_9v4u02$(void 0, void 0, void 0, void 0, void 0, void 0, void 0, void 0, constrain);
  };
  AudioTrackConstraintsBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AudioTrackConstraintsBuilder',
    interfaces: []
  };
  function VideoTrackConstraintsBuilder(constraints) {
    this.constraints_8be2vx$ = constraints;
  }
  VideoTrackConstraintsBuilder.prototype.deviceId_61zpoe$ = function (id) {
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(id);
  };
  VideoTrackConstraintsBuilder.prototype.groupId_61zpoe$ = function (id) {
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, id);
  };
  function VideoTrackConstraintsBuilder$aspectRatio$lambda(closure$ratio) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$ratio);
      return Unit;
    };
  }
  VideoTrackConstraintsBuilder.prototype.aspectRatio_14dthe$ = function (ratio) {
    this.aspectRatio_1d19fv$(VideoTrackConstraintsBuilder$aspectRatio$lambda(ratio));
  };
  VideoTrackConstraintsBuilder.prototype.aspectRatio_1d19fv$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, void 0, constrain);
  };
  function VideoTrackConstraintsBuilder$facingMode$lambda(closure$mode) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$mode);
      return Unit;
    };
  }
  VideoTrackConstraintsBuilder.prototype.facingMode_r54exu$ = function (mode) {
    this.facingMode_jldi8l$(VideoTrackConstraintsBuilder$facingMode$lambda(mode));
  };
  VideoTrackConstraintsBuilder.prototype.facingMode_jldi8l$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, void 0, void 0, constrain);
  };
  function VideoTrackConstraintsBuilder$frameRate$lambda(closure$ratio) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$ratio);
      return Unit;
    };
  }
  VideoTrackConstraintsBuilder.prototype.frameRate_14dthe$ = function (ratio) {
    this.frameRate_1d19fv$(VideoTrackConstraintsBuilder$frameRate$lambda(ratio));
  };
  VideoTrackConstraintsBuilder.prototype.frameRate_1d19fv$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, void 0, void 0, void 0, constrain);
  };
  function VideoTrackConstraintsBuilder$height$lambda(closure$height) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$height);
      return Unit;
    };
  }
  VideoTrackConstraintsBuilder.prototype.height_za3lpa$ = function (height) {
    this.height_w4ztup$(VideoTrackConstraintsBuilder$height$lambda(height));
  };
  VideoTrackConstraintsBuilder.prototype.height_w4ztup$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, void 0, void 0, void 0, void 0, constrain);
  };
  function VideoTrackConstraintsBuilder$width$lambda(closure$width) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$width);
      return Unit;
    };
  }
  VideoTrackConstraintsBuilder.prototype.width_za3lpa$ = function (width) {
    this.width_w4ztup$(VideoTrackConstraintsBuilder$width$lambda(width));
  };
  VideoTrackConstraintsBuilder.prototype.width_w4ztup$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, void 0, void 0, void 0, void 0, void 0, constrain);
  };
  function VideoTrackConstraintsBuilder$resizeMode$lambda(closure$mode) {
    return function ($receiver) {
      $receiver.exact_11rb$(closure$mode);
      return Unit;
    };
  }
  VideoTrackConstraintsBuilder.prototype.resizeMode_30kuyw$ = function (mode) {
    this.resizeMode_c8e3d1$(VideoTrackConstraintsBuilder$resizeMode$lambda(mode));
  };
  VideoTrackConstraintsBuilder.prototype.resizeMode_c8e3d1$ = function (build) {
    var constrain = new Constrain();
    build(constrain);
    this.constraints_8be2vx$ = this.constraints_8be2vx$.copy_as3ftg$(void 0, void 0, void 0, void 0, void 0, void 0, void 0, constrain);
  };
  VideoTrackConstraintsBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'VideoTrackConstraintsBuilder',
    interfaces: []
  };
  function unsafeFlow$ObjectLiteral(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$.prototype.constructor = Coroutine$collect_42ocv1$;
  Coroutine$collect_42ocv1$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda;
  Coroutine$unsafeTransform$lambda$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda.prototype.constructor = Coroutine$unsafeTransform$lambda;
  Coroutine$unsafeTransform$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$filter$lambda(closure$predicate_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$predicate = closure$predicate_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$filter$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$filter$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$filter$lambda.prototype.constructor = Coroutine$filter$lambda;
  Coroutine$filter$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$predicate(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.result_0) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(this.local$value, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            return Unit;
          case 4:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function filter$lambda(closure$predicate_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$filter$lambda(closure$predicate_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_0(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_0($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_0.prototype.constructor = Coroutine$collect_42ocv1$_0;
  Coroutine$collect_42ocv1$_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_0.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_0(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_0.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_0.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_0;
  Coroutine$unsafeTransform$lambda$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_0(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_0(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_0.prototype.constructor = Coroutine$unsafeTransform$lambda_0;
  Coroutine$unsafeTransform$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_0(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_0(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_0(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda.prototype.constructor = Coroutine$map$lambda;
  Coroutine$map$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_1(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_1($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_1.prototype.constructor = Coroutine$collect_42ocv1$_1;
  Coroutine$collect_42ocv1$_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_1.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_1(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_1.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_1.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_1;
  Coroutine$unsafeTransform$lambda$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_1(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_1(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_1.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_1.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_1.prototype.constructor = Coroutine$unsafeTransform$lambda_1;
  Coroutine$unsafeTransform$lambda_1.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_1(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_1(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_1(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$filterNot$lambda(closure$predicate_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$predicate = closure$predicate_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$filterNot$lambda.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$filterNot$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$filterNot$lambda.prototype.constructor = Coroutine$filterNot$lambda;
  Coroutine$filterNot$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$predicate(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.result_0) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(this.local$value, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            return Unit;
          case 4:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function filterNot$lambda(closure$predicate_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$filterNot$lambda(closure$predicate_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function MediaStreamTrackState() {
  }
  function MediaStreamTrackState$Live(muted) {
    this.muted_1gzp64$_0 = muted;
  }
  Object.defineProperty(MediaStreamTrackState$Live.prototype, 'muted', {
    get: function () {
      return this.muted_1gzp64$_0;
    }
  });
  MediaStreamTrackState$Live.prototype.mute = function () {
    return this.copy_6taknv$(true);
  };
  MediaStreamTrackState$Live.prototype.unmute = function () {
    return this.copy_6taknv$(false);
  };
  MediaStreamTrackState$Live.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Live',
    interfaces: [MediaStreamTrackState]
  };
  MediaStreamTrackState$Live.prototype.component1 = function () {
    return this.muted;
  };
  MediaStreamTrackState$Live.prototype.copy_6taknv$ = function (muted) {
    return new MediaStreamTrackState$Live(muted === void 0 ? this.muted : muted);
  };
  MediaStreamTrackState$Live.prototype.toString = function () {
    return 'Live(muted=' + Kotlin.toString(this.muted) + ')';
  };
  MediaStreamTrackState$Live.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.muted) | 0;
    return result;
  };
  MediaStreamTrackState$Live.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.muted, other.muted))));
  };
  function MediaStreamTrackState$Ended(muted) {
    this.muted_bqf7s$_0 = muted;
  }
  Object.defineProperty(MediaStreamTrackState$Ended.prototype, 'muted', {
    get: function () {
      return this.muted_bqf7s$_0;
    }
  });
  MediaStreamTrackState$Ended.prototype.mute = function () {
    return this.copy_6taknv$(true);
  };
  MediaStreamTrackState$Ended.prototype.unmute = function () {
    return this.copy_6taknv$(false);
  };
  MediaStreamTrackState$Ended.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Ended',
    interfaces: [MediaStreamTrackState]
  };
  MediaStreamTrackState$Ended.prototype.component1 = function () {
    return this.muted;
  };
  MediaStreamTrackState$Ended.prototype.copy_6taknv$ = function (muted) {
    return new MediaStreamTrackState$Ended(muted === void 0 ? this.muted : muted);
  };
  MediaStreamTrackState$Ended.prototype.toString = function () {
    return 'Ended(muted=' + Kotlin.toString(this.muted) + ')';
  };
  MediaStreamTrackState$Ended.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.muted) | 0;
    return result;
  };
  MediaStreamTrackState$Ended.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.muted, other.muted))));
  };
  MediaStreamTrackState.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'MediaStreamTrackState',
    interfaces: []
  };
  function MediaStreamTrackKind(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function MediaStreamTrackKind_initFields() {
    MediaStreamTrackKind_initFields = function () {
    };
    MediaStreamTrackKind$Audio_instance = new MediaStreamTrackKind('Audio', 0);
    MediaStreamTrackKind$Video_instance = new MediaStreamTrackKind('Video', 1);
  }
  var MediaStreamTrackKind$Audio_instance;
  function MediaStreamTrackKind$Audio_getInstance() {
    MediaStreamTrackKind_initFields();
    return MediaStreamTrackKind$Audio_instance;
  }
  var MediaStreamTrackKind$Video_instance;
  function MediaStreamTrackKind$Video_getInstance() {
    MediaStreamTrackKind_initFields();
    return MediaStreamTrackKind$Video_instance;
  }
  MediaStreamTrackKind.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaStreamTrackKind',
    interfaces: [Enum]
  };
  function MediaStreamTrackKind$values() {
    return [MediaStreamTrackKind$Audio_getInstance(), MediaStreamTrackKind$Video_getInstance()];
  }
  MediaStreamTrackKind.values = MediaStreamTrackKind$values;
  function MediaStreamTrackKind$valueOf(name) {
    switch (name) {
      case 'Audio':
        return MediaStreamTrackKind$Audio_getInstance();
      case 'Video':
        return MediaStreamTrackKind$Video_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.MediaStreamTrackKind.' + name);
    }
  }
  MediaStreamTrackKind.valueOf_61zpoe$ = MediaStreamTrackKind$valueOf;
  function get_muted($receiver) {
    return $receiver.state.value.muted;
  }
  function get_readyState($receiver) {
    return $receiver.state.value;
  }
  function Coroutine$get_onEnded$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onEnded$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onEnded$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onEnded$lambda.prototype.constructor = Coroutine$get_onEnded$lambda;
  Coroutine$get_onEnded$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Kotlin.isType(this.local$it, MediaStreamTrackState$Ended);
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onEnded$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onEnded$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onEnded$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$get_onEnded$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onEnded$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onEnded$lambda_0.prototype.constructor = Coroutine$get_onEnded$lambda_0;
  Coroutine$get_onEnded$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onEnded$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onEnded$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onEnded($receiver) {
    var $receiver_0 = $receiver.state;
    var $receiver_1 = new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(filter$lambda(get_onEnded$lambda), $receiver_0));
    return new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda(get_onEnded$lambda_0), $receiver_1));
  }
  function Coroutine$get_onMute$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onMute$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onMute$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onMute$lambda.prototype.constructor = Coroutine$get_onMute$lambda;
  Coroutine$get_onMute$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.muted;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onMute$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onMute$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onMute$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$get_onMute$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onMute$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onMute$lambda_0.prototype.constructor = Coroutine$get_onMute$lambda_0;
  Coroutine$get_onMute$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onMute$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onMute$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onMute($receiver) {
    var $receiver_0 = $receiver.state;
    var $receiver_1 = new unsafeFlow$ObjectLiteral(unsafeTransform$lambda(filter$lambda(get_onMute$lambda), $receiver_0));
    return new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda(get_onMute$lambda_0), $receiver_1));
  }
  function Coroutine$get_onUnmute$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onUnmute$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onUnmute$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onUnmute$lambda.prototype.constructor = Coroutine$get_onUnmute$lambda;
  Coroutine$get_onUnmute$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.muted;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onUnmute$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onUnmute$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onUnmute$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$get_onUnmute$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onUnmute$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onUnmute$lambda_0.prototype.constructor = Coroutine$get_onUnmute$lambda_0;
  Coroutine$get_onUnmute$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onUnmute$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onUnmute$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onUnmute($receiver) {
    var $receiver_0 = $receiver.state;
    var $receiver_1 = new unsafeFlow$ObjectLiteral_1(unsafeTransform$lambda_1(filterNot$lambda(get_onUnmute$lambda), $receiver_0));
    return new unsafeFlow$ObjectLiteral_0(unsafeTransform$lambda_0(map$lambda(get_onUnmute$lambda_0), $receiver_1));
  }
  function OfferAnswerOptions(iceRestart, offerToReceiveAudio, offerToReceiveVideo, voiceActivityDetection) {
    if (iceRestart === void 0)
      iceRestart = null;
    if (offerToReceiveAudio === void 0)
      offerToReceiveAudio = null;
    if (offerToReceiveVideo === void 0)
      offerToReceiveVideo = null;
    if (voiceActivityDetection === void 0)
      voiceActivityDetection = null;
    this.iceRestart = iceRestart;
    this.offerToReceiveAudio = offerToReceiveAudio;
    this.offerToReceiveVideo = offerToReceiveVideo;
    this.voiceActivityDetection = voiceActivityDetection;
  }
  OfferAnswerOptions.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'OfferAnswerOptions',
    interfaces: []
  };
  OfferAnswerOptions.prototype.component1 = function () {
    return this.iceRestart;
  };
  OfferAnswerOptions.prototype.component2 = function () {
    return this.offerToReceiveAudio;
  };
  OfferAnswerOptions.prototype.component3 = function () {
    return this.offerToReceiveVideo;
  };
  OfferAnswerOptions.prototype.component4 = function () {
    return this.voiceActivityDetection;
  };
  OfferAnswerOptions.prototype.copy_bx6eq4$ = function (iceRestart, offerToReceiveAudio, offerToReceiveVideo, voiceActivityDetection) {
    return new OfferAnswerOptions(iceRestart === void 0 ? this.iceRestart : iceRestart, offerToReceiveAudio === void 0 ? this.offerToReceiveAudio : offerToReceiveAudio, offerToReceiveVideo === void 0 ? this.offerToReceiveVideo : offerToReceiveVideo, voiceActivityDetection === void 0 ? this.voiceActivityDetection : voiceActivityDetection);
  };
  OfferAnswerOptions.prototype.toString = function () {
    return 'OfferAnswerOptions(iceRestart=' + Kotlin.toString(this.iceRestart) + (', offerToReceiveAudio=' + Kotlin.toString(this.offerToReceiveAudio)) + (', offerToReceiveVideo=' + Kotlin.toString(this.offerToReceiveVideo)) + (', voiceActivityDetection=' + Kotlin.toString(this.voiceActivityDetection)) + ')';
  };
  OfferAnswerOptions.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.iceRestart) | 0;
    result = result * 31 + Kotlin.hashCode(this.offerToReceiveAudio) | 0;
    result = result * 31 + Kotlin.hashCode(this.offerToReceiveVideo) | 0;
    result = result * 31 + Kotlin.hashCode(this.voiceActivityDetection) | 0;
    return result;
  };
  OfferAnswerOptions.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.iceRestart, other.iceRestart) && Kotlin.equals(this.offerToReceiveAudio, other.offerToReceiveAudio) && Kotlin.equals(this.offerToReceiveVideo, other.offerToReceiveVideo) && Kotlin.equals(this.voiceActivityDetection, other.voiceActivityDetection)))));
  };
  function unsafeFlow$ObjectLiteral_2(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_2($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_2.prototype.constructor = Coroutine$collect_42ocv1$_2;
  Coroutine$collect_42ocv1$_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_2.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_2(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_2.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_2.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_2;
  Coroutine$unsafeTransform$lambda$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_2(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_2(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_2.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_2.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_2.prototype.constructor = Coroutine$unsafeTransform$lambda_2;
  Coroutine$unsafeTransform$lambda_2.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_2(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_2(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_2(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$map$lambda_0(closure$transform_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$map$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$map$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$map$lambda_0.prototype.constructor = Coroutine$map$lambda_0;
  Coroutine$map$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            this.state_0 = 3;
            this.result_0 = this.local$$receiver.emit_11rb$(this.result_0, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function map$lambda_0(closure$transform_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$map$lambda_0(closure$transform_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function unsafeFlow$ObjectLiteral_3(closure$block) {
    this.closure$block = closure$block;
  }
  function Coroutine$collect_42ocv1$_3($this, collector_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$collector = collector_0;
  }
  Coroutine$collect_42ocv1$_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$collect_42ocv1$_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$collect_42ocv1$_3.prototype.constructor = Coroutine$collect_42ocv1$_3;
  Coroutine$collect_42ocv1$_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.closure$block(this.local$collector, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  unsafeFlow$ObjectLiteral_3.prototype.collect_42ocv1$ = function (collector_0, continuation_0, suspended) {
    var instance = new Coroutine$collect_42ocv1$_3(this, collector_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  unsafeFlow$ObjectLiteral_3.$metadata$ = {kind: Kind_CLASS, interfaces: [Flow]};
  function Coroutine$unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0, value_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$ = this$_0;
    this.local$value = value_0;
  }
  Coroutine$unsafeTransform$lambda$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda$lambda_3.prototype.constructor = Coroutine$unsafeTransform$lambda$lambda_3;
  Coroutine$unsafeTransform$lambda$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$transform(this.local$this$, this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0) {
    return function (value_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda$lambda_3(closure$transform_0, this$_0, value_0, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$unsafeTransform$lambda_3(closure$transform_0, this$unsafeTransform_0, $receiver_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$transform = closure$transform_0;
    this.local$this$unsafeTransform = this$unsafeTransform_0;
    this.local$$receiver = $receiver_0;
  }
  Coroutine$unsafeTransform$lambda_3.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$unsafeTransform$lambda_3.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$unsafeTransform$lambda_3.prototype.constructor = Coroutine$unsafeTransform$lambda_3;
  Coroutine$unsafeTransform$lambda_3.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$this$unsafeTransform.collect_42ocv1$(new FlowCollector(unsafeTransform$lambda$lambda_3(this.local$closure$transform, this.local$$receiver)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return this.result_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function unsafeTransform$lambda_3(closure$transform_0, this$unsafeTransform_0) {
    return function ($receiver_0, continuation_0, suspended) {
      var instance = new Coroutine$unsafeTransform$lambda_3(closure$transform_0, this$unsafeTransform_0, $receiver_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$filter$lambda_0(closure$predicate_0, $receiver_0, value_0, controller, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.$controller = controller;
    this.exceptionState_0 = 1;
    this.local$closure$predicate = closure$predicate_0;
    this.local$$receiver = $receiver_0;
    this.local$value = value_0;
  }
  Coroutine$filter$lambda_0.$metadata$ = {kind: Kotlin.Kind.CLASS, simpleName: null, interfaces: [CoroutineImpl]};
  Coroutine$filter$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$filter$lambda_0.prototype.constructor = Coroutine$filter$lambda_0;
  Coroutine$filter$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.local$closure$predicate(this.local$value, this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (this.result_0) {
              this.state_0 = 3;
              this.result_0 = this.local$$receiver.emit_11rb$(this.local$value, this);
              if (this.result_0 === COROUTINE_SUSPENDED)
                return COROUTINE_SUSPENDED;
              continue;
            } else {
              this.state_0 = 4;
              continue;
            }

          case 3:
            return Unit;
          case 4:
            return Unit;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function filter$lambda_0(closure$predicate_0) {
    return function ($receiver_0, value_0, continuation_0, suspended) {
      var instance = new Coroutine$filter$lambda_0(closure$predicate_0, $receiver_0, value_0, this, continuation_0);
      if (suspended)
        return instance;
      else
        return instance.doResume(null);
    };
  }
  function Coroutine$get_onConnectionStateChange$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onConnectionStateChange$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onConnectionStateChange$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onConnectionStateChange$lambda.prototype.constructor = Coroutine$get_onConnectionStateChange$lambda;
  Coroutine$get_onConnectionStateChange$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$ConnectionStateChange) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onConnectionStateChange$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onConnectionStateChange$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onConnectionStateChange$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onConnectionStateChange$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onConnectionStateChange$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onConnectionStateChange$lambda_0.prototype.constructor = Coroutine$get_onConnectionStateChange$lambda_0;
  Coroutine$get_onConnectionStateChange$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.state;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onConnectionStateChange$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onConnectionStateChange$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onConnectionStateChange($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onConnectionStateChange$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onConnectionStateChange$lambda_0), $receiver_1));
  }
  function Coroutine$get_onDataChannel$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onDataChannel$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onDataChannel$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onDataChannel$lambda.prototype.constructor = Coroutine$get_onDataChannel$lambda;
  Coroutine$get_onDataChannel$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$NewDataChannel) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onDataChannel$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onDataChannel$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onDataChannel$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onDataChannel$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onDataChannel$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onDataChannel$lambda_0.prototype.constructor = Coroutine$get_onDataChannel$lambda_0;
  Coroutine$get_onDataChannel$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.dataChannel;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onDataChannel$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onDataChannel$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onDataChannel($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onDataChannel$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onDataChannel$lambda_0), $receiver_1));
  }
  function Coroutine$get_onIceCandidate$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onIceCandidate$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onIceCandidate$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onIceCandidate$lambda.prototype.constructor = Coroutine$get_onIceCandidate$lambda;
  Coroutine$get_onIceCandidate$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$NewIceCandidate) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onIceCandidate$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onIceCandidate$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onIceCandidate$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onIceCandidate$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onIceCandidate$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onIceCandidate$lambda_0.prototype.constructor = Coroutine$get_onIceCandidate$lambda_0;
  Coroutine$get_onIceCandidate$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.candidate;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onIceCandidate$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onIceCandidate$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onIceCandidate($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onIceCandidate$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onIceCandidate$lambda_0), $receiver_1));
  }
  function Coroutine$get_onIceConnectionStateChange$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onIceConnectionStateChange$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onIceConnectionStateChange$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onIceConnectionStateChange$lambda.prototype.constructor = Coroutine$get_onIceConnectionStateChange$lambda;
  Coroutine$get_onIceConnectionStateChange$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$IceConnectionStateChange) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onIceConnectionStateChange$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onIceConnectionStateChange$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onIceConnectionStateChange$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onIceConnectionStateChange$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onIceConnectionStateChange$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onIceConnectionStateChange$lambda_0.prototype.constructor = Coroutine$get_onIceConnectionStateChange$lambda_0;
  Coroutine$get_onIceConnectionStateChange$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.state;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onIceConnectionStateChange$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onIceConnectionStateChange$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onIceConnectionStateChange($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onIceConnectionStateChange$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onIceConnectionStateChange$lambda_0), $receiver_1));
  }
  function Coroutine$get_onIceGatheringState$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onIceGatheringState$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onIceGatheringState$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onIceGatheringState$lambda.prototype.constructor = Coroutine$get_onIceGatheringState$lambda;
  Coroutine$get_onIceGatheringState$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$IceGatheringStateChange) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onIceGatheringState$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onIceGatheringState$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onIceGatheringState$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onIceGatheringState$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onIceGatheringState$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onIceGatheringState$lambda_0.prototype.constructor = Coroutine$get_onIceGatheringState$lambda_0;
  Coroutine$get_onIceGatheringState$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.state;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onIceGatheringState$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onIceGatheringState$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onIceGatheringState($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onIceGatheringState$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onIceGatheringState$lambda_0), $receiver_1));
  }
  function Coroutine$get_onNegotiationNeeded$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onNegotiationNeeded$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onNegotiationNeeded$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onNegotiationNeeded$lambda.prototype.constructor = Coroutine$get_onNegotiationNeeded$lambda;
  Coroutine$get_onNegotiationNeeded$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Kotlin.isType(this.local$it, PeerConnectionEvent$NegotiationNeeded);
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onNegotiationNeeded$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onNegotiationNeeded$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onNegotiationNeeded$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
  }
  Coroutine$get_onNegotiationNeeded$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onNegotiationNeeded$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onNegotiationNeeded$lambda_0.prototype.constructor = Coroutine$get_onNegotiationNeeded$lambda_0;
  Coroutine$get_onNegotiationNeeded$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return Unit;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onNegotiationNeeded$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onNegotiationNeeded$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onNegotiationNeeded($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = new unsafeFlow$ObjectLiteral_3(unsafeTransform$lambda_3(filter$lambda_0(get_onNegotiationNeeded$lambda), $receiver_0));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onNegotiationNeeded$lambda_0), $receiver_1));
  }
  function Coroutine$get_onSignalingStateChange$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onSignalingStateChange$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onSignalingStateChange$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onSignalingStateChange$lambda.prototype.constructor = Coroutine$get_onSignalingStateChange$lambda;
  Coroutine$get_onSignalingStateChange$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$SignalingStateChange) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onSignalingStateChange$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onSignalingStateChange$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onSignalingStateChange$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onSignalingStateChange$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onSignalingStateChange$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onSignalingStateChange$lambda_0.prototype.constructor = Coroutine$get_onSignalingStateChange$lambda_0;
  Coroutine$get_onSignalingStateChange$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.state;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onSignalingStateChange$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onSignalingStateChange$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onSignalingStateChange($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onSignalingStateChange$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onSignalingStateChange$lambda_0), $receiver_1));
  }
  function Coroutine$get_onTrack$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onTrack$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onTrack$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onTrack$lambda.prototype.constructor = Coroutine$get_onTrack$lambda;
  Coroutine$get_onTrack$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$Track) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onTrack$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onTrack$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onTrack$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onTrack$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onTrack$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onTrack$lambda_0.prototype.constructor = Coroutine$get_onTrack$lambda_0;
  Coroutine$get_onTrack$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.trackEvent;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onTrack$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onTrack$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onTrack($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onTrack$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onTrack$lambda_0), $receiver_1));
  }
  function Coroutine$get_onStandardizedIceConnection$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onStandardizedIceConnection$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onStandardizedIceConnection$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onStandardizedIceConnection$lambda.prototype.constructor = Coroutine$get_onStandardizedIceConnection$lambda;
  Coroutine$get_onStandardizedIceConnection$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$StandardizedIceConnectionChange) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onStandardizedIceConnection$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onStandardizedIceConnection$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onStandardizedIceConnection$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onStandardizedIceConnection$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onStandardizedIceConnection$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onStandardizedIceConnection$lambda_0.prototype.constructor = Coroutine$get_onStandardizedIceConnection$lambda_0;
  Coroutine$get_onStandardizedIceConnection$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.state;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onStandardizedIceConnection$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onStandardizedIceConnection$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onStandardizedIceConnection($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onStandardizedIceConnection$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onStandardizedIceConnection$lambda_0), $receiver_1));
  }
  function Coroutine$get_onRemovedIceCandidates$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onRemovedIceCandidates$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onRemovedIceCandidates$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onRemovedIceCandidates$lambda.prototype.constructor = Coroutine$get_onRemovedIceCandidates$lambda;
  Coroutine$get_onRemovedIceCandidates$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$RemovedIceCandidates) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onRemovedIceCandidates$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onRemovedIceCandidates$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onRemovedIceCandidates$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onRemovedIceCandidates$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onRemovedIceCandidates$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onRemovedIceCandidates$lambda_0.prototype.constructor = Coroutine$get_onRemovedIceCandidates$lambda_0;
  Coroutine$get_onRemovedIceCandidates$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.candidates;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onRemovedIceCandidates$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onRemovedIceCandidates$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onRemovedIceCandidates($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onRemovedIceCandidates$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onRemovedIceCandidates$lambda_0), $receiver_1));
  }
  function Coroutine$get_onRemoveTrack$lambda(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onRemoveTrack$lambda.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onRemoveTrack$lambda.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onRemoveTrack$lambda.prototype.constructor = Coroutine$get_onRemoveTrack$lambda;
  Coroutine$get_onRemoveTrack$lambda.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var tmp$;
            return Kotlin.isType(tmp$ = this.local$it, PeerConnectionEvent$RemoveTrack) ? tmp$ : null;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onRemoveTrack$lambda(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onRemoveTrack$lambda(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function Coroutine$get_onRemoveTrack$lambda_0(it_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$it = it_0;
  }
  Coroutine$get_onRemoveTrack$lambda_0.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$get_onRemoveTrack$lambda_0.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$get_onRemoveTrack$lambda_0.prototype.constructor = Coroutine$get_onRemoveTrack$lambda_0;
  Coroutine$get_onRemoveTrack$lambda_0.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            return this.local$it.rtpReceiver;
          case 1:
            throw this.exception_0;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function get_onRemoveTrack$lambda_0(it_0, continuation_0, suspended) {
    var instance = new Coroutine$get_onRemoveTrack$lambda_0(it_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function get_onRemoveTrack($receiver) {
    var $receiver_0 = $receiver.peerConnectionEvent_8be2vx$;
    var $receiver_1 = filterNotNull(new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onRemoveTrack$lambda), $receiver_0)));
    return new unsafeFlow$ObjectLiteral_2(unsafeTransform$lambda_2(map$lambda_0(get_onRemoveTrack$lambda_0), $receiver_1));
  }
  function TlsCertPolicy(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function TlsCertPolicy_initFields() {
    TlsCertPolicy_initFields = function () {
    };
    TlsCertPolicy$TlsCertPolicySecure_instance = new TlsCertPolicy('TlsCertPolicySecure', 0);
    TlsCertPolicy$TlsCertPolicyInsecureNoCheck_instance = new TlsCertPolicy('TlsCertPolicyInsecureNoCheck', 1);
  }
  var TlsCertPolicy$TlsCertPolicySecure_instance;
  function TlsCertPolicy$TlsCertPolicySecure_getInstance() {
    TlsCertPolicy_initFields();
    return TlsCertPolicy$TlsCertPolicySecure_instance;
  }
  var TlsCertPolicy$TlsCertPolicyInsecureNoCheck_instance;
  function TlsCertPolicy$TlsCertPolicyInsecureNoCheck_getInstance() {
    TlsCertPolicy_initFields();
    return TlsCertPolicy$TlsCertPolicyInsecureNoCheck_instance;
  }
  TlsCertPolicy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TlsCertPolicy',
    interfaces: [Enum]
  };
  function TlsCertPolicy$values() {
    return [TlsCertPolicy$TlsCertPolicySecure_getInstance(), TlsCertPolicy$TlsCertPolicyInsecureNoCheck_getInstance()];
  }
  TlsCertPolicy.values = TlsCertPolicy$values;
  function TlsCertPolicy$valueOf(name) {
    switch (name) {
      case 'TlsCertPolicySecure':
        return TlsCertPolicy$TlsCertPolicySecure_getInstance();
      case 'TlsCertPolicyInsecureNoCheck':
        return TlsCertPolicy$TlsCertPolicyInsecureNoCheck_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.TlsCertPolicy.' + name);
    }
  }
  TlsCertPolicy.valueOf_61zpoe$ = TlsCertPolicy$valueOf;
  function KeyType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function KeyType_initFields() {
    KeyType_initFields = function () {
    };
    KeyType$RSA_instance = new KeyType('RSA', 0);
    KeyType$ECDSA_instance = new KeyType('ECDSA', 1);
  }
  var KeyType$RSA_instance;
  function KeyType$RSA_getInstance() {
    KeyType_initFields();
    return KeyType$RSA_instance;
  }
  var KeyType$ECDSA_instance;
  function KeyType$ECDSA_getInstance() {
    KeyType_initFields();
    return KeyType$ECDSA_instance;
  }
  KeyType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KeyType',
    interfaces: [Enum]
  };
  function KeyType$values() {
    return [KeyType$RSA_getInstance(), KeyType$ECDSA_getInstance()];
  }
  KeyType.values = KeyType$values;
  function KeyType$valueOf(name) {
    switch (name) {
      case 'RSA':
        return KeyType$RSA_getInstance();
      case 'ECDSA':
        return KeyType$ECDSA_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.KeyType.' + name);
    }
  }
  KeyType.valueOf_61zpoe$ = KeyType$valueOf;
  function RtcpMuxPolicy(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function RtcpMuxPolicy_initFields() {
    RtcpMuxPolicy_initFields = function () {
    };
    RtcpMuxPolicy$Negotiate_instance = new RtcpMuxPolicy('Negotiate', 0);
    RtcpMuxPolicy$Require_instance = new RtcpMuxPolicy('Require', 1);
  }
  var RtcpMuxPolicy$Negotiate_instance;
  function RtcpMuxPolicy$Negotiate_getInstance() {
    RtcpMuxPolicy_initFields();
    return RtcpMuxPolicy$Negotiate_instance;
  }
  var RtcpMuxPolicy$Require_instance;
  function RtcpMuxPolicy$Require_getInstance() {
    RtcpMuxPolicy_initFields();
    return RtcpMuxPolicy$Require_instance;
  }
  RtcpMuxPolicy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtcpMuxPolicy',
    interfaces: [Enum]
  };
  function RtcpMuxPolicy$values() {
    return [RtcpMuxPolicy$Negotiate_getInstance(), RtcpMuxPolicy$Require_getInstance()];
  }
  RtcpMuxPolicy.values = RtcpMuxPolicy$values;
  function RtcpMuxPolicy$valueOf(name) {
    switch (name) {
      case 'Negotiate':
        return RtcpMuxPolicy$Negotiate_getInstance();
      case 'Require':
        return RtcpMuxPolicy$Require_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.RtcpMuxPolicy.' + name);
    }
  }
  RtcpMuxPolicy.valueOf_61zpoe$ = RtcpMuxPolicy$valueOf;
  function BundlePolicy(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function BundlePolicy_initFields() {
    BundlePolicy_initFields = function () {
    };
    BundlePolicy$Balanced_instance = new BundlePolicy('Balanced', 0);
    BundlePolicy$MaxBundle_instance = new BundlePolicy('MaxBundle', 1);
    BundlePolicy$MaxCompat_instance = new BundlePolicy('MaxCompat', 2);
  }
  var BundlePolicy$Balanced_instance;
  function BundlePolicy$Balanced_getInstance() {
    BundlePolicy_initFields();
    return BundlePolicy$Balanced_instance;
  }
  var BundlePolicy$MaxBundle_instance;
  function BundlePolicy$MaxBundle_getInstance() {
    BundlePolicy_initFields();
    return BundlePolicy$MaxBundle_instance;
  }
  var BundlePolicy$MaxCompat_instance;
  function BundlePolicy$MaxCompat_getInstance() {
    BundlePolicy_initFields();
    return BundlePolicy$MaxCompat_instance;
  }
  BundlePolicy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'BundlePolicy',
    interfaces: [Enum]
  };
  function BundlePolicy$values() {
    return [BundlePolicy$Balanced_getInstance(), BundlePolicy$MaxBundle_getInstance(), BundlePolicy$MaxCompat_getInstance()];
  }
  BundlePolicy.values = BundlePolicy$values;
  function BundlePolicy$valueOf(name) {
    switch (name) {
      case 'Balanced':
        return BundlePolicy$Balanced_getInstance();
      case 'MaxBundle':
        return BundlePolicy$MaxBundle_getInstance();
      case 'MaxCompat':
        return BundlePolicy$MaxCompat_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.BundlePolicy.' + name);
    }
  }
  BundlePolicy.valueOf_61zpoe$ = BundlePolicy$valueOf;
  function IceTransportPolicy(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function IceTransportPolicy_initFields() {
    IceTransportPolicy_initFields = function () {
    };
    IceTransportPolicy$None_instance = new IceTransportPolicy('None', 0);
    IceTransportPolicy$Relay_instance = new IceTransportPolicy('Relay', 1);
    IceTransportPolicy$NoHost_instance = new IceTransportPolicy('NoHost', 2);
    IceTransportPolicy$All_instance = new IceTransportPolicy('All', 3);
  }
  var IceTransportPolicy$None_instance;
  function IceTransportPolicy$None_getInstance() {
    IceTransportPolicy_initFields();
    return IceTransportPolicy$None_instance;
  }
  var IceTransportPolicy$Relay_instance;
  function IceTransportPolicy$Relay_getInstance() {
    IceTransportPolicy_initFields();
    return IceTransportPolicy$Relay_instance;
  }
  var IceTransportPolicy$NoHost_instance;
  function IceTransportPolicy$NoHost_getInstance() {
    IceTransportPolicy_initFields();
    return IceTransportPolicy$NoHost_instance;
  }
  var IceTransportPolicy$All_instance;
  function IceTransportPolicy$All_getInstance() {
    IceTransportPolicy_initFields();
    return IceTransportPolicy$All_instance;
  }
  IceTransportPolicy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceTransportPolicy',
    interfaces: [Enum]
  };
  function IceTransportPolicy$values() {
    return [IceTransportPolicy$None_getInstance(), IceTransportPolicy$Relay_getInstance(), IceTransportPolicy$NoHost_getInstance(), IceTransportPolicy$All_getInstance()];
  }
  IceTransportPolicy.values = IceTransportPolicy$values;
  function IceTransportPolicy$valueOf(name) {
    switch (name) {
      case 'None':
        return IceTransportPolicy$None_getInstance();
      case 'Relay':
        return IceTransportPolicy$Relay_getInstance();
      case 'NoHost':
        return IceTransportPolicy$NoHost_getInstance();
      case 'All':
        return IceTransportPolicy$All_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.IceTransportPolicy.' + name);
    }
  }
  IceTransportPolicy.valueOf_61zpoe$ = IceTransportPolicy$valueOf;
  function SignalingState(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function SignalingState_initFields() {
    SignalingState_initFields = function () {
    };
    SignalingState$Stable_instance = new SignalingState('Stable', 0);
    SignalingState$HaveLocalOffer_instance = new SignalingState('HaveLocalOffer', 1);
    SignalingState$HaveLocalPranswer_instance = new SignalingState('HaveLocalPranswer', 2);
    SignalingState$HaveRemoteOffer_instance = new SignalingState('HaveRemoteOffer', 3);
    SignalingState$HaveRemotePranswer_instance = new SignalingState('HaveRemotePranswer', 4);
    SignalingState$Closed_instance = new SignalingState('Closed', 5);
  }
  var SignalingState$Stable_instance;
  function SignalingState$Stable_getInstance() {
    SignalingState_initFields();
    return SignalingState$Stable_instance;
  }
  var SignalingState$HaveLocalOffer_instance;
  function SignalingState$HaveLocalOffer_getInstance() {
    SignalingState_initFields();
    return SignalingState$HaveLocalOffer_instance;
  }
  var SignalingState$HaveLocalPranswer_instance;
  function SignalingState$HaveLocalPranswer_getInstance() {
    SignalingState_initFields();
    return SignalingState$HaveLocalPranswer_instance;
  }
  var SignalingState$HaveRemoteOffer_instance;
  function SignalingState$HaveRemoteOffer_getInstance() {
    SignalingState_initFields();
    return SignalingState$HaveRemoteOffer_instance;
  }
  var SignalingState$HaveRemotePranswer_instance;
  function SignalingState$HaveRemotePranswer_getInstance() {
    SignalingState_initFields();
    return SignalingState$HaveRemotePranswer_instance;
  }
  var SignalingState$Closed_instance;
  function SignalingState$Closed_getInstance() {
    SignalingState_initFields();
    return SignalingState$Closed_instance;
  }
  SignalingState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SignalingState',
    interfaces: [Enum]
  };
  function SignalingState$values() {
    return [SignalingState$Stable_getInstance(), SignalingState$HaveLocalOffer_getInstance(), SignalingState$HaveLocalPranswer_getInstance(), SignalingState$HaveRemoteOffer_getInstance(), SignalingState$HaveRemotePranswer_getInstance(), SignalingState$Closed_getInstance()];
  }
  SignalingState.values = SignalingState$values;
  function SignalingState$valueOf(name) {
    switch (name) {
      case 'Stable':
        return SignalingState$Stable_getInstance();
      case 'HaveLocalOffer':
        return SignalingState$HaveLocalOffer_getInstance();
      case 'HaveLocalPranswer':
        return SignalingState$HaveLocalPranswer_getInstance();
      case 'HaveRemoteOffer':
        return SignalingState$HaveRemoteOffer_getInstance();
      case 'HaveRemotePranswer':
        return SignalingState$HaveRemotePranswer_getInstance();
      case 'Closed':
        return SignalingState$Closed_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.SignalingState.' + name);
    }
  }
  SignalingState.valueOf_61zpoe$ = SignalingState$valueOf;
  function IceConnectionState(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function IceConnectionState_initFields() {
    IceConnectionState_initFields = function () {
    };
    IceConnectionState$New_instance = new IceConnectionState('New', 0);
    IceConnectionState$Checking_instance = new IceConnectionState('Checking', 1);
    IceConnectionState$Connected_instance = new IceConnectionState('Connected', 2);
    IceConnectionState$Completed_instance = new IceConnectionState('Completed', 3);
    IceConnectionState$Failed_instance = new IceConnectionState('Failed', 4);
    IceConnectionState$Disconnected_instance = new IceConnectionState('Disconnected', 5);
    IceConnectionState$Closed_instance = new IceConnectionState('Closed', 6);
    IceConnectionState$Count_instance = new IceConnectionState('Count', 7);
  }
  var IceConnectionState$New_instance;
  function IceConnectionState$New_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$New_instance;
  }
  var IceConnectionState$Checking_instance;
  function IceConnectionState$Checking_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Checking_instance;
  }
  var IceConnectionState$Connected_instance;
  function IceConnectionState$Connected_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Connected_instance;
  }
  var IceConnectionState$Completed_instance;
  function IceConnectionState$Completed_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Completed_instance;
  }
  var IceConnectionState$Failed_instance;
  function IceConnectionState$Failed_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Failed_instance;
  }
  var IceConnectionState$Disconnected_instance;
  function IceConnectionState$Disconnected_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Disconnected_instance;
  }
  var IceConnectionState$Closed_instance;
  function IceConnectionState$Closed_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Closed_instance;
  }
  var IceConnectionState$Count_instance;
  function IceConnectionState$Count_getInstance() {
    IceConnectionState_initFields();
    return IceConnectionState$Count_instance;
  }
  IceConnectionState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceConnectionState',
    interfaces: [Enum]
  };
  function IceConnectionState$values() {
    return [IceConnectionState$New_getInstance(), IceConnectionState$Checking_getInstance(), IceConnectionState$Connected_getInstance(), IceConnectionState$Completed_getInstance(), IceConnectionState$Failed_getInstance(), IceConnectionState$Disconnected_getInstance(), IceConnectionState$Closed_getInstance(), IceConnectionState$Count_getInstance()];
  }
  IceConnectionState.values = IceConnectionState$values;
  function IceConnectionState$valueOf(name) {
    switch (name) {
      case 'New':
        return IceConnectionState$New_getInstance();
      case 'Checking':
        return IceConnectionState$Checking_getInstance();
      case 'Connected':
        return IceConnectionState$Connected_getInstance();
      case 'Completed':
        return IceConnectionState$Completed_getInstance();
      case 'Failed':
        return IceConnectionState$Failed_getInstance();
      case 'Disconnected':
        return IceConnectionState$Disconnected_getInstance();
      case 'Closed':
        return IceConnectionState$Closed_getInstance();
      case 'Count':
        return IceConnectionState$Count_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.IceConnectionState.' + name);
    }
  }
  IceConnectionState.valueOf_61zpoe$ = IceConnectionState$valueOf;
  function PeerConnectionState(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PeerConnectionState_initFields() {
    PeerConnectionState_initFields = function () {
    };
    PeerConnectionState$New_instance = new PeerConnectionState('New', 0);
    PeerConnectionState$Connecting_instance = new PeerConnectionState('Connecting', 1);
    PeerConnectionState$Connected_instance = new PeerConnectionState('Connected', 2);
    PeerConnectionState$Disconnected_instance = new PeerConnectionState('Disconnected', 3);
    PeerConnectionState$Failed_instance = new PeerConnectionState('Failed', 4);
    PeerConnectionState$Closed_instance = new PeerConnectionState('Closed', 5);
  }
  var PeerConnectionState$New_instance;
  function PeerConnectionState$New_getInstance() {
    PeerConnectionState_initFields();
    return PeerConnectionState$New_instance;
  }
  var PeerConnectionState$Connecting_instance;
  function PeerConnectionState$Connecting_getInstance() {
    PeerConnectionState_initFields();
    return PeerConnectionState$Connecting_instance;
  }
  var PeerConnectionState$Connected_instance;
  function PeerConnectionState$Connected_getInstance() {
    PeerConnectionState_initFields();
    return PeerConnectionState$Connected_instance;
  }
  var PeerConnectionState$Disconnected_instance;
  function PeerConnectionState$Disconnected_getInstance() {
    PeerConnectionState_initFields();
    return PeerConnectionState$Disconnected_instance;
  }
  var PeerConnectionState$Failed_instance;
  function PeerConnectionState$Failed_getInstance() {
    PeerConnectionState_initFields();
    return PeerConnectionState$Failed_instance;
  }
  var PeerConnectionState$Closed_instance;
  function PeerConnectionState$Closed_getInstance() {
    PeerConnectionState_initFields();
    return PeerConnectionState$Closed_instance;
  }
  PeerConnectionState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PeerConnectionState',
    interfaces: [Enum]
  };
  function PeerConnectionState$values() {
    return [PeerConnectionState$New_getInstance(), PeerConnectionState$Connecting_getInstance(), PeerConnectionState$Connected_getInstance(), PeerConnectionState$Disconnected_getInstance(), PeerConnectionState$Failed_getInstance(), PeerConnectionState$Closed_getInstance()];
  }
  PeerConnectionState.values = PeerConnectionState$values;
  function PeerConnectionState$valueOf(name) {
    switch (name) {
      case 'New':
        return PeerConnectionState$New_getInstance();
      case 'Connecting':
        return PeerConnectionState$Connecting_getInstance();
      case 'Connected':
        return PeerConnectionState$Connected_getInstance();
      case 'Disconnected':
        return PeerConnectionState$Disconnected_getInstance();
      case 'Failed':
        return PeerConnectionState$Failed_getInstance();
      case 'Closed':
        return PeerConnectionState$Closed_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.PeerConnectionState.' + name);
    }
  }
  PeerConnectionState.valueOf_61zpoe$ = PeerConnectionState$valueOf;
  function IceGatheringState(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function IceGatheringState_initFields() {
    IceGatheringState_initFields = function () {
    };
    IceGatheringState$New_instance = new IceGatheringState('New', 0);
    IceGatheringState$Gathering_instance = new IceGatheringState('Gathering', 1);
    IceGatheringState$Complete_instance = new IceGatheringState('Complete', 2);
  }
  var IceGatheringState$New_instance;
  function IceGatheringState$New_getInstance() {
    IceGatheringState_initFields();
    return IceGatheringState$New_instance;
  }
  var IceGatheringState$Gathering_instance;
  function IceGatheringState$Gathering_getInstance() {
    IceGatheringState_initFields();
    return IceGatheringState$Gathering_instance;
  }
  var IceGatheringState$Complete_instance;
  function IceGatheringState$Complete_getInstance() {
    IceGatheringState_initFields();
    return IceGatheringState$Complete_instance;
  }
  IceGatheringState.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceGatheringState',
    interfaces: [Enum]
  };
  function IceGatheringState$values() {
    return [IceGatheringState$New_getInstance(), IceGatheringState$Gathering_getInstance(), IceGatheringState$Complete_getInstance()];
  }
  IceGatheringState.values = IceGatheringState$values;
  function IceGatheringState$valueOf(name) {
    switch (name) {
      case 'New':
        return IceGatheringState$New_getInstance();
      case 'Gathering':
        return IceGatheringState$Gathering_getInstance();
      case 'Complete':
        return IceGatheringState$Complete_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.IceGatheringState.' + name);
    }
  }
  IceGatheringState.valueOf_61zpoe$ = IceGatheringState$valueOf;
  function PeerConnectionEvent() {
  }
  function PeerConnectionEvent$SignalingStateChange(state) {
    this.state = state;
  }
  PeerConnectionEvent$SignalingStateChange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SignalingStateChange',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$SignalingStateChange.prototype.component1 = function () {
    return this.state;
  };
  PeerConnectionEvent$SignalingStateChange.prototype.copy_fhycoo$ = function (state) {
    return new PeerConnectionEvent$SignalingStateChange(state === void 0 ? this.state : state);
  };
  PeerConnectionEvent$SignalingStateChange.prototype.toString = function () {
    return 'SignalingStateChange(state=' + Kotlin.toString(this.state) + ')';
  };
  PeerConnectionEvent$SignalingStateChange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.state) | 0;
    return result;
  };
  PeerConnectionEvent$SignalingStateChange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.state, other.state))));
  };
  function PeerConnectionEvent$IceConnectionStateChange(state) {
    this.state = state;
  }
  PeerConnectionEvent$IceConnectionStateChange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceConnectionStateChange',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$IceConnectionStateChange.prototype.component1 = function () {
    return this.state;
  };
  PeerConnectionEvent$IceConnectionStateChange.prototype.copy_8ysxyv$ = function (state) {
    return new PeerConnectionEvent$IceConnectionStateChange(state === void 0 ? this.state : state);
  };
  PeerConnectionEvent$IceConnectionStateChange.prototype.toString = function () {
    return 'IceConnectionStateChange(state=' + Kotlin.toString(this.state) + ')';
  };
  PeerConnectionEvent$IceConnectionStateChange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.state) | 0;
    return result;
  };
  PeerConnectionEvent$IceConnectionStateChange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.state, other.state))));
  };
  function PeerConnectionEvent$StandardizedIceConnectionChange(state) {
    this.state = state;
  }
  PeerConnectionEvent$StandardizedIceConnectionChange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'StandardizedIceConnectionChange',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$StandardizedIceConnectionChange.prototype.component1 = function () {
    return this.state;
  };
  PeerConnectionEvent$StandardizedIceConnectionChange.prototype.copy_8ysxyv$ = function (state) {
    return new PeerConnectionEvent$StandardizedIceConnectionChange(state === void 0 ? this.state : state);
  };
  PeerConnectionEvent$StandardizedIceConnectionChange.prototype.toString = function () {
    return 'StandardizedIceConnectionChange(state=' + Kotlin.toString(this.state) + ')';
  };
  PeerConnectionEvent$StandardizedIceConnectionChange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.state) | 0;
    return result;
  };
  PeerConnectionEvent$StandardizedIceConnectionChange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.state, other.state))));
  };
  function PeerConnectionEvent$ConnectionStateChange(state) {
    this.state = state;
  }
  PeerConnectionEvent$ConnectionStateChange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConnectionStateChange',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$ConnectionStateChange.prototype.component1 = function () {
    return this.state;
  };
  PeerConnectionEvent$ConnectionStateChange.prototype.copy_qnqhhs$ = function (state) {
    return new PeerConnectionEvent$ConnectionStateChange(state === void 0 ? this.state : state);
  };
  PeerConnectionEvent$ConnectionStateChange.prototype.toString = function () {
    return 'ConnectionStateChange(state=' + Kotlin.toString(this.state) + ')';
  };
  PeerConnectionEvent$ConnectionStateChange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.state) | 0;
    return result;
  };
  PeerConnectionEvent$ConnectionStateChange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.state, other.state))));
  };
  function PeerConnectionEvent$IceGatheringStateChange(state) {
    this.state = state;
  }
  PeerConnectionEvent$IceGatheringStateChange.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceGatheringStateChange',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$IceGatheringStateChange.prototype.component1 = function () {
    return this.state;
  };
  PeerConnectionEvent$IceGatheringStateChange.prototype.copy_5rry5o$ = function (state) {
    return new PeerConnectionEvent$IceGatheringStateChange(state === void 0 ? this.state : state);
  };
  PeerConnectionEvent$IceGatheringStateChange.prototype.toString = function () {
    return 'IceGatheringStateChange(state=' + Kotlin.toString(this.state) + ')';
  };
  PeerConnectionEvent$IceGatheringStateChange.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.state) | 0;
    return result;
  };
  PeerConnectionEvent$IceGatheringStateChange.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.state, other.state))));
  };
  function PeerConnectionEvent$NewIceCandidate(candidate) {
    this.candidate = candidate;
  }
  PeerConnectionEvent$NewIceCandidate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NewIceCandidate',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$NewIceCandidate.prototype.component1 = function () {
    return this.candidate;
  };
  PeerConnectionEvent$NewIceCandidate.prototype.copy_igq94p$ = function (candidate) {
    return new PeerConnectionEvent$NewIceCandidate(candidate === void 0 ? this.candidate : candidate);
  };
  PeerConnectionEvent$NewIceCandidate.prototype.toString = function () {
    return 'NewIceCandidate(candidate=' + Kotlin.toString(this.candidate) + ')';
  };
  PeerConnectionEvent$NewIceCandidate.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.candidate) | 0;
    return result;
  };
  PeerConnectionEvent$NewIceCandidate.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.candidate, other.candidate))));
  };
  function PeerConnectionEvent$RemovedIceCandidates(candidates) {
    this.candidates = candidates;
  }
  PeerConnectionEvent$RemovedIceCandidates.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemovedIceCandidates',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$RemovedIceCandidates.prototype.component1 = function () {
    return this.candidates;
  };
  PeerConnectionEvent$RemovedIceCandidates.prototype.copy_4yajx4$ = function (candidates) {
    return new PeerConnectionEvent$RemovedIceCandidates(candidates === void 0 ? this.candidates : candidates);
  };
  PeerConnectionEvent$RemovedIceCandidates.prototype.toString = function () {
    return 'RemovedIceCandidates(candidates=' + Kotlin.toString(this.candidates) + ')';
  };
  PeerConnectionEvent$RemovedIceCandidates.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.candidates) | 0;
    return result;
  };
  PeerConnectionEvent$RemovedIceCandidates.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.candidates, other.candidates))));
  };
  function PeerConnectionEvent$NewDataChannel(dataChannel) {
    this.dataChannel = dataChannel;
  }
  PeerConnectionEvent$NewDataChannel.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'NewDataChannel',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$NewDataChannel.prototype.component1 = function () {
    return this.dataChannel;
  };
  PeerConnectionEvent$NewDataChannel.prototype.copy_k5mpig$ = function (dataChannel) {
    return new PeerConnectionEvent$NewDataChannel(dataChannel === void 0 ? this.dataChannel : dataChannel);
  };
  PeerConnectionEvent$NewDataChannel.prototype.toString = function () {
    return 'NewDataChannel(dataChannel=' + Kotlin.toString(this.dataChannel) + ')';
  };
  PeerConnectionEvent$NewDataChannel.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.dataChannel) | 0;
    return result;
  };
  PeerConnectionEvent$NewDataChannel.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.dataChannel, other.dataChannel))));
  };
  function PeerConnectionEvent$RemoveTrack(rtpReceiver) {
    this.rtpReceiver = rtpReceiver;
  }
  PeerConnectionEvent$RemoveTrack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemoveTrack',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$RemoveTrack.prototype.component1 = function () {
    return this.rtpReceiver;
  };
  PeerConnectionEvent$RemoveTrack.prototype.copy_tvpu04$ = function (rtpReceiver) {
    return new PeerConnectionEvent$RemoveTrack(rtpReceiver === void 0 ? this.rtpReceiver : rtpReceiver);
  };
  PeerConnectionEvent$RemoveTrack.prototype.toString = function () {
    return 'RemoveTrack(rtpReceiver=' + Kotlin.toString(this.rtpReceiver) + ')';
  };
  PeerConnectionEvent$RemoveTrack.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.rtpReceiver) | 0;
    return result;
  };
  PeerConnectionEvent$RemoveTrack.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.rtpReceiver, other.rtpReceiver))));
  };
  function PeerConnectionEvent$NegotiationNeeded() {
    PeerConnectionEvent$NegotiationNeeded_instance = this;
  }
  PeerConnectionEvent$NegotiationNeeded.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'NegotiationNeeded',
    interfaces: [PeerConnectionEvent]
  };
  var PeerConnectionEvent$NegotiationNeeded_instance = null;
  function PeerConnectionEvent$NegotiationNeeded_getInstance() {
    if (PeerConnectionEvent$NegotiationNeeded_instance === null) {
      new PeerConnectionEvent$NegotiationNeeded();
    }
    return PeerConnectionEvent$NegotiationNeeded_instance;
  }
  function PeerConnectionEvent$Track(trackEvent) {
    this.trackEvent = trackEvent;
  }
  PeerConnectionEvent$Track.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Track',
    interfaces: [PeerConnectionEvent]
  };
  PeerConnectionEvent$Track.prototype.component1 = function () {
    return this.trackEvent;
  };
  PeerConnectionEvent$Track.prototype.copy_i4mb74$ = function (trackEvent) {
    return new PeerConnectionEvent$Track(trackEvent === void 0 ? this.trackEvent : trackEvent);
  };
  PeerConnectionEvent$Track.prototype.toString = function () {
    return 'Track(trackEvent=' + Kotlin.toString(this.trackEvent) + ')';
  };
  PeerConnectionEvent$Track.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.trackEvent) | 0;
    return result;
  };
  PeerConnectionEvent$Track.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.trackEvent, other.trackEvent))));
  };
  PeerConnectionEvent.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PeerConnectionEvent',
    interfaces: []
  };
  function CommonRtpEncodingParameters() {
    this.rid = null;
    this.active = false;
    this.bitratePriority = 2.0;
    this.networkPriority = -1;
    this.maxBitrateBps = null;
    this.minBitrateBps = null;
    this.maxFramerate = null;
    this.numTemporalLayers = null;
    this.scaleResolutionDownBy = null;
    this.ssrc = null;
  }
  CommonRtpEncodingParameters.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonRtpEncodingParameters',
    interfaces: []
  };
  function CommonRtpTransceiverInit(direction, streams, sendEncodings) {
    this.direction = direction;
    this.streams = streams;
    this.sendEncodings = sendEncodings;
  }
  CommonRtpTransceiverInit.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommonRtpTransceiverInit',
    interfaces: []
  };
  function RtpTransceiverDirection(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function RtpTransceiverDirection_initFields() {
    RtpTransceiverDirection_initFields = function () {
    };
    RtpTransceiverDirection$SendRecv_instance = new RtpTransceiverDirection('SendRecv', 0);
    RtpTransceiverDirection$SendOnly_instance = new RtpTransceiverDirection('SendOnly', 1);
    RtpTransceiverDirection$RecvOnly_instance = new RtpTransceiverDirection('RecvOnly', 2);
    RtpTransceiverDirection$Inactive_instance = new RtpTransceiverDirection('Inactive', 3);
    RtpTransceiverDirection$Stopped_instance = new RtpTransceiverDirection('Stopped', 4);
  }
  var RtpTransceiverDirection$SendRecv_instance;
  function RtpTransceiverDirection$SendRecv_getInstance() {
    RtpTransceiverDirection_initFields();
    return RtpTransceiverDirection$SendRecv_instance;
  }
  var RtpTransceiverDirection$SendOnly_instance;
  function RtpTransceiverDirection$SendOnly_getInstance() {
    RtpTransceiverDirection_initFields();
    return RtpTransceiverDirection$SendOnly_instance;
  }
  var RtpTransceiverDirection$RecvOnly_instance;
  function RtpTransceiverDirection$RecvOnly_getInstance() {
    RtpTransceiverDirection_initFields();
    return RtpTransceiverDirection$RecvOnly_instance;
  }
  var RtpTransceiverDirection$Inactive_instance;
  function RtpTransceiverDirection$Inactive_getInstance() {
    RtpTransceiverDirection_initFields();
    return RtpTransceiverDirection$Inactive_instance;
  }
  var RtpTransceiverDirection$Stopped_instance;
  function RtpTransceiverDirection$Stopped_getInstance() {
    RtpTransceiverDirection_initFields();
    return RtpTransceiverDirection$Stopped_instance;
  }
  RtpTransceiverDirection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpTransceiverDirection',
    interfaces: [Enum]
  };
  function RtpTransceiverDirection$values() {
    return [RtpTransceiverDirection$SendRecv_getInstance(), RtpTransceiverDirection$SendOnly_getInstance(), RtpTransceiverDirection$RecvOnly_getInstance(), RtpTransceiverDirection$Inactive_getInstance(), RtpTransceiverDirection$Stopped_getInstance()];
  }
  RtpTransceiverDirection.values = RtpTransceiverDirection$values;
  function RtpTransceiverDirection$valueOf(name) {
    switch (name) {
      case 'SendRecv':
        return RtpTransceiverDirection$SendRecv_getInstance();
      case 'SendOnly':
        return RtpTransceiverDirection$SendOnly_getInstance();
      case 'RecvOnly':
        return RtpTransceiverDirection$RecvOnly_getInstance();
      case 'Inactive':
        return RtpTransceiverDirection$Inactive_getInstance();
      case 'Stopped':
        return RtpTransceiverDirection$Stopped_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.RtpTransceiverDirection.' + name);
    }
  }
  RtpTransceiverDirection.valueOf_61zpoe$ = RtpTransceiverDirection$valueOf;
  function SessionDescription(type, sdp) {
    this.type = type;
    this.sdp = sdp;
  }
  SessionDescription.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SessionDescription',
    interfaces: []
  };
  SessionDescription.prototype.component1 = function () {
    return this.type;
  };
  SessionDescription.prototype.component2 = function () {
    return this.sdp;
  };
  SessionDescription.prototype.copy_9r3fcj$ = function (type, sdp) {
    return new SessionDescription(type === void 0 ? this.type : type, sdp === void 0 ? this.sdp : sdp);
  };
  SessionDescription.prototype.toString = function () {
    return 'SessionDescription(type=' + Kotlin.toString(this.type) + (', sdp=' + Kotlin.toString(this.sdp)) + ')';
  };
  SessionDescription.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.type) | 0;
    result = result * 31 + Kotlin.hashCode(this.sdp) | 0;
    return result;
  };
  SessionDescription.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.type, other.type) && Kotlin.equals(this.sdp, other.sdp)))));
  };
  function SessionDescriptionType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function SessionDescriptionType_initFields() {
    SessionDescriptionType_initFields = function () {
    };
    SessionDescriptionType$Offer_instance = new SessionDescriptionType('Offer', 0);
    SessionDescriptionType$Pranswer_instance = new SessionDescriptionType('Pranswer', 1);
    SessionDescriptionType$Answer_instance = new SessionDescriptionType('Answer', 2);
    SessionDescriptionType$Rollback_instance = new SessionDescriptionType('Rollback', 3);
  }
  var SessionDescriptionType$Offer_instance;
  function SessionDescriptionType$Offer_getInstance() {
    SessionDescriptionType_initFields();
    return SessionDescriptionType$Offer_instance;
  }
  var SessionDescriptionType$Pranswer_instance;
  function SessionDescriptionType$Pranswer_getInstance() {
    SessionDescriptionType_initFields();
    return SessionDescriptionType$Pranswer_instance;
  }
  var SessionDescriptionType$Answer_instance;
  function SessionDescriptionType$Answer_getInstance() {
    SessionDescriptionType_initFields();
    return SessionDescriptionType$Answer_instance;
  }
  var SessionDescriptionType$Rollback_instance;
  function SessionDescriptionType$Rollback_getInstance() {
    SessionDescriptionType_initFields();
    return SessionDescriptionType$Rollback_instance;
  }
  SessionDescriptionType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SessionDescriptionType',
    interfaces: [Enum]
  };
  function SessionDescriptionType$values() {
    return [SessionDescriptionType$Offer_getInstance(), SessionDescriptionType$Pranswer_getInstance(), SessionDescriptionType$Answer_getInstance(), SessionDescriptionType$Rollback_getInstance()];
  }
  SessionDescriptionType.values = SessionDescriptionType$values;
  function SessionDescriptionType$valueOf(name) {
    switch (name) {
      case 'Offer':
        return SessionDescriptionType$Offer_getInstance();
      case 'Pranswer':
        return SessionDescriptionType$Pranswer_getInstance();
      case 'Answer':
        return SessionDescriptionType$Answer_getInstance();
      case 'Rollback':
        return SessionDescriptionType$Rollback_getInstance();
      default:
        throwISE('No enum constant io.dyte.webrtc.SessionDescriptionType.' + name);
    }
  }
  SessionDescriptionType.valueOf_61zpoe$ = SessionDescriptionType$valueOf;
  function TrackEvent(receiver, streams, track, transceiver) {
    this.receiver = receiver;
    this.streams = streams;
    this.track = track;
    this.transceiver = transceiver;
  }
  TrackEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'TrackEvent',
    interfaces: []
  };
  function AudioStreamTrack(js) {
    MediaStreamTrack.call(this, js);
  }
  AudioStreamTrack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'AudioStreamTrack',
    interfaces: [MediaStreamTrack]
  };
  function DataChannel(js) {
    this.js = js;
    this._onOpen_0 = MutableSharedFlow(void 0, 64);
    this.onOpen = asSharedFlow(this._onOpen_0);
    this._onClosing_0 = MutableSharedFlow(void 0, 64);
    this.onClosing = asSharedFlow(this._onClosing_0);
    this._onClose_0 = MutableSharedFlow(void 0, 64);
    this.onClose = asSharedFlow(this._onClose_0);
    this._onError_0 = MutableSharedFlow(void 0, 64);
    this.onError = asSharedFlow(this._onError_0);
    this._onMessage_0 = MutableSharedFlow(void 0, 64);
    this.onMessage = asSharedFlow(this._onMessage_0);
    this.js.onopen = DataChannel_init$lambda(this);
    this.js.onclosing = DataChannel_init$lambda_0(this);
    this.js.onclose = DataChannel_init$lambda_1(this);
    this.js.onerror = DataChannel_init$lambda_2(this);
    this.js.onmessage = DataChannel_init$lambda_3(this);
  }
  Object.defineProperty(DataChannel.prototype, 'id', {
    configurable: true,
    get: function () {
      return this.js.id;
    }
  });
  Object.defineProperty(DataChannel.prototype, 'label', {
    configurable: true,
    get: function () {
      return this.js.label;
    }
  });
  Object.defineProperty(DataChannel.prototype, 'readyState', {
    configurable: true,
    get: function () {
      var readyState = this.js.readyState;
      switch (readyState) {
        case 'connecting':
          return DataChannelState$Connecting_getInstance();
        case 'open':
          return DataChannelState$Open_getInstance();
        case 'closing':
          return DataChannelState$Closing_getInstance();
        case 'closed':
          return DataChannelState$Closed_getInstance();
        default:
          throw IllegalArgumentException_init('Illegal ready state: ' + readyState);
      }
    }
  });
  Object.defineProperty(DataChannel.prototype, 'bufferedAmount', {
    configurable: true,
    get: function () {
      return this.js.bufferedAmount;
    }
  });
  DataChannel.prototype.send_fqrh44$ = function (data) {
    this.js.send(decodeToString(data));
    return true;
  };
  DataChannel.prototype.close = function () {
    this.js.close();
  };
  function DataChannel_init$lambda(this$DataChannel) {
    return function () {
      this$DataChannel._onOpen_0.tryEmit_11rb$(Unit);
      return Unit;
    };
  }
  function DataChannel_init$lambda_0(this$DataChannel) {
    return function () {
      this$DataChannel._onClosing_0.tryEmit_11rb$(Unit);
      return Unit;
    };
  }
  function DataChannel_init$lambda_1(this$DataChannel) {
    return function () {
      this$DataChannel._onClose_0.tryEmit_11rb$(Unit);
      return Unit;
    };
  }
  function DataChannel_init$lambda_2(this$DataChannel) {
    return function (it) {
      this$DataChannel._onError_0.tryEmit_11rb$(it.message);
      return Unit;
    };
  }
  function DataChannel_init$lambda_3(this$DataChannel) {
    return function (it) {
      this$DataChannel._onMessage_0.tryEmit_11rb$(encodeToByteArray(it.data));
      return Unit;
    };
  }
  DataChannel.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DataChannel',
    interfaces: []
  };
  function DtmfSender(js) {
    this.js = js;
    this.canInsertDtmf = true;
    this.duration = -1;
    this.interToneGap = -1;
  }
  DtmfSender.prototype.insertDtmf_3m52m6$ = function (tones, durationMs, interToneGapMs) {
    if (durationMs === void 0)
      durationMs = 300;
    if (interToneGapMs === void 0)
      interToneGapMs = 50;
    this.js.insertDTMF(tones, Kotlin.Long.fromInt(durationMs), Kotlin.Long.fromInt(interToneGapMs));
    return true;
  };
  DtmfSender.prototype.tones = function () {
    return this.js.toneBuffer;
  };
  DtmfSender.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DtmfSender',
    interfaces: []
  };
  function IceCandidate(js) {
    this.js = js;
    this.sdpMid = this.js.sdpMid;
    this.sdpMLineIndex = this.js.sdpMLineIndex;
    this.candidate = this.js.candidate;
  }
  IceCandidate.prototype.toString = function () {
    return JSON.stringify(this.js);
  };
  IceCandidate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceCandidate',
    interfaces: []
  };
  function IceCandidate_init(sdpMid, sdpMLineIndex, candidate, $this) {
    $this = $this || Object.create(IceCandidate.prototype);
    IceCandidate.call($this, new RTCIceCandidate(json([to('sdpMid', sdpMid), to('sdpMLineIndex', sdpMLineIndex), to('candidate', candidate)])));
    return $this;
  }
  function IceServer(urls, username, password, tlsCertPolicy, hostname, tlsAlpnProtocols, tlsEllipticCurves) {
    if (username === void 0)
      username = '';
    if (password === void 0)
      password = '';
    if (tlsCertPolicy === void 0)
      tlsCertPolicy = TlsCertPolicy$TlsCertPolicySecure_getInstance();
    if (hostname === void 0)
      hostname = '';
    if (tlsAlpnProtocols === void 0)
      tlsAlpnProtocols = null;
    if (tlsEllipticCurves === void 0)
      tlsEllipticCurves = null;
    this.js = null;
    this.js = json([to('urls', copyToArray(urls)), to('username', username), to('credential', password)]);
  }
  IceServer.prototype.toString = function () {
    return JSON.stringify(this.js);
  };
  IceServer.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'IceServer',
    interfaces: []
  };
  var mediaDevices;
  function MediaDevicesImpl() {
    MediaDevicesImpl_instance = this;
  }
  function Coroutine$getUserMedia_jgsmsx$$default($this, streamConstraints_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$streamConstraints = streamConstraints_0;
  }
  Coroutine$getUserMedia_jgsmsx$$default.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$getUserMedia_jgsmsx$$default.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$getUserMedia_jgsmsx$$default.prototype.constructor = Coroutine$getUserMedia_jgsmsx$$default;
  Coroutine$getUserMedia_jgsmsx$$default.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            var it = new MediaStreamConstraintsBuilder();
            this.local$streamConstraints(it);
            var constraints = it.constraints_8be2vx$;
            this.state_0 = 2;
            this.result_0 = await_0(window.navigator.mediaDevices.getUserMedia(this.$this.toJson_0(constraints)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var jsStream = this.result_0;
            return new MediaStream(jsStream);
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MediaDevicesImpl.prototype.getUserMedia_jgsmsx$$default = function (streamConstraints_0, continuation_0, suspended) {
    var instance = new Coroutine$getUserMedia_jgsmsx$$default(this, streamConstraints_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$getDisplayMedia($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$getDisplayMedia.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$getDisplayMedia.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$getDisplayMedia.prototype.constructor = Coroutine$getDisplayMedia;
  Coroutine$getDisplayMedia.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = this.$this.supportsDisplayMedia(this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            if (!this.result_0) {
              throw IllegalStateException_init('getDisplayMedia is not supported in this environment'.toString());
            }

            this.state_0 = 3;
            this.result_0 = await_0(window.navigator.mediaDevices.getDisplayMedia(), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 3:
            var jsStream = this.result_0;
            return new MediaStream(jsStream);
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MediaDevicesImpl.prototype.getDisplayMedia = function (continuation_0, suspended) {
    var instance = new Coroutine$getDisplayMedia(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  MediaDevicesImpl.prototype.supportsDisplayMedia = function (continuation) {
    return window.navigator.mediaDevices.getDisplayMedia != null;
  };
  function Coroutine$enumerateDevices($this, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
  }
  Coroutine$enumerateDevices.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$enumerateDevices.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$enumerateDevices.prototype.constructor = Coroutine$enumerateDevices;
  Coroutine$enumerateDevices.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(window.navigator.mediaDevices.enumerateDevices(), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var devices = this.result_0;
            var destination = ArrayList_init_0(devices.length);
            var tmp$;
            for (tmp$ = 0; tmp$ !== devices.length; ++tmp$) {
              var item = devices[tmp$];
              var tmp$_0 = destination.add_11rb$;
              var tmp$_1, tmp$_2;
              tmp$_1 = item.kind;
              if (equals(tmp$_1, 'audioinput'))
                tmp$_2 = MediaDeviceKind$AudioInput_getInstance();
              else {
                if (equals(tmp$_1, 'videoinput'))
                  tmp$_2 = MediaDeviceKind$VideoInput_getInstance();
                else {
                  throw IllegalStateException_init(('Unknown media device kind: ' + item.kind).toString());
                }
              }
              var kind = tmp$_2;
              tmp$_0.call(destination, new MediaDeviceInfo(item.deviceId, item.label, kind));
            }

            return destination;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  MediaDevicesImpl.prototype.enumerateDevices = function (continuation_0, suspended) {
    var instance = new Coroutine$enumerateDevices(this, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  MediaDevicesImpl.prototype.toJson_0 = function ($receiver) {
    var tmp$;
    if ($receiver.audio != null) {
      var block$result;
      block$break: do {
        if ($receiver.audio.deviceId == null && $receiver.audio.groupId == null && $receiver.audio.autoGainControl == null && $receiver.audio.channelCount == null && $receiver.audio.echoCancellation == null && $receiver.audio.latency == null && $receiver.audio.noiseSuppression == null && $receiver.audio.sampleRate == null && $receiver.audio.volume == null) {
          block$result = true;
          break block$break;
        }
        var $receiver_0 = json([]);
        var tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4, tmp$_5, tmp$_6, tmp$_7, tmp$_8;
        if ((tmp$_0 = $receiver.audio.deviceId) != null) {
          add($receiver_0, json([to('deviceId', tmp$_0)]));
        }
        if ((tmp$_1 = $receiver.audio.groupId) != null) {
          add($receiver_0, json([to('groupId', tmp$_1)]));
        }
        if ((tmp$_2 = $receiver.audio.autoGainControl) != null) {
          add($receiver_0, json([to('autoGainControl', this.toJson_1(tmp$_2))]));
        }
        if ((tmp$_3 = $receiver.audio.channelCount) != null) {
          add($receiver_0, json([to('channelCount', this.toJson_1(tmp$_3))]));
        }
        if ((tmp$_4 = $receiver.audio.echoCancellation) != null) {
          add($receiver_0, json([to('echoCancellation', this.toJson_1(tmp$_4))]));
        }
        if ((tmp$_5 = $receiver.audio.latency) != null) {
          add($receiver_0, json([to('latency', this.toJson_1(tmp$_5))]));
        }
        if ((tmp$_6 = $receiver.audio.noiseSuppression) != null) {
          add($receiver_0, json([to('noiseSuppression', this.toJson_1(tmp$_6))]));
        }
        if ((tmp$_7 = $receiver.audio.sampleRate) != null) {
          add($receiver_0, json([to('sampleRate', this.toJson_1(tmp$_7))]));
        }
        if ((tmp$_8 = $receiver.audio.volume) != null) {
          add($receiver_0, json([to('volume', this.toJson_1(tmp$_8))]));
        }
        block$result = $receiver_0;
      }
       while (false);
      tmp$ = block$result;
    } else
      tmp$ = null;
    var a = tmp$;
    var tmp$_9;
    if ($receiver.video != null) {
      var block$result_0;
      block$break: do {
        if ($receiver.video.deviceId == null && $receiver.video.groupId == null && $receiver.video.facingMode == null && $receiver.video.aspectRatio == null && $receiver.video.resizeMode == null && $receiver.video.width == null && $receiver.video.height == null && $receiver.video.frameRate == null) {
          block$result_0 = true;
          break block$break;
        }
        var $receiver_1 = json([]);
        var tmp$_10, tmp$_11, tmp$_12, tmp$_13, tmp$_14, tmp$_15, tmp$_16, tmp$_17;
        if ((tmp$_10 = $receiver.video.deviceId) != null) {
          add($receiver_1, json([to('deviceId', tmp$_10)]));
        }
        if ((tmp$_11 = $receiver.video.groupId) != null) {
          add($receiver_1, json([to('groupId', tmp$_11)]));
        }
        if ((tmp$_12 = $receiver.video.facingMode) != null) {
          add($receiver_1, json([to('facingMode', this.toJson_1(tmp$_12))]));
        }
        if ((tmp$_13 = $receiver.video.aspectRatio) != null) {
          add($receiver_1, json([to('aspectRatio', this.toJson_1(tmp$_13))]));
        }
        if ((tmp$_14 = $receiver.video.resizeMode) != null) {
          add($receiver_1, json([to('resizeMode', this.toJson_1(tmp$_14))]));
        }
        if ((tmp$_15 = $receiver.video.width) != null) {
          add($receiver_1, json([to('width', this.toJson_1(tmp$_15))]));
        }
        if ((tmp$_16 = $receiver.video.height) != null) {
          add($receiver_1, json([to('height', this.toJson_1(tmp$_16))]));
        }
        if ((tmp$_17 = $receiver.video.frameRate) != null) {
          add($receiver_1, json([to('frameRate', this.toJson_1(tmp$_17))]));
        }
        block$result_0 = $receiver_1;
      }
       while (false);
      tmp$_9 = block$result_0;
    } else
      tmp$_9 = null;
    var v = tmp$_9;
    var o = {};
    o['video'] = v;
    o['audio'] = a;
    return o;
  };
  MediaDevicesImpl.prototype.toJson_1 = function ($receiver) {
    var $receiver_0 = ArrayList_init();
    var tmp$, tmp$_0;
    if ((tmp$ = $receiver.exact) != null) {
      $receiver_0.add_11rb$(new Pair('exact', tmp$));
    }
    if ((tmp$_0 = $receiver.ideal) != null) {
      $receiver_0.add_11rb$(new Pair('ideal', tmp$_0));
    }
    var values = copyToArray($receiver_0);
    return json(values.slice());
  };
  MediaDevicesImpl.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'MediaDevicesImpl',
    interfaces: [MediaDevices]
  };
  var MediaDevicesImpl_instance = null;
  function MediaDevicesImpl_getInstance() {
    if (MediaDevicesImpl_instance === null) {
      new MediaDevicesImpl();
    }
    return MediaDevicesImpl_instance;
  }
  function MediaStream(js) {
    this.js = js;
  }
  Object.defineProperty(MediaStream.prototype, 'id', {
    configurable: true,
    get: function () {
      return this.js.id;
    }
  });
  Object.defineProperty(MediaStream.prototype, 'tracks', {
    configurable: true,
    get: function () {
      var $receiver = this.js.getTracks();
      var destination = ArrayList_init_0($receiver.length);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var item = $receiver[tmp$];
        destination.add_11rb$(asCommon(item));
      }
      return destination;
    }
  });
  MediaStream.prototype.addTrack_9zt94$ = function (track) {
    this.js.addTrack(track.js);
  };
  MediaStream.prototype.getTrackById_61zpoe$ = function (id) {
    var tmp$;
    return (tmp$ = this.js.getTrackById(id)) != null ? asCommon(tmp$) : null;
  };
  MediaStream.prototype.removeTrack_9zt94$ = function (track) {
    this.js.removeTrack(track.js);
  };
  MediaStream.prototype.release = function () {
    var tmp$;
    tmp$ = this.tracks.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      element.stop();
    }
  };
  MediaStream.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaStream',
    interfaces: []
  };
  function MediaStreamTrack(js) {
    this.js = js;
    this._state_vc7sny$_0 = MutableStateFlow(this.getInitialState_7p6kj$_0());
    this.state = asStateFlow(this._state_vc7sny$_0);
    this.js.onended = MediaStreamTrack_init$lambda(this);
    this.js.onmute = MediaStreamTrack_init$lambda_0(this);
    this.js.onunmute = MediaStreamTrack_init$lambda_1(this);
  }
  Object.defineProperty(MediaStreamTrack.prototype, 'id', {
    configurable: true,
    get: function () {
      return this.js.id;
    }
  });
  Object.defineProperty(MediaStreamTrack.prototype, 'kind', {
    configurable: true,
    get: function () {
      return this.toMediaStreamTrackKind_sasf4h$_0(this.js.kind);
    }
  });
  Object.defineProperty(MediaStreamTrack.prototype, 'label', {
    configurable: true,
    get: function () {
      return this.js.label;
    }
  });
  Object.defineProperty(MediaStreamTrack.prototype, 'enabled', {
    configurable: true,
    get: function () {
      return this.js.enabled;
    },
    set: function (value) {
      this.js.enabled = value;
    }
  });
  MediaStreamTrack.prototype.stop = function () {
    this.js.stop();
  };
  MediaStreamTrack.prototype.toMediaStreamTrackKind_sasf4h$_0 = function ($receiver) {
    var tmp$;
    switch ($receiver) {
      case 'audio':
        tmp$ = MediaStreamTrackKind$Audio_getInstance();
        break;
      case 'video':
        tmp$ = MediaStreamTrackKind$Video_getInstance();
        break;
      default:
        throw IllegalStateException_init(('Unknown media stream track kind: ' + $receiver).toString());
    }
    return tmp$;
  };
  MediaStreamTrack.prototype.getInitialState_7p6kj$_0 = function () {
    var tmp$, tmp$_0;
    tmp$ = this.js.readyState;
    if (equals(tmp$, 'live'))
      tmp$_0 = new MediaStreamTrackState$Live(this.js.muted);
    else {
      if (equals(tmp$, 'ended'))
        tmp$_0 = new MediaStreamTrackState$Ended(this.js.muted);
      else {
        throw IllegalStateException_init(('Unknown media stream track state: ' + this.js.readyState).toString());
      }
    }
    return tmp$_0;
  };
  function MediaStreamTrack_init$lambda(this$MediaStreamTrack) {
    return function (it) {
      var $receiver = this$MediaStreamTrack._state_vc7sny$_0;
      update$break: do {
        while (true) {
          var prevValue = $receiver.value;
          var nextValue = new MediaStreamTrackState$Ended(this$MediaStreamTrack.js.muted);
          if ($receiver.compareAndSet_xwzc9q$(prevValue, nextValue)) {
            break update$break;
          }
        }
      }
       while (false);
      return Unit;
    };
  }
  function MediaStreamTrack_init$lambda_0(this$MediaStreamTrack) {
    return function (it) {
      var $receiver = this$MediaStreamTrack._state_vc7sny$_0;
      update$break: do {
        while (true) {
          var prevValue = $receiver.value;
          var nextValue = prevValue.mute();
          if ($receiver.compareAndSet_xwzc9q$(prevValue, nextValue)) {
            break update$break;
          }
        }
      }
       while (false);
      return Unit;
    };
  }
  function MediaStreamTrack_init$lambda_1(this$MediaStreamTrack) {
    return function (it) {
      var $receiver = this$MediaStreamTrack._state_vc7sny$_0;
      update$break: do {
        while (true) {
          var prevValue = $receiver.value;
          var nextValue = prevValue.unmute();
          if ($receiver.compareAndSet_xwzc9q$(prevValue, nextValue)) {
            break update$break;
          }
        }
      }
       while (false);
      return Unit;
    };
  }
  MediaStreamTrack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'MediaStreamTrack',
    interfaces: []
  };
  function asCommon($receiver) {
    switch ($receiver.kind) {
      case 'audio':
        return new AudioStreamTrack($receiver);
      case 'video':
        return new VideoStreamTrack($receiver);
      default:
        throw IllegalStateException_init(('Unknown kind of media stream track: ' + $receiver.kind).toString());
    }
  }
  function PeerConnection(rtcConfiguration) {
    if (rtcConfiguration === void 0)
      rtcConfiguration = new RtcConfiguration();
    this.js = null;
    this._peerConnectionEvent_0 = MutableSharedFlow(void 0, 64);
    this.peerConnectionEvent_8be2vx$ = asSharedFlow(this._peerConnectionEvent_0);
    WebRtcAdapter;
    var $receiver = new RTCPeerConnection(rtcConfiguration.js);
    $receiver.onsignalingstatechange = PeerConnection_init$lambda$lambda(this);
    $receiver.oniceconnectionstatechange = PeerConnection_init$lambda$lambda_0(this);
    $receiver.onconnectionstatechange = PeerConnection_init$lambda$lambda_1(this);
    $receiver.onicegatheringstatechange = PeerConnection_init$lambda$lambda_2(this);
    $receiver.onicecandidate = PeerConnection_init$lambda$lambda_3(this);
    $receiver.ondatachannel = PeerConnection_init$lambda$lambda_4(this);
    $receiver.onnegotiationneeded = PeerConnection_init$lambda$lambda_5(this);
    $receiver.ontrack = PeerConnection_init$lambda$lambda_6(this);
    this.js = $receiver;
  }
  Object.defineProperty(PeerConnection.prototype, 'localDescription', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.localDescription) != null ? asCommon_0(tmp$) : null;
    }
  });
  Object.defineProperty(PeerConnection.prototype, 'remoteDescription', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.remoteDescription) != null ? asCommon_0(tmp$) : null;
    }
  });
  Object.defineProperty(PeerConnection.prototype, 'signalingState', {
    configurable: true,
    get: function () {
      return this.toSignalingState_0(this.js.signalingState);
    }
  });
  Object.defineProperty(PeerConnection.prototype, 'iceConnectionState', {
    configurable: true,
    get: function () {
      return this.toIceConnectionState_0(this.js.iceConnectionState);
    }
  });
  Object.defineProperty(PeerConnection.prototype, 'connectionState', {
    configurable: true,
    get: function () {
      return this.toPeerConnectionState_0(this.js.connectionState);
    }
  });
  Object.defineProperty(PeerConnection.prototype, 'iceGatheringState', {
    configurable: true,
    get: function () {
      return this.toIceGatheringState_0(this.js.iceGatheringState);
    }
  });
  PeerConnection.prototype.createDataChannel_xxarry$ = function (label, id, ordered, maxRetransmitTimeMs, maxRetransmits, protocol, negotiated) {
    if (id === void 0)
      id = -1;
    if (ordered === void 0)
      ordered = true;
    if (maxRetransmitTimeMs === void 0)
      maxRetransmitTimeMs = -1;
    if (maxRetransmits === void 0)
      maxRetransmits = -1;
    if (protocol === void 0)
      protocol = '';
    if (negotiated === void 0)
      negotiated = false;
    var tmp$;
    var $receiver = json([]);
    if (id > -1)
      add($receiver, json([to('id', id)]));
    if (maxRetransmitTimeMs > -1)
      add($receiver, json([to('maxRetransmitTimeMs', maxRetransmitTimeMs)]));
    if (maxRetransmits > -1)
      add($receiver, json([to('maxRetransmits', maxRetransmits)]));
    if (protocol.length > 0)
      add($receiver, json([to('protocol', protocol)]));
    add($receiver, json([to('ordered', ordered), to('negotiated', negotiated)]));
    var options = $receiver;
    return (tmp$ = this.js.createDataChannel(label, options)) != null ? new DataChannel(tmp$) : null;
  };
  function Coroutine$createOffer_v3741n$($this, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$options = options_0;
  }
  Coroutine$createOffer_v3741n$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$createOffer_v3741n$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$createOffer_v3741n$.prototype.constructor = Coroutine$createOffer_v3741n$;
  Coroutine$createOffer_v3741n$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(this.$this.js.createOffer(this.$this.toJson_0(this.local$options)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var sessionDescription = this.result_0;
            return asCommon_0(sessionDescription);
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PeerConnection.prototype.createOffer_v3741n$ = function (options_0, continuation_0, suspended) {
    var instance = new Coroutine$createOffer_v3741n$(this, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$createAnswer_v3741n$($this, options_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$options = options_0;
  }
  Coroutine$createAnswer_v3741n$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$createAnswer_v3741n$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$createAnswer_v3741n$.prototype.constructor = Coroutine$createAnswer_v3741n$;
  Coroutine$createAnswer_v3741n$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(this.$this.js.createAnswer(this.$this.toJson_0(this.local$options)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            var sessionDescription = this.result_0;
            return asCommon_0(sessionDescription);
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PeerConnection.prototype.createAnswer_v3741n$ = function (options_0, continuation_0, suspended) {
    var instance = new Coroutine$createAnswer_v3741n$(this, options_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$setLocalDescription_l7n8zr$($this, description_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$description = description_0;
  }
  Coroutine$setLocalDescription_l7n8zr$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$setLocalDescription_l7n8zr$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$setLocalDescription_l7n8zr$.prototype.constructor = Coroutine$setLocalDescription_l7n8zr$;
  Coroutine$setLocalDescription_l7n8zr$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(this.$this.js.setLocalDescription(asJs(this.local$description)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PeerConnection.prototype.setLocalDescription_l7n8zr$ = function (description_0, continuation_0, suspended) {
    var instance = new Coroutine$setLocalDescription_l7n8zr$(this, description_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  function Coroutine$setRemoteDescription_l7n8zr$($this, description_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$description = description_0;
  }
  Coroutine$setRemoteDescription_l7n8zr$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$setRemoteDescription_l7n8zr$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$setRemoteDescription_l7n8zr$.prototype.constructor = Coroutine$setRemoteDescription_l7n8zr$;
  Coroutine$setRemoteDescription_l7n8zr$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(this.$this.js.setRemoteDescription(asJs(this.local$description)), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  PeerConnection.prototype.setRemoteDescription_l7n8zr$ = function (description_0, continuation_0, suspended) {
    var instance = new Coroutine$setRemoteDescription_l7n8zr$(this, description_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  PeerConnection.prototype.setConfiguration_65qup6$ = function (configuration) {
    this.js.setConfiguration(configuration.js);
    return true;
  };
  PeerConnection.prototype.addIceCandidate_igq94p$ = function (candidate) {
    this.js.addIceCandidate(candidate.js);
    return true;
  };
  PeerConnection.prototype.removeIceCandidates_4yajx4$ = function (candidates) {
    return true;
  };
  PeerConnection.prototype.getSenders = function () {
    var $receiver = this.js.getSenders();
    var destination = ArrayList_init_0($receiver.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      destination.add_11rb$(new RtpSender(item));
    }
    return destination;
  };
  PeerConnection.prototype.getReceivers = function () {
    var $receiver = this.js.getReceivers();
    var destination = ArrayList_init_0($receiver.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      destination.add_11rb$(new RtpReceiver(item));
    }
    return destination;
  };
  PeerConnection.prototype.getTransceivers = function () {
    var $receiver = this.js.getTransceivers();
    var destination = ArrayList_init_0($receiver.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      destination.add_11rb$(new RtpTransceiver(item));
    }
    return destination;
  };
  PeerConnection.prototype.addTrack_owdfgm$ = function (track, streams) {
    var tmp$;
    var destination = ArrayList_init_0(streams.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== streams.length; ++tmp$_0) {
      var item = streams[tmp$_0];
      destination.add_11rb$(item.js);
    }
    var jsStreams = copyToArray(destination);
    return new RtpSender((tmp$ = this.js).addTrack.apply(tmp$, [track.js].concat(jsStreams)));
  };
  PeerConnection.prototype.removeTrack_udgwwu$ = function (sender) {
    this.js.removeTrack(sender.js);
    return true;
  };
  PeerConnection.prototype.getStats = function (continuation) {
    return null;
  };
  PeerConnection.prototype.close = function () {
    this.js.close();
  };
  PeerConnection.prototype.addTransceiver_frk0vy$ = function (track, kind, init) {
  };
  PeerConnection.prototype.toJson_0 = function ($receiver) {
    var $receiver_0 = json([]);
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    if ((tmp$ = $receiver.iceRestart) != null) {
      add($receiver_0, json([to('iceRestart', tmp$)]));
    }
    if ((tmp$_0 = $receiver.offerToReceiveAudio) != null) {
      add($receiver_0, json([to('offerToReceiveAudio', tmp$_0)]));
    }
    if ((tmp$_1 = $receiver.offerToReceiveVideo) != null) {
      add($receiver_0, json([to('offerToReceiveVideo', tmp$_1)]));
    }
    if ((tmp$_2 = $receiver.voiceActivityDetection) != null) {
      add($receiver_0, json([to('voiceActivityDetection', tmp$_2)]));
    }
    return $receiver_0;
  };
  PeerConnection.prototype.toSignalingState_0 = function ($receiver) {
    switch ($receiver) {
      case 'stable':
        return SignalingState$Stable_getInstance();
      case 'have-local-offer':
        return SignalingState$HaveLocalOffer_getInstance();
      case 'have-remote-offer':
        return SignalingState$HaveRemoteOffer_getInstance();
      case 'have-local-pranswer':
        return SignalingState$HaveLocalPranswer_getInstance();
      case 'have-remote-pranswer':
        return SignalingState$HaveRemotePranswer_getInstance();
      case 'closed':
        return SignalingState$Closed_getInstance();
      default:
        throw IllegalArgumentException_init('Illegal signaling state: ' + $receiver);
    }
  };
  PeerConnection.prototype.toIceConnectionState_0 = function ($receiver) {
    switch ($receiver) {
      case 'new':
        return IceConnectionState$New_getInstance();
      case 'checking':
        return IceConnectionState$Checking_getInstance();
      case 'connected':
        return IceConnectionState$Connected_getInstance();
      case 'completed':
        return IceConnectionState$Completed_getInstance();
      case 'failed':
        return IceConnectionState$Failed_getInstance();
      case 'disconnected':
        return IceConnectionState$Disconnected_getInstance();
      case 'closed':
        return IceConnectionState$Closed_getInstance();
      default:
        throw IllegalArgumentException_init('Illegal ICE connection state: ' + $receiver);
    }
  };
  PeerConnection.prototype.toPeerConnectionState_0 = function ($receiver) {
    switch ($receiver) {
      case 'new':
        return PeerConnectionState$New_getInstance();
      case 'connecting':
        return PeerConnectionState$Connecting_getInstance();
      case 'connected':
        return PeerConnectionState$Connected_getInstance();
      case 'disconnected':
        return PeerConnectionState$Disconnected_getInstance();
      case 'failed':
        return PeerConnectionState$Failed_getInstance();
      case 'closed':
        return PeerConnectionState$Closed_getInstance();
      default:
        throw IllegalArgumentException_init('Illegal connection state: ' + $receiver);
    }
  };
  PeerConnection.prototype.toIceGatheringState_0 = function ($receiver) {
    switch ($receiver) {
      case 'new':
        return IceGatheringState$New_getInstance();
      case 'gathering':
        return IceGatheringState$Gathering_getInstance();
      case 'complete':
        return IceGatheringState$Complete_getInstance();
      default:
        throw IllegalArgumentException_init('Illegal ICE gathering state: ' + $receiver);
    }
  };
  function PeerConnection_init$lambda$lambda(this$PeerConnection) {
    return function () {
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$SignalingStateChange(this$PeerConnection.signalingState));
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_0(this$PeerConnection) {
    return function () {
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$IceConnectionStateChange(this$PeerConnection.iceConnectionState));
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_1(this$PeerConnection) {
    return function () {
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$ConnectionStateChange(this$PeerConnection.connectionState));
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_2(this$PeerConnection) {
    return function () {
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$IceGatheringStateChange(this$PeerConnection.iceGatheringState));
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_3(this$PeerConnection) {
    return function (iceEvent) {
      var tmp$;
      if ((tmp$ = iceEvent.candidate) != null) {
        this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$NewIceCandidate(new IceCandidate(tmp$)));
      }
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_4(this$PeerConnection) {
    return function (dataChannelEvent) {
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$NewDataChannel(new DataChannel(dataChannelEvent.channel)));
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_5(this$PeerConnection) {
    return function () {
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(PeerConnectionEvent$NegotiationNeeded_getInstance());
      return Unit;
    };
  }
  function PeerConnection_init$lambda$lambda_6(this$PeerConnection) {
    return function (rtcTrackEvent) {
      var tmp$ = new RtpReceiver(rtcTrackEvent.receiver);
      var $receiver = rtcTrackEvent.streams;
      var destination = ArrayList_init_0($receiver.length);
      var tmp$_0;
      for (tmp$_0 = 0; tmp$_0 !== $receiver.length; ++tmp$_0) {
        var item = $receiver[tmp$_0];
        destination.add_11rb$(new MediaStream(item));
      }
      var trackEvent = new TrackEvent(tmp$, destination, asCommon(rtcTrackEvent.track), new RtpTransceiver(rtcTrackEvent.transceiver));
      this$PeerConnection._peerConnectionEvent_0.tryEmit_11rb$(new PeerConnectionEvent$Track(trackEvent));
      return Unit;
    };
  }
  PeerConnection.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PeerConnection',
    interfaces: []
  };
  function RtcCertificatePem(js) {
    RtcCertificatePem$Companion_getInstance();
    this.js = js;
  }
  Object.defineProperty(RtcCertificatePem.prototype, 'privateKey', {
    configurable: true,
    get: function () {
      return '';
    }
  });
  Object.defineProperty(RtcCertificatePem.prototype, 'certificate', {
    configurable: true,
    get: function () {
      return '';
    }
  });
  function RtcCertificatePem$Companion() {
    RtcCertificatePem$Companion_instance = this;
  }
  function Coroutine$generateCertificate_af2ywb$($this, keyType_0, expires_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$keyType = keyType_0;
    this.local$expires = expires_0;
  }
  Coroutine$generateCertificate_af2ywb$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$generateCertificate_af2ywb$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$generateCertificate_af2ywb$.prototype.constructor = Coroutine$generateCertificate_af2ywb$;
  Coroutine$generateCertificate_af2ywb$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            if (this.local$keyType === void 0)
              this.local$keyType = KeyType$ECDSA_getInstance();
            if (this.local$expires === void 0)
              this.local$expires = L2592000;
            var tmp$;
            switch (this.local$keyType.name) {
              case 'RSA':
                tmp$ = json([to('name', 'RSASSA-PKCS10-v1_5'), to('modulusLength', 2048), to('publicExponent', new Uint8Array([1, 0, 1])), to('hash', 'SHA-256')]);
                break;
              case 'ECDSA':
                tmp$ = json([to('name', 'ECDSA'), to('namedCurve', 'P-256')]);
                break;
              default:
                tmp$ = Kotlin.noWhenBranchMatched();
                break;
            }

            var options = tmp$;
            this.state_0 = 2;
            this.result_0 = await_0(RTCPeerConnection.generateCertificate(options), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return new RtcCertificatePem(this.result_0);
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  RtcCertificatePem$Companion.prototype.generateCertificate_af2ywb$ = function (keyType_0, expires_0, continuation_0, suspended) {
    var instance = new Coroutine$generateCertificate_af2ywb$(this, keyType_0, expires_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  RtcCertificatePem$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var RtcCertificatePem$Companion_instance = null;
  function RtcCertificatePem$Companion_getInstance() {
    if (RtcCertificatePem$Companion_instance === null) {
      new RtcCertificatePem$Companion();
    }
    return RtcCertificatePem$Companion_instance;
  }
  RtcCertificatePem.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtcCertificatePem',
    interfaces: []
  };
  function RtcConfiguration(bundlePolicy, certificates, iceCandidatePoolSize, iceServers, iceTransportPolicy, rtcpMuxPolicy) {
    if (bundlePolicy === void 0)
      bundlePolicy = BundlePolicy$Balanced_getInstance();
    if (certificates === void 0)
      certificates = null;
    if (iceCandidatePoolSize === void 0)
      iceCandidatePoolSize = 0;
    if (iceServers === void 0)
      iceServers = emptyList();
    if (iceTransportPolicy === void 0)
      iceTransportPolicy = IceTransportPolicy$All_getInstance();
    if (rtcpMuxPolicy === void 0)
      rtcpMuxPolicy = RtcpMuxPolicy$Require_getInstance();
    this.js = null;
    var tmp$ = to('bundlePolicy', this.toJs_0(bundlePolicy));
    var tmp$_0 = to('iceCandidatePoolSize', iceCandidatePoolSize);
    var $receiver = iceServers;
    var destination = ArrayList_init_0(collectionSizeOrDefault($receiver, 10));
    var tmp$_1;
    tmp$_1 = $receiver.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      destination.add_11rb$(item.js);
    }
    this.js = json([tmp$, tmp$_0, to('iceServers', copyToArray(destination)), to('iceTransportPolicy', this.toJs_1(iceTransportPolicy)), to('rtcpMuxPolicy', this.toJs_2(rtcpMuxPolicy))]);
    if (certificates != null) {
      var tmp$_2 = this.js;
      var $receiver_0 = certificates;
      var destination_0 = ArrayList_init_0(collectionSizeOrDefault($receiver_0, 10));
      var tmp$_3;
      tmp$_3 = $receiver_0.iterator();
      while (tmp$_3.hasNext()) {
        var item_0 = tmp$_3.next();
        destination_0.add_11rb$(item_0.js);
      }
      add(tmp$_2, json([to('certificates', destination_0)]));
    }
  }
  RtcConfiguration.prototype.toJs_0 = function ($receiver) {
    switch ($receiver.name) {
      case 'Balanced':
        return 'balanced';
      case 'MaxBundle':
        return 'max-bundle';
      case 'MaxCompat':
        return 'max-compat';
      default:
        return Kotlin.noWhenBranchMatched();
    }
  };
  RtcConfiguration.prototype.toJs_1 = function ($receiver) {
    switch ($receiver.name) {
      case 'All':
        return 'all';
      case 'Relay':
        return 'relay';
      default:
        return 'all';
    }
  };
  RtcConfiguration.prototype.toJs_2 = function ($receiver) {
    switch ($receiver.name) {
      case 'Negotiate':
        return 'negotiate';
      case 'Require':
        return 'require';
      default:
        return Kotlin.noWhenBranchMatched();
    }
  };
  RtcConfiguration.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtcConfiguration',
    interfaces: []
  };
  function RtcStats() {
    this.timestampUs = L_1;
    this.type = 'not_implemented';
    this.id = 'not_implemented';
    this.members = emptyMap();
  }
  RtcStats.prototype.toString = function () {
    return 'not_implemented';
  };
  RtcStats.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtcStats',
    interfaces: []
  };
  function RtcStatsReport() {
    this.timestampUs = L_1;
    this.stats = emptyMap();
  }
  RtcStatsReport.prototype.toString = function () {
    return 'not_implemented';
  };
  RtcStatsReport.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtcStatsReport',
    interfaces: []
  };
  function RtpParameters(js) {
    this.js = js;
    this.codecs_pvaz52$_0 = ArrayList_init();
    this.encodings_51a83z$_0 = emptyList();
    this.headerExtension_t6rttr$_0 = ArrayList_init();
    this.transactionId_2lxnug$_0 = '';
  }
  Object.defineProperty(RtpParameters.prototype, 'codecs', {
    configurable: true,
    get: function () {
      var $receiver = this.js.codes;
      var destination = ArrayList_init_0($receiver.length);
      var tmp$;
      for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
        var item = $receiver[tmp$];
        destination.add_11rb$(new RtpCodecParameters(item));
      }
      return toMutableList(destination);
    },
    set: function (codecs) {
      this.codecs_pvaz52$_0 = codecs;
    }
  });
  Object.defineProperty(RtpParameters.prototype, 'encodings', {
    configurable: true,
    get: function () {
      return emptyList();
    },
    set: function (encodings) {
      this.encodings_51a83z$_0 = encodings;
    }
  });
  Object.defineProperty(RtpParameters.prototype, 'headerExtension', {
    configurable: true,
    get: function () {
      return ArrayList_init();
    },
    set: function (headerExtension) {
      this.headerExtension_t6rttr$_0 = headerExtension;
    }
  });
  Object.defineProperty(RtpParameters.prototype, 'rtcp', {
    configurable: true,
    get: function () {
      return new RtcpParameters(this.js.rtcp);
    }
  });
  Object.defineProperty(RtpParameters.prototype, 'transactionId', {
    configurable: true,
    get: function () {
      return '';
    },
    set: function (transactionId) {
      this.transactionId_2lxnug$_0 = transactionId;
    }
  });
  RtpParameters.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpParameters',
    interfaces: []
  };
  function RtpCodecParameters(js) {
    this.js = js;
    this.payloadType_5xrb1v$_0 = 0;
    this.numChannels_xuty0x$_0 = null;
  }
  Object.defineProperty(RtpCodecParameters.prototype, 'payloadType', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.payloadType) != null ? tmp$ : 0;
    },
    set: function (payloadType) {
      this.payloadType_5xrb1v$_0 = payloadType;
    }
  });
  Object.defineProperty(RtpCodecParameters.prototype, 'mimeType', {
    configurable: true,
    get: function () {
      return this.js.mimeType;
    }
  });
  Object.defineProperty(RtpCodecParameters.prototype, 'clockRate', {
    configurable: true,
    get: function () {
      return this.js.clockRate;
    }
  });
  Object.defineProperty(RtpCodecParameters.prototype, 'numChannels', {
    configurable: true,
    get: function () {
      return this.js.channels;
    },
    set: function (numChannels) {
      this.numChannels_xuty0x$_0 = numChannels;
    }
  });
  Object.defineProperty(RtpCodecParameters.prototype, 'parameters', {
    configurable: true,
    get: function () {
      return toMutableMap(mapOf(to('sdpFmtpLine', toString(this.js.sdpFmtpLine))));
    }
  });
  RtpCodecParameters.prototype.setRtpCodecParameters_gvt5zh$ = function (payloadType, mimeType, clockRate, numChannels, parameters) {
    if (payloadType === void 0)
      payloadType = this.payloadType;
    if (mimeType === void 0)
      mimeType = this.mimeType;
    if (clockRate === void 0)
      clockRate = this.clockRate;
    if (numChannels === void 0)
      numChannels = this.numChannels;
    if (parameters === void 0)
      parameters = this.parameters;
  };
  RtpCodecParameters.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpCodecParameters',
    interfaces: []
  };
  function RtcpParameters(js) {
    this.js = js;
    this.cname_hjdjcw$_0 = '';
    this.reducedSize_mromc1$_0 = null;
  }
  Object.defineProperty(RtcpParameters.prototype, 'cname', {
    configurable: true,
    get: function () {
      return this.js.cname;
    },
    set: function (cname) {
      this.cname_hjdjcw$_0 = cname;
    }
  });
  Object.defineProperty(RtcpParameters.prototype, 'reducedSize', {
    configurable: true,
    get: function () {
      return this.js.reducedSize;
    },
    set: function (reducedSize) {
      this.reducedSize_mromc1$_0 = reducedSize;
    }
  });
  RtcpParameters.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtcpParameters',
    interfaces: []
  };
  function RtpEncodingParameters() {
    this.rid = null;
    this.active = false;
    this.bitratePriority = 0.0;
    this.networkPriority = -1;
    this.maxBitrateBps = null;
    this.minBitrateBps = null;
    this.maxFramerate = null;
    this.numTemporalLayers = null;
    this.scaleResolutionDownBy = null;
    this.ssrc = null;
  }
  RtpEncodingParameters.prototype.setRtpEncodingParameters_yzufdd$ = function (rid, active, bitratePriority, networkPriority, maxBitrateBps, minBitrateBps, maxFramerate, numTemporalLayers, scaleResolutionDownBy, ssrc) {
    if (rid === void 0)
      rid = this.rid;
    if (active === void 0)
      active = this.active;
    if (bitratePriority === void 0)
      bitratePriority = this.bitratePriority;
    if (networkPriority === void 0)
      networkPriority = this.networkPriority;
    if (maxBitrateBps === void 0)
      maxBitrateBps = this.maxBitrateBps;
    if (minBitrateBps === void 0)
      minBitrateBps = this.minBitrateBps;
    if (maxFramerate === void 0)
      maxFramerate = this.maxFramerate;
    if (numTemporalLayers === void 0)
      numTemporalLayers = this.numTemporalLayers;
    if (scaleResolutionDownBy === void 0)
      scaleResolutionDownBy = this.scaleResolutionDownBy;
    if (ssrc === void 0)
      ssrc = this.ssrc;
  };
  RtpEncodingParameters.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpEncodingParameters',
    interfaces: []
  };
  function HeaderExtension() {
    this.uri = '';
    this.id = -1;
    this.encrypted = false;
  }
  HeaderExtension.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'HeaderExtension',
    interfaces: []
  };
  function RtpReceiver(js) {
    this.js = js;
  }
  Object.defineProperty(RtpReceiver.prototype, 'id', {
    configurable: true,
    get: function () {
      return this.js.track.id;
    }
  });
  Object.defineProperty(RtpReceiver.prototype, 'track', {
    configurable: true,
    get: function () {
      return asCommon(this.js.track);
    }
  });
  Object.defineProperty(RtpReceiver.prototype, 'parameters', {
    configurable: true,
    get: function () {
      return new RtpParameters(this.js.getParameters());
    }
  });
  RtpReceiver.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpReceiver',
    interfaces: []
  };
  function RtpSender(js) {
    this.js = js;
  }
  Object.defineProperty(RtpSender.prototype, 'id', {
    configurable: true,
    get: function () {
      var tmp$, tmp$_0;
      return (tmp$_0 = (tmp$ = this.track) != null ? tmp$.id : null) != null ? tmp$_0 : '';
    }
  });
  Object.defineProperty(RtpSender.prototype, 'track', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.track) != null ? asCommon(tmp$) : null;
    }
  });
  Object.defineProperty(RtpSender.prototype, 'parameters', {
    configurable: true,
    get: function () {
      return new RtpParameters(this.js.getParameters());
    },
    set: function (value) {
      this.js.setParameters(value.js);
    }
  });
  Object.defineProperty(RtpSender.prototype, 'dtmf', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.dtmf) != null ? new DtmfSender(tmp$) : null;
    }
  });
  function Coroutine$replaceTrack_8lu6sp$($this, track_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.$this = $this;
    this.local$track = track_0;
  }
  Coroutine$replaceTrack_8lu6sp$.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$replaceTrack_8lu6sp$.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$replaceTrack_8lu6sp$.prototype.constructor = Coroutine$replaceTrack_8lu6sp$;
  Coroutine$replaceTrack_8lu6sp$.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0(this.$this.js.replaceTrack(this.local$track != null ? this.local$track.js : null), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return;
          default:
            this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  RtpSender.prototype.replaceTrack_8lu6sp$ = function (track_0, continuation_0, suspended) {
    var instance = new Coroutine$replaceTrack_8lu6sp$(this, track_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  };
  RtpSender.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpSender',
    interfaces: []
  };
  function RtpTransceiver(js) {
    this.js = js;
  }
  Object.defineProperty(RtpTransceiver.prototype, 'direction', {
    configurable: true,
    get: function () {
      return this.toRtpTransceiverDirection_0(this.js.direction);
    },
    set: function (value) {
      this.js.direction = this.toJs_0(value);
    }
  });
  Object.defineProperty(RtpTransceiver.prototype, 'currentDirection', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.currentDirection) != null ? this.toRtpTransceiverDirection_0(tmp$) : null;
    }
  });
  Object.defineProperty(RtpTransceiver.prototype, 'mid', {
    configurable: true,
    get: function () {
      var tmp$;
      return (tmp$ = this.js.mid) != null ? tmp$ : '';
    }
  });
  Object.defineProperty(RtpTransceiver.prototype, 'sender', {
    configurable: true,
    get: function () {
      return new RtpSender(this.js.sender);
    }
  });
  Object.defineProperty(RtpTransceiver.prototype, 'receiver', {
    configurable: true,
    get: function () {
      return new RtpReceiver(this.js.receiver);
    }
  });
  Object.defineProperty(RtpTransceiver.prototype, 'stopped', {
    configurable: true,
    get: function () {
      return this.js.stopped;
    }
  });
  RtpTransceiver.prototype.stop = function () {
    this.js.stop();
  };
  RtpTransceiver.prototype.toRtpTransceiverDirection_0 = function ($receiver) {
    switch ($receiver) {
      case 'sendrecv':
        return RtpTransceiverDirection$SendRecv_getInstance();
      case 'sendonly':
        return RtpTransceiverDirection$SendOnly_getInstance();
      case 'recvonly':
        return RtpTransceiverDirection$RecvOnly_getInstance();
      case 'inactive':
        return RtpTransceiverDirection$Inactive_getInstance();
      default:
        throw IllegalArgumentException_init('Illegal direction: ' + $receiver);
    }
  };
  RtpTransceiver.prototype.toJs_0 = function ($receiver) {
    switch ($receiver.name) {
      case 'SendRecv':
        return 'sendrecv';
      case 'SendOnly':
        return 'sendonly';
      case 'RecvOnly':
        return 'recvonly';
      case 'Inactive':
        return 'inactive';
      case 'Stopped':
        return 'inactive';
      default:
        return Kotlin.noWhenBranchMatched();
    }
  };
  RtpTransceiver.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RtpTransceiver',
    interfaces: []
  };
  function asJs($receiver) {
    return json([to('type', $receiver.type.name.toLowerCase()), to('sdp', $receiver.sdp)]);
  }
  function asCommon_0($receiver) {
    var $receiver_0 = $receiver.type;
    var tmp$;
    if ($receiver_0.length > 0) {
      var it = toBoxedChar($receiver_0.charCodeAt(0));
      tmp$ = (isLowerCase(unboxChar(it)) ? titlecase(unboxChar(it)) : String.fromCharCode(unboxChar(it))).toString() + $receiver_0.substring(1);
    } else
      tmp$ = $receiver_0;
    var type = SessionDescriptionType$valueOf(tmp$);
    return new SessionDescription(type, $receiver.sdp);
  }
  function VideoStreamTrack(js) {
    MediaStreamTrack.call(this, js);
  }
  VideoStreamTrack.prototype.switchCamera_pdl1vj$ = function (deviceId, continuation) {
    if (deviceId === void 0)
      deviceId = null;
  };
  VideoStreamTrack.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'VideoStreamTrack',
    interfaces: [MediaStreamTrack]
  };
  var getDisplayMedia = defineInlineFunction('webrtc-kmp-webrtc-js-legacy.io.dyte.webrtc.getDisplayMedia_xkgg8p$', function ($receiver) {
    return $receiver.getDisplayMedia();
  });
  var getDisplayMedia_0 = defineInlineFunction('webrtc-kmp-webrtc-js-legacy.io.dyte.webrtc.getDisplayMedia_6wmrwa$', function ($receiver, constraints) {
    return $receiver.getDisplayMedia(constraints);
  });
  var supportsDisplayMedia = defineInlineFunction('webrtc-kmp-webrtc-js-legacy.io.dyte.webrtc.supportsDisplayMedia_xkgg8p$', function ($receiver) {
    return $receiver.getDisplayMedia != null;
  });
  function WebRtc() {
    WebRtc_instance = this;
  }
  WebRtc.prototype.initialize = function () {
  };
  WebRtc.prototype.dispose = function () {
  };
  WebRtc.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'WebRtc',
    interfaces: []
  };
  var WebRtc_instance = null;
  function WebRtc_getInstance() {
    if (WebRtc_instance === null) {
      new WebRtc();
    }
    return WebRtc_instance;
  }
  Object.defineProperty(CameraVideoCapturerException, 'Companion', {
    get: CameraVideoCapturerException$Companion_getInstance
  });
  var package$io = _.io || (_.io = {});
  var package$dyte = package$io.dyte || (package$io.dyte = {});
  var package$webrtc = package$dyte.webrtc || (package$dyte.webrtc = {});
  package$webrtc.CameraVideoCapturerException = CameraVideoCapturerException;
  Object.defineProperty(package$webrtc, 'FLOW_BUFFER_CAPACITY_8be2vx$', {
    get: function () {
      return FLOW_BUFFER_CAPACITY;
    }
  });
  Object.defineProperty(DataChannelState, 'Connecting', {
    get: DataChannelState$Connecting_getInstance
  });
  Object.defineProperty(DataChannelState, 'Open', {
    get: DataChannelState$Open_getInstance
  });
  Object.defineProperty(DataChannelState, 'Closing', {
    get: DataChannelState$Closing_getInstance
  });
  Object.defineProperty(DataChannelState, 'Closed', {
    get: DataChannelState$Closed_getInstance
  });
  package$webrtc.DataChannelState = DataChannelState;
  package$webrtc.MediaDeviceInfo = MediaDeviceInfo;
  Object.defineProperty(MediaDeviceKind, 'VideoInput', {
    get: MediaDeviceKind$VideoInput_getInstance
  });
  Object.defineProperty(MediaDeviceKind, 'AudioInput', {
    get: MediaDeviceKind$AudioInput_getInstance
  });
  package$webrtc.MediaDeviceKind = MediaDeviceKind;
  Object.defineProperty(package$webrtc, 'DEFAULT_VIDEO_WIDTH_8be2vx$', {
    get: function () {
      return DEFAULT_VIDEO_WIDTH;
    }
  });
  Object.defineProperty(package$webrtc, 'DEFAULT_VIDEO_HEIGHT_8be2vx$', {
    get: function () {
      return DEFAULT_VIDEO_HEIGHT;
    }
  });
  Object.defineProperty(package$webrtc, 'DEFAULT_FRAME_RATE_8be2vx$', {
    get: function () {
      return DEFAULT_FRAME_RATE;
    }
  });
  Object.defineProperty(MediaDevices, 'Companion', {
    get: MediaDevices$Companion_getInstance
  });
  package$webrtc.MediaDevices = MediaDevices;
  package$webrtc.toMandatoryMap_nmbs8i$ = toMandatoryMap;
  package$webrtc.toOptionalMap_nmbs8i$ = toOptionalMap;
  package$webrtc.get_audioTracks_90mm5o$ = get_audioTracks;
  package$webrtc.get_videoTracks_90mm5o$ = get_videoTracks;
  package$webrtc.MediaStreamConstraints = MediaStreamConstraints;
  package$webrtc.AudioTrackConstraints = AudioTrackConstraints;
  package$webrtc.VideoTrackConstraints = VideoTrackConstraints;
  package$webrtc.Size = Size;
  Object.defineProperty(FacingMode, 'User', {
    get: FacingMode$User_getInstance
  });
  Object.defineProperty(FacingMode, 'Environment', {
    get: FacingMode$Environment_getInstance
  });
  package$webrtc.FacingMode = FacingMode;
  Object.defineProperty(ResizeMode, 'None', {
    get: ResizeMode$None_getInstance
  });
  Object.defineProperty(ResizeMode, 'CropAndScale', {
    get: ResizeMode$CropAndScale_getInstance
  });
  package$webrtc.ResizeMode = ResizeMode;
  package$webrtc.Constrain = Constrain;
  package$webrtc.MediaStreamConstraintsBuilder = MediaStreamConstraintsBuilder;
  package$webrtc.AudioTrackConstraintsBuilder = AudioTrackConstraintsBuilder;
  package$webrtc.VideoTrackConstraintsBuilder = VideoTrackConstraintsBuilder;
  MediaStreamTrackState.Live = MediaStreamTrackState$Live;
  MediaStreamTrackState.Ended = MediaStreamTrackState$Ended;
  package$webrtc.MediaStreamTrackState = MediaStreamTrackState;
  Object.defineProperty(MediaStreamTrackKind, 'Audio', {
    get: MediaStreamTrackKind$Audio_getInstance
  });
  Object.defineProperty(MediaStreamTrackKind, 'Video', {
    get: MediaStreamTrackKind$Video_getInstance
  });
  package$webrtc.MediaStreamTrackKind = MediaStreamTrackKind;
  package$webrtc.get_muted_8lu6t5$ = get_muted;
  package$webrtc.get_readyState_8lu6t5$ = get_readyState;
  $$importsForInline$$['kotlinx-coroutines-core'] = $module$kotlinx_coroutines_core;
  package$webrtc.get_onEnded_8lu6t5$ = get_onEnded;
  package$webrtc.get_onMute_8lu6t5$ = get_onMute;
  package$webrtc.get_onUnmute_8lu6t5$ = get_onUnmute;
  package$webrtc.OfferAnswerOptions = OfferAnswerOptions;
  package$webrtc.get_onConnectionStateChange_vf4wmm$ = get_onConnectionStateChange;
  package$webrtc.get_onDataChannel_vf4wmm$ = get_onDataChannel;
  package$webrtc.get_onIceCandidate_vf4wmm$ = get_onIceCandidate;
  package$webrtc.get_onIceConnectionStateChange_vf4wmm$ = get_onIceConnectionStateChange;
  package$webrtc.get_onIceGatheringState_vf4wmm$ = get_onIceGatheringState;
  package$webrtc.get_onNegotiationNeeded_vf4wmm$ = get_onNegotiationNeeded;
  package$webrtc.get_onSignalingStateChange_vf4wmm$ = get_onSignalingStateChange;
  package$webrtc.get_onTrack_vf4wmm$ = get_onTrack;
  package$webrtc.get_onStandardizedIceConnection_vf4wmm$ = get_onStandardizedIceConnection;
  package$webrtc.get_onRemovedIceCandidates_vf4wmm$ = get_onRemovedIceCandidates;
  package$webrtc.get_onRemoveTrack_vf4wmm$ = get_onRemoveTrack;
  Object.defineProperty(TlsCertPolicy, 'TlsCertPolicySecure', {
    get: TlsCertPolicy$TlsCertPolicySecure_getInstance
  });
  Object.defineProperty(TlsCertPolicy, 'TlsCertPolicyInsecureNoCheck', {
    get: TlsCertPolicy$TlsCertPolicyInsecureNoCheck_getInstance
  });
  package$webrtc.TlsCertPolicy = TlsCertPolicy;
  Object.defineProperty(KeyType, 'RSA', {
    get: KeyType$RSA_getInstance
  });
  Object.defineProperty(KeyType, 'ECDSA', {
    get: KeyType$ECDSA_getInstance
  });
  package$webrtc.KeyType = KeyType;
  Object.defineProperty(RtcpMuxPolicy, 'Negotiate', {
    get: RtcpMuxPolicy$Negotiate_getInstance
  });
  Object.defineProperty(RtcpMuxPolicy, 'Require', {
    get: RtcpMuxPolicy$Require_getInstance
  });
  package$webrtc.RtcpMuxPolicy = RtcpMuxPolicy;
  Object.defineProperty(BundlePolicy, 'Balanced', {
    get: BundlePolicy$Balanced_getInstance
  });
  Object.defineProperty(BundlePolicy, 'MaxBundle', {
    get: BundlePolicy$MaxBundle_getInstance
  });
  Object.defineProperty(BundlePolicy, 'MaxCompat', {
    get: BundlePolicy$MaxCompat_getInstance
  });
  package$webrtc.BundlePolicy = BundlePolicy;
  Object.defineProperty(IceTransportPolicy, 'None', {
    get: IceTransportPolicy$None_getInstance
  });
  Object.defineProperty(IceTransportPolicy, 'Relay', {
    get: IceTransportPolicy$Relay_getInstance
  });
  Object.defineProperty(IceTransportPolicy, 'NoHost', {
    get: IceTransportPolicy$NoHost_getInstance
  });
  Object.defineProperty(IceTransportPolicy, 'All', {
    get: IceTransportPolicy$All_getInstance
  });
  package$webrtc.IceTransportPolicy = IceTransportPolicy;
  Object.defineProperty(SignalingState, 'Stable', {
    get: SignalingState$Stable_getInstance
  });
  Object.defineProperty(SignalingState, 'HaveLocalOffer', {
    get: SignalingState$HaveLocalOffer_getInstance
  });
  Object.defineProperty(SignalingState, 'HaveLocalPranswer', {
    get: SignalingState$HaveLocalPranswer_getInstance
  });
  Object.defineProperty(SignalingState, 'HaveRemoteOffer', {
    get: SignalingState$HaveRemoteOffer_getInstance
  });
  Object.defineProperty(SignalingState, 'HaveRemotePranswer', {
    get: SignalingState$HaveRemotePranswer_getInstance
  });
  Object.defineProperty(SignalingState, 'Closed', {
    get: SignalingState$Closed_getInstance
  });
  package$webrtc.SignalingState = SignalingState;
  Object.defineProperty(IceConnectionState, 'New', {
    get: IceConnectionState$New_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Checking', {
    get: IceConnectionState$Checking_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Connected', {
    get: IceConnectionState$Connected_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Completed', {
    get: IceConnectionState$Completed_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Failed', {
    get: IceConnectionState$Failed_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Disconnected', {
    get: IceConnectionState$Disconnected_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Closed', {
    get: IceConnectionState$Closed_getInstance
  });
  Object.defineProperty(IceConnectionState, 'Count', {
    get: IceConnectionState$Count_getInstance
  });
  package$webrtc.IceConnectionState = IceConnectionState;
  Object.defineProperty(PeerConnectionState, 'New', {
    get: PeerConnectionState$New_getInstance
  });
  Object.defineProperty(PeerConnectionState, 'Connecting', {
    get: PeerConnectionState$Connecting_getInstance
  });
  Object.defineProperty(PeerConnectionState, 'Connected', {
    get: PeerConnectionState$Connected_getInstance
  });
  Object.defineProperty(PeerConnectionState, 'Disconnected', {
    get: PeerConnectionState$Disconnected_getInstance
  });
  Object.defineProperty(PeerConnectionState, 'Failed', {
    get: PeerConnectionState$Failed_getInstance
  });
  Object.defineProperty(PeerConnectionState, 'Closed', {
    get: PeerConnectionState$Closed_getInstance
  });
  package$webrtc.PeerConnectionState = PeerConnectionState;
  Object.defineProperty(IceGatheringState, 'New', {
    get: IceGatheringState$New_getInstance
  });
  Object.defineProperty(IceGatheringState, 'Gathering', {
    get: IceGatheringState$Gathering_getInstance
  });
  Object.defineProperty(IceGatheringState, 'Complete', {
    get: IceGatheringState$Complete_getInstance
  });
  package$webrtc.IceGatheringState = IceGatheringState;
  PeerConnectionEvent.SignalingStateChange = PeerConnectionEvent$SignalingStateChange;
  PeerConnectionEvent.IceConnectionStateChange = PeerConnectionEvent$IceConnectionStateChange;
  PeerConnectionEvent.StandardizedIceConnectionChange = PeerConnectionEvent$StandardizedIceConnectionChange;
  PeerConnectionEvent.ConnectionStateChange = PeerConnectionEvent$ConnectionStateChange;
  PeerConnectionEvent.IceGatheringStateChange = PeerConnectionEvent$IceGatheringStateChange;
  PeerConnectionEvent.NewIceCandidate = PeerConnectionEvent$NewIceCandidate;
  PeerConnectionEvent.RemovedIceCandidates = PeerConnectionEvent$RemovedIceCandidates;
  PeerConnectionEvent.NewDataChannel = PeerConnectionEvent$NewDataChannel;
  PeerConnectionEvent.RemoveTrack = PeerConnectionEvent$RemoveTrack;
  Object.defineProperty(PeerConnectionEvent, 'NegotiationNeeded', {
    get: PeerConnectionEvent$NegotiationNeeded_getInstance
  });
  PeerConnectionEvent.Track = PeerConnectionEvent$Track;
  package$webrtc.PeerConnectionEvent = PeerConnectionEvent;
  package$webrtc.CommonRtpEncodingParameters = CommonRtpEncodingParameters;
  package$webrtc.CommonRtpTransceiverInit = CommonRtpTransceiverInit;
  Object.defineProperty(RtpTransceiverDirection, 'SendRecv', {
    get: RtpTransceiverDirection$SendRecv_getInstance
  });
  Object.defineProperty(RtpTransceiverDirection, 'SendOnly', {
    get: RtpTransceiverDirection$SendOnly_getInstance
  });
  Object.defineProperty(RtpTransceiverDirection, 'RecvOnly', {
    get: RtpTransceiverDirection$RecvOnly_getInstance
  });
  Object.defineProperty(RtpTransceiverDirection, 'Inactive', {
    get: RtpTransceiverDirection$Inactive_getInstance
  });
  Object.defineProperty(RtpTransceiverDirection, 'Stopped', {
    get: RtpTransceiverDirection$Stopped_getInstance
  });
  package$webrtc.RtpTransceiverDirection = RtpTransceiverDirection;
  package$webrtc.SessionDescription = SessionDescription;
  Object.defineProperty(SessionDescriptionType, 'Offer', {
    get: SessionDescriptionType$Offer_getInstance
  });
  Object.defineProperty(SessionDescriptionType, 'Pranswer', {
    get: SessionDescriptionType$Pranswer_getInstance
  });
  Object.defineProperty(SessionDescriptionType, 'Answer', {
    get: SessionDescriptionType$Answer_getInstance
  });
  Object.defineProperty(SessionDescriptionType, 'Rollback', {
    get: SessionDescriptionType$Rollback_getInstance
  });
  package$webrtc.SessionDescriptionType = SessionDescriptionType;
  package$webrtc.TrackEvent = TrackEvent;
  package$webrtc.AudioStreamTrack = AudioStreamTrack;
  package$webrtc.DataChannel = DataChannel;
  package$webrtc.DtmfSender = DtmfSender;
  package$webrtc.IceCandidate_init_h6sd2a$ = IceCandidate_init;
  package$webrtc.IceCandidate = IceCandidate;
  package$webrtc.IceServer = IceServer;
  Object.defineProperty(package$webrtc, 'mediaDevices_8be2vx$', {
    get: function () {
      return mediaDevices;
    }
  });
  $$importsForInline$$['webrtc-kmp-webrtc-js-legacy'] = _;
  package$webrtc.MediaStream = MediaStream;
  package$webrtc.MediaStreamTrack = MediaStreamTrack;
  package$webrtc.asCommon_11mmmu$ = asCommon;
  package$webrtc.PeerConnection = PeerConnection;
  Object.defineProperty(RtcCertificatePem, 'Companion', {
    get: RtcCertificatePem$Companion_getInstance
  });
  package$webrtc.RtcCertificatePem = RtcCertificatePem;
  package$webrtc.RtcConfiguration = RtcConfiguration;
  package$webrtc.RtcStats = RtcStats;
  package$webrtc.RtcStatsReport = RtcStatsReport;
  package$webrtc.RtpParameters = RtpParameters;
  package$webrtc.RtpCodecParameters = RtpCodecParameters;
  package$webrtc.RtcpParameters = RtcpParameters;
  package$webrtc.RtpEncodingParameters = RtpEncodingParameters;
  package$webrtc.HeaderExtension = HeaderExtension;
  package$webrtc.RtpReceiver = RtpReceiver;
  package$webrtc.RtpSender = RtpSender;
  package$webrtc.RtpTransceiver = RtpTransceiver;
  package$webrtc.asJs_n17om3$ = asJs;
  package$webrtc.asCommon_trjafg$ = asCommon_0;
  package$webrtc.VideoStreamTrack = VideoStreamTrack;
  package$webrtc.getDisplayMedia_xkgg8p$ = getDisplayMedia;
  package$webrtc.getDisplayMedia_6wmrwa$ = getDisplayMedia_0;
  package$webrtc.supportsDisplayMedia_xkgg8p$ = supportsDisplayMedia;
  Object.defineProperty(package$webrtc, 'WebRtc', {
    get: WebRtc_getInstance
  });
  MediaDevices$Companion.prototype.getUserMedia_jgsmsx$ = MediaDevices.prototype.getUserMedia_jgsmsx$;
  MediaDevices$Companion.prototype.getUserMedia_dqye30$ = MediaDevices.prototype.getUserMedia_dqye30$;
  MediaDevicesImpl.prototype.getUserMedia_dqye30$$default = MediaDevices.prototype.getUserMedia_dqye30$$default;
  MediaDevicesImpl.prototype.getUserMedia_jgsmsx$ = MediaDevices.prototype.getUserMedia_jgsmsx$;
  MediaDevicesImpl.prototype.getUserMedia_dqye30$ = MediaDevices.prototype.getUserMedia_dqye30$;
  FLOW_BUFFER_CAPACITY = 64;
  DEFAULT_VIDEO_WIDTH = 1280;
  DEFAULT_VIDEO_HEIGHT = 720;
  DEFAULT_FRAME_RATE = 30;
  mediaDevices = MediaDevicesImpl_getInstance();
  Kotlin.defineModule('webrtc-kmp-webrtc-js-legacy', _);
  return _;
}(module.exports, require('kotlin'), require('kotlinx-coroutines-core'), require('webrtc-adapter')));

//# sourceMappingURL=webrtc-kmp-webrtc-js-legacy.js.map
