package io.dyte.webrtc

import DyteWebRTC.DyteRTCRtcpParameters
import DyteWebRTC.DyteRTCRtpCodecParameters
import DyteWebRTC.DyteRTCRtpEncodingParameters
import DyteWebRTC.DyteRTCRtpHeaderExtension
import DyteWebRTC.DyteRTCRtpParameters

actual class RtpParameters(val native: DyteRTCRtpParameters) {
  actual var codecs: MutableList<RtpCodecParameters> = arrayListOf()
    get() =
      native.codecs.map { RtpCodecParameters(it as DyteRTCRtpCodecParameters) }.toMutableList()

  actual var encodings: List<RtpEncodingParameters> = emptyList()
    get() = native.encodings.map { RtpEncodingParameters(it as DyteRTCRtpEncodingParameters) }

  actual var headerExtension: MutableList<HeaderExtension> = arrayListOf()
    get() =
      native.headerExtensions
        .map { HeaderExtension(it as DyteRTCRtpHeaderExtension) }
        .toMutableList()

  actual val rtcp: RtcpParameters
    get() = RtcpParameters(native.rtcp)

  actual var transactionId: String = ""
    get() = native.transactionId
}

actual class RtpCodecParameters(val native: DyteRTCRtpCodecParameters) {
  actual var payloadType: Int = 0
    get() = native.payloadType

  actual val mimeType: String?
    get() = "${native.kind}/${native.name}"

  actual val clockRate: Int?
    get() = native.clockRate?.intValue

  actual var numChannels: Int? = null
    get() = native.numChannels?.intValue

  actual val parameters: MutableMap<String, String>
    get() = native.parameters.map { (k, v) -> "$k" to "$v" }.toMap().toMutableMap()

  actual fun setRtpCodecParameters(
    payloadType: Int,
    mimeType: String?,
    clockRate: Int?,
    numChannels: Int?,
    parameters: MutableMap<String, String>
  ) {
    //        native.payloadType = payloadType
    //        //native.mimeType = mimeType
    //        native.clockRate = clockRate
    //        native.numChannels = numChannels
    //        native.parameters = parameters
  }
}

actual class RtpEncodingParameters(val native: DyteRTCRtpEncodingParameters) {
  actual var rid: String? = null
    get() = native.rid

  actual var active: Boolean = false
    get() = native.isActive

  actual var bitratePriority: Double = 0.0
    get() {
      // not implemented
      return 0.0
    }

  actual var networkPriority: Int = -1
    get() {
      // not implemented
      return 0
    }

  actual var maxBitrateBps: Int? = null
    get() = native.maxBitrateBps?.intValue

  actual var minBitrateBps: Int? = null
    get() = native.minBitrateBps?.intValue

  actual var maxFramerate: Int? = null
    get() = native.maxFramerate?.intValue

  actual val numTemporalLayers: Int?
    get() = native.numTemporalLayers?.intValue

  actual var scaleResolutionDownBy: Double? = null
    get() = native.scaleResolutionDownBy?.doubleValue

  actual val ssrc: Long?
    get() = native.ssrc?.longValue

  actual fun setRtpEncodingParameters(
    rid: String?,
    active: Boolean,
    bitratePriority: Double,
    networkPriority: Int,
    maxBitrateBps: Int?,
    minBitrateBps: Int?,
    maxFramerate: Int?,
    numTemporalLayers: Int?,
    scaleResolutionDownBy: Double?,
    ssrc: Long?
  ) {
    //        native.rid = rid
    //        native.active = active
    //        native.bitratePriority = bitratePriority
    //        native.networkPriority = networkPriority
    //        native.maxBitrateBps = maxBitrateBps
    //        native.minBitrateBps = minBitrateBps
    //        native.maxFramerate = maxFramerate
    //        native.numTemporalLayers = numTemporalLayers
    //        native.scaleResolutionDownBy = scaleResolutionDownBy
    //        native.ssrc = ssrc
  }
}

actual class HeaderExtension(val native: DyteRTCRtpHeaderExtension) {
  actual val uri: String
    get() = native.uri

  actual val id: Int
    get() = native.id

  actual var encrypted: Boolean = false
    get() = native.encrypted
}

actual class RtcpParameters(val native: DyteRTCRtcpParameters) {
  actual var cname: String = ""
    get() = native.cname

  actual var reducedSize: Boolean? = null
    get() = native.isReducedSize
}
